/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base;

import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.FcDataConverter;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.FcInfoContext;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.TaskContext;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.net.cmd.PortGroupCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.img.cmd.CreateVmByImgCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.img.cmd.OsCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template.cmd.CreateVmByTemplateCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template.cmd.RouteInfoCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template.cmd.UploadTemplateCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template.cmd.VmNicConfigCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.host.Host;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.net.protgroup.cmd.CreatePortGroup;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.os.OsQuery;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.os.OsVersion;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.site.Site;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.VmDetail;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.cmd.CreateVm;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.cmd.clone.NicSpecification;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.cmd.clone.RouteInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.cmd.clone.VmClone;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.cmd.clone.VmCustomization;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.config.OsOptions;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.template.TemplateFileItem;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.template.TemplateInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.template.cmd.ImportTemplate;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.template.cmd.ParseTemplate;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshConnInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class FcDataConverterImpl
implements FcDataConverter {
    @Override
    public CreatePortGroup toCreatePortGroup(PortGroupCmd portGroupCmd) {
        if (portGroupCmd == null) {
            return null;
        }
        CreatePortGroup.CreatePortGroupBuilder createPortGroup = CreatePortGroup.builder();
        createPortGroup.name(portGroupCmd.getName());
        createPortGroup.vlanId(String.valueOf(portGroupCmd.getVlanId()));
        return createPortGroup.build();
    }

    @Override
    public ParseTemplate toParseCmd(String url, String ovfDescriptor) {
        if (url == null && ovfDescriptor == null) {
            return null;
        }
        ParseTemplate.ParseTemplateBuilder parseTemplate = ParseTemplate.builder();
        parseTemplate.url(url);
        parseTemplate.ovfDescriptor(ovfDescriptor);
        return parseTemplate.build();
    }

    @Override
    public ImportTemplate toImportTemplate(UploadTemplateCmd cmd, String parentObjUrn, TemplateInfo template, Host host) {
        if (cmd == null && parentObjUrn == null && template == null && host == null) {
            return null;
        }
        ImportTemplate.ImportTemplateBuilder<?, ?> importTemplate = ImportTemplate.builder();
        if (cmd != null) {
            importTemplate.name(cmd.getTemplateName());
            importTemplate.url(this.toUrl(cmd));
        }
        if (template != null) {
            importTemplate.osOptions(template.getOsOptions());
            importTemplate.vmConfig(template.getVmConfig());
            importTemplate.imageFormat(template.getImageFormat());
            List<TemplateFileItem> list = template.getFileItems();
            if (list != null) {
                importTemplate.fileItems(new ArrayList<TemplateFileItem>(list));
            }
        }
        if (host != null) {
            importTemplate.location(host.getUrn());
            importTemplate.cpuVendor(host.getCpuVendor());
        }
        importTemplate.parentObjUrn(parentObjUrn);
        return importTemplate.build();
    }

    @Override
    public VmClone buildVmClone(CreateVmByTemplateCmd cmd, FcInfoContext context, VmDetail vmDetail) {
        if (cmd == null && context == null && vmDetail == null) {
            return null;
        }
        VmClone.VmCloneBuilder<?, ?> vmClone = VmClone.builder();
        if (cmd != null) {
            vmClone.name(cmd.getVmName());
            vmClone.isBindingHost(cmd.isBindingHost());
        }
        if (context != null) {
            vmClone.parentObjUrn(this.contextSiteUrn(context));
        }
        if (vmDetail != null) {
            vmClone.osOptions(vmDetail.getOsOptions());
            vmClone.vmConfig(vmDetail.getVmConfig());
        }
        vmClone.vmCustomization(this.toCustomization(cmd, vmDetail));
        vmClone.location(context.getHostByName(cmd.getCnaName()).getUrn());
        vmClone.cpuVendor(context.getHostByName(cmd.getCnaName()).getCpuVendor());
        vmClone.isAutoBoot(false);
        return vmClone.build();
    }

    @Override
    public VmCustomization toCustomization(CreateVmByTemplateCmd cmd, VmDetail vmDetail) {
        if (cmd == null && vmDetail == null) {
            return null;
        }
        VmCustomization.VmCustomizationBuilder vmCustomization = VmCustomization.builder();
        if (cmd != null) {
            vmCustomization.hostname(cmd.getHostName());
            vmCustomization.password(cmd.getPassword());
        }
        if (vmDetail != null) {
            vmCustomization.osType(this.vmDetailOsOptionsOsType(vmDetail));
        }
        vmCustomization.nicSpecification(this.toNic(cmd.getNicConfigs()));
        vmCustomization.updatePassword(StringUtils.isNotEmpty((CharSequence)cmd.getPassword()));
        return vmCustomization.build();
    }

    @Override
    public NicSpecification toNic(VmNicConfigCmd configCmd, int sequenceNum) {
        if (configCmd == null) {
            return null;
        }
        NicSpecification.NicSpecificationBuilder nicSpecification = NicSpecification.builder();
        if (configCmd != null) {
            nicSpecification.ip(configCmd.getIp());
            nicSpecification.netmask(configCmd.getNetmask());
            nicSpecification.gateway(configCmd.getGateway());
        }
        nicSpecification.sequenceNum(sequenceNum);
        nicSpecification.route4Infos(this.toRouteInfoList(configCmd.getRouteInfo()));
        return nicSpecification.build();
    }

    @Override
    public RouteInfo toRouteInfo(RouteInfoCmd infoCmd) {
        if (infoCmd == null) {
            return null;
        }
        RouteInfo.RouteInfoBuilder routeInfo = RouteInfo.builder();
        routeInfo.routeGateway(infoCmd.getRouteGateway());
        routeInfo.destination(infoCmd.getDestination());
        routeInfo.genmask(infoCmd.getGenmask());
        return routeInfo.build();
    }

    @Override
    public TemplateInfo toTemplateInfo(OsVersion osVersion, TaskContext taskContext, String imageFormat) {
        if (osVersion == null && taskContext == null && imageFormat == null) {
            return null;
        }
        TemplateInfo templateInfo = new TemplateInfo();
        templateInfo.setOsOptions(this.toOsOption(osVersion));
        templateInfo.setImageFormat(imageFormat);
        templateInfo.setFileItems(Collections.singletonList(new TemplateFileItem(imageFormat)));
        templateInfo.setVmConfig(this.toVmConfig(osVersion, taskContext));
        return templateInfo;
    }

    @Override
    public CreateVm toCreateVm(CreateVmByImgCmd cmd, OsVersion osVersion, TaskContext taskContext) {
        if (cmd == null && osVersion == null && taskContext == null) {
            return null;
        }
        CreateVm.CreateVmBuilder<?, ?> createVm = CreateVm.builder();
        if (cmd != null) {
            createVm.name(cmd.getVmName());
        }
        createVm.osOptions(this.toOsOption(osVersion));
        createVm.location(taskContext.getHost().getUrn());
        createVm.cpuVendor(taskContext.getHost().getCpuVendor());
        createVm.parentObjUrn(FcInfoContext.get().getSite().getUrn());
        createVm.vmConfig(this.toVmConfig(taskContext, cmd.getCpuCores(), cmd.getMemorySizeGb() * 1024, cmd.getDisks()));
        return createVm.build();
    }

    @Override
    public OsOptions toOsOption(OsVersion osVersion) {
        if (osVersion == null) {
            return null;
        }
        OsOptions osOptions = new OsOptions();
        osOptions.setOsVersion(osVersion.getId());
        osOptions.setGuestOSName(osVersion.getVersionDes());
        osOptions.setOsType(StringUtils.capitalize((String)osVersion.getOsType()));
        return osOptions;
    }

    @Override
    public SshConnInfo toSShConnInfo(OsCmd cmd) {
        if (cmd == null) {
            return null;
        }
        SshConnInfo.Builder sshConnInfo = SshConnInfo.builder();
        sshConnInfo.hostName(cmd.getIp());
        sshConnInfo.userName(cmd.getUserName());
        sshConnInfo.userPwd(cmd.getUserPwd());
        return sshConnInfo.build();
    }

    @Override
    public OsQuery toOsQuery(Host host) {
        if (host == null) {
            return null;
        }
        OsQuery.OsQueryBuilder osQuery = OsQuery.builder();
        osQuery.arch(host.getArch());
        osQuery.cpuVendor(host.getCpuVendor());
        osQuery.osVendor(host.getOsVendor());
        return osQuery.build();
    }

    private String contextSiteUrn(FcInfoContext fcInfoContext) {
        if (fcInfoContext == null) {
            return null;
        }
        Site site = fcInfoContext.getSite();
        if (site == null) {
            return null;
        }
        String urn = site.getUrn();
        if (urn == null) {
            return null;
        }
        return urn;
    }

    private String vmDetailOsOptionsOsType(VmDetail vmDetail) {
        if (vmDetail == null) {
            return null;
        }
        OsOptions osOptions = vmDetail.getOsOptions();
        if (osOptions == null) {
            return null;
        }
        String osType = osOptions.getOsType();
        if (osType == null) {
            return null;
        }
        return osType;
    }
}

