/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base;

import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.client.ApiClient;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.client.ApiClientImpl;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.exception.ApiError;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.exception.CustomError;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.exception.FcTaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.FcLoginInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.FcRequestApi;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.base.FcEntityBase;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.datastore.DataStore;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.host.Host;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.net.protgroup.PortGroup;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.site.Site;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.user.UserLogin;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.support.FcRequestInterceptor;
import com.huawei.yinglong.river.sitedeployment.dcs.http.HttpRequestApiFactory;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import okhttp3.Interceptor;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FcInfoContext {
    private static final ThreadLocal<FcInfoContext> CONTEXT = new ThreadLocal();
    private Site site;
    private List<Host> hosts;
    private List<DataStore> dataStores;
    private List<PortGroup> portGroups;
    private ApiClient service;
    private String token;

    @NotNull
    public static FcInfoContext get() {
        if (CONTEXT.get() == null) {
            CONTEXT.set(new FcInfoContext());
        }
        return CONTEXT.get();
    }

    public static void clear() {
        CONTEXT.remove();
    }

    public void init(@NotNull FcLoginInfo fcLoginInfo) {
        FcRequestApi requestApi = (FcRequestApi)HttpRequestApiFactory.createRequestApi((String)fcLoginInfo.getUrl(), FcRequestApi.class, (Interceptor[])new Interceptor[]{new FcRequestInterceptor(() -> this.updateAndGetToken(fcLoginInfo))});
        this.service = new ApiClientImpl(requestApi);
        this.updateAndGetToken(fcLoginInfo);
        this.site = this.service.getSite();
    }

    private String updateAndGetToken(FcLoginInfo loginInfo) {
        this.token = this.service.login(new UserLogin(loginInfo.getUser(), loginInfo.getPassword(), loginInfo.getUserType()));
        return this.token;
    }

    @NotNull
    public Host getHostByName(@Nullable String hostName) {
        if (CollectionUtils.isEmpty(this.hosts)) {
            throw new FcTaskException(CustomError.SYSTEM_ERROR, new Object[0]);
        }
        return this.hosts.stream().filter(host -> host.getName().equals(hostName)).findFirst().orElseThrow(FcTaskException.thr(ApiError.CNA_NOT_EXIST));
    }

    @NotNull
    public DataStore getDataStoreByName(@NotNull String dateStoreName) {
        if (CollectionUtils.isEmpty(this.dataStores)) {
            throw new FcTaskException(CustomError.SYSTEM_ERROR, new Object[0]);
        }
        return this.dataStores.stream().filter(store -> dateStoreName.equals(store.getName())).findFirst().orElseThrow(FcTaskException.thr(ApiError.DATA_STORE_NOT_EXIST));
    }

    public List<DataStore> getDataStoresOfHost(@NotNull String hostName) {
        if (CollectionUtils.isEmpty(this.dataStores)) {
            throw new FcTaskException(CustomError.SYSTEM_ERROR, new Object[0]);
        }
        return this.dataStores.stream().filter(dataStore -> dataStore.isBelongHost(this.getHostByName(hostName).getUrn())).collect(Collectors.toList());
    }

    public DataStore getDatastoreByNameOrMax(String datastoreName, @NotNull String cnaName) {
        return StringUtils.isNotEmpty((CharSequence)datastoreName) ? this.getDataStoreByNameAndHost(datastoreName, cnaName) : this.getMaxDataStoreOfHost(cnaName);
    }

    @NotNull
    public DataStore getMaxDataStoreOfHost(@NotNull String hostName) {
        return this.getDataStoresOfHost(hostName).stream().max(Comparator.comparingInt(DataStore::getFreeSizeGB)).orElseThrow(FcTaskException.thr(CustomError.SYSTEM_ERROR));
    }

    @NotNull
    public String getSiteId() {
        return Optional.ofNullable(this.site).map(FcEntityBase::getId).orElseThrow(FcTaskException.thr(CustomError.SYSTEM_ERROR));
    }

    public PortGroup getPortGroupByName(@NotNull String name) {
        if (CollectionUtils.isEmpty(this.portGroups)) {
            throw new FcTaskException(CustomError.SYSTEM_ERROR, new Object[0]);
        }
        return this.portGroups.stream().filter(portGroup -> name.equals(portGroup.getName())).findFirst().orElseThrow(FcTaskException.thr(ApiError.PORT_GROUP_NOT_EXIST));
    }

    public DataStore getDataStoreByNameAndHost(@NotNull String datastoreName, @NotNull String cnaName) {
        DataStore dataStore = this.getDataStoreByName(datastoreName);
        if (!dataStore.isBelongHost(this.getHostByName(cnaName).getUrn())) {
            throw new FcTaskException(ApiError.CNA_HOST_NOT_MATCH, new Object[0]);
        }
        return dataStore;
    }

    public DataStore getDataStoreByUrn(@NotNull String urn) {
        if (CollectionUtils.isEmpty(this.dataStores)) {
            throw new FcTaskException(CustomError.SYSTEM_ERROR, new Object[0]);
        }
        return this.dataStores.stream().filter(store -> urn.equals(store.getUrn())).findFirst().orElseThrow(FcTaskException.thr(ApiError.DATA_STORE_NOT_EXIST));
    }

    public int getUsableCpuCore(String cnaName, int magnification) {
        return this.getHosts().stream().filter(host -> host.getName().equals(cnaName)).map(host -> host.getCpuTotalCores() == 0 ? Integer.MAX_VALUE : host.getCpuTotalCores() * magnification - host.getCpuUsedCores()).findFirst().orElseThrow(() -> new FcTaskException(ApiError.CNA_HOST_NOT_MATCH, new Object[0]));
    }

    public int getRemainMemSizeMb(String cnaName, int magnification) {
        return this.getHosts().stream().filter(host -> host.getName().equals(cnaName)).map(host -> host.getMemTotalSizeMB() == 0 ? Integer.MAX_VALUE : host.getMemTotalSizeMB() * magnification - host.getMemUsedSizeMB()).findFirst().orElseThrow(() -> new FcTaskException(ApiError.CNA_HOST_NOT_MATCH, new Object[0]));
    }

    @Generated
    public Site getSite() {
        return this.site;
    }

    @Generated
    public List<Host> getHosts() {
        return this.hosts;
    }

    @Generated
    public List<DataStore> getDataStores() {
        return this.dataStores;
    }

    @Generated
    public List<PortGroup> getPortGroups() {
        return this.portGroups;
    }

    @Generated
    public ApiClient getService() {
        return this.service;
    }

    @Generated
    public String getToken() {
        return this.token;
    }

    @Generated
    public void setSite(Site site) {
        this.site = site;
    }

    @Generated
    public void setHosts(List<Host> hosts) {
        this.hosts = hosts;
    }

    @Generated
    public void setDataStores(List<DataStore> dataStores) {
        this.dataStores = dataStores;
    }

    @Generated
    public void setPortGroups(List<PortGroup> portGroups) {
        this.portGroups = portGroups;
    }

    @Generated
    public void setService(ApiClient service) {
        this.service = service;
    }

    @Generated
    public void setToken(String token) {
        this.token = token;
    }

    @Generated
    private FcInfoContext() {
    }
}

