/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.disk;

import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.client.ApiClient;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.exception.ApiError;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.exception.FcTaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.FcBaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.FcInfoContext;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.disk.cmd.AttachDiskCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.disk.cmd.DiskCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.datastore.DataStore;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.VmDetail;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.disk.AttachDisk;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;

public class AttachDiskTask
extends FcBaseTask<AttachDiskCmd> {
    public static final String NAME_KEY = "attach.disk";

    public void execute() throws TaskException {
        if (CollectionUtils.isEmpty(((AttachDiskCmd)this.cmd).getDiskCmds())) {
            return;
        }
        ((AttachDiskCmd)this.cmd).getDiskCmds().forEach(this::attachDisk);
    }

    private void attachDisk(DiskCmd diskCmd) {
        FcInfoContext context = FcInfoContext.get();
        DataStore dataStore = context.getDataStoreByName(diskCmd.getDateStoreName());
        if (!dataStore.isUseSizeSuccess(diskCmd.getQuantityGB())) {
            throw new FcTaskException(ApiError.DATA_STORE_INSUFFICIENT, new Object[0]);
        }
        AttachDisk attachDisk = new AttachDisk(dataStore, diskCmd.getQuantityGB(), diskCmd.getName());
        ApiClient service = context.getService();
        VmDetail vmDetail = service.getVmDetail(((AttachDiskCmd)this.cmd).getVmId().get());
        String hostId = StringUtils.isNotEmpty((CharSequence)vmDetail.getHostUrn()) ? vmDetail.getHostId() : context.getHostByName(((AttachDiskCmd)this.cmd).getHostName()).getId();
        if (dataStore.isHostProtocolNvme(hostId)) {
            attachDisk.setStorageProtocol("1");
        }
        service.attachDisk(((AttachDiskCmd)this.cmd).getVmId().get(), attachDisk);
    }

    @Generated
    protected AttachDiskTask(AttachDiskTaskBuilder<?, ?> b) {
        super(b);
    }

    @Generated
    public static AttachDiskTaskBuilder<?, ?> builder() {
        return new AttachDiskTaskBuilderImpl();
    }

    @Generated
    private static final class AttachDiskTaskBuilderImpl
    extends AttachDiskTaskBuilder<AttachDiskTask, AttachDiskTaskBuilderImpl> {
        @Generated
        private AttachDiskTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected AttachDiskTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AttachDiskTask build() {
            return new AttachDiskTask(this);
        }
    }

    @Generated
    public static abstract class AttachDiskTaskBuilder<C extends AttachDiskTask, B extends AttachDiskTaskBuilder<C, B>>
    extends FcBaseTask.FcBaseTaskBuilder<AttachDiskCmd, C, B> {
        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "AttachDiskTask.AttachDiskTaskBuilder(super=" + super.toString() + ")";
        }
    }
}

