/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.enviroment;

import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.client.ApiClient;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.exception.ApiError;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.exception.FcTaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.FcBaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.FcInfoContext;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.enviroment.cmd.EnvironmentCheckCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.datastore.DataStore;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentCheckTask
extends FcBaseTask<EnvironmentCheckCmd> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EnvironmentCheckTask.class);
    public static final String NAME_KEY = "environment.check";

    @Override
    public void beforeExecute() {
        if (Objects.nonNull(this.supplierCmd)) {
            this.cmd = this.supplierCmd.get();
        }
        FcInfoContext context = this.getInitFcInfoContext();
        ApiClient service = context.getService();
        if (Objects.nonNull(((EnvironmentCheckCmd)this.cmd).getOldVmIds()) && CollectionUtils.isNotEmpty((Collection)((EnvironmentCheckCmd)this.cmd).getOldVmIds().get())) {
            ((EnvironmentCheckCmd)this.cmd).getOldVmIds().get().forEach(vmId -> this.deleteVm((String)vmId, service));
        }
        this.fillContext(context);
    }

    public void execute() throws TaskException {
        ((EnvironmentCheckCmd)this.cmd).getCpuReservation().forEach(this::tryUseCpuCore);
        ((EnvironmentCheckCmd)this.cmd).getMemoryReservation().forEach(this::tryUseMemSize);
        ((EnvironmentCheckCmd)this.cmd).getDataStoreReservation().forEach(this::tryUseDataStore);
        ((EnvironmentCheckCmd)this.cmd).getDiskReservation().asMap().forEach(this::tryUseDiskResource);
    }

    private void tryUseMemSize(String cnaName, int memSizeGb) {
        if (FcInfoContext.get().getRemainMemSizeMb(cnaName, ((EnvironmentCheckCmd)this.cmd).getMemoryMagnification()) < memSizeGb * 1024) {
            throw new FcTaskException(ApiError.MEM_INSUFFICIENT, new Object[0]);
        }
    }

    private void tryUseCpuCore(String cnaName, int cpuCore) {
        if (FcInfoContext.get().getUsableCpuCore(cnaName, ((EnvironmentCheckCmd)this.cmd).getCpuMagnification()) < cpuCore) {
            throw new FcTaskException(ApiError.CPU_INSUFFICIENT, new Object[0]);
        }
    }

    private void tryUseDataStore(String datastoreName, int reservation) {
        if (!FcInfoContext.get().getDataStoreByName(datastoreName).isUseSizeSuccess(reservation)) {
            throw new FcTaskException(ApiError.DATA_STORE_INSUFFICIENT, new Object[0]);
        }
    }

    private void tryUseDiskResource(String cnaName, Collection<Integer> reservations) {
        List dataStores = FcInfoContext.get().getDataStoresOfHost(cnaName).stream().sorted(Comparator.comparingInt(DataStore::getFreeSizeGB)).collect(Collectors.toList());
        reservations.stream().sorted().forEach(sizeGb -> this.useDiskResource(dataStores, (int)sizeGb));
    }

    private void useDiskResource(List<DataStore> dataStores, int sizeGb) {
        if (dataStores.stream().noneMatch(dataStore -> dataStore.isUseSizeSuccess(sizeGb))) {
            throw new FcTaskException(ApiError.DATA_STORE_INSUFFICIENT, new Object[0]);
        }
    }

    private void deleteVm(String vmId, ApiClient service) {
        try {
            service.deleteVm(vmId);
            this.appendTaskDetail(StringUtils.formatTxt((String)"delete vm %s", (Object[])new Object[]{vmId}));
        }
        catch (FcTaskException e) {
            this.appendTaskDetail(StringUtils.formatTxt((String)"delete vm %s failed", (Object[])new Object[]{vmId}));
            log.error("Failed to delete vm {}", (Object)vmId, (Object)e);
        }
    }

    @Generated
    protected EnvironmentCheckTask(EnvironmentCheckTaskBuilder<?, ?> b) {
        super(b);
    }

    @Generated
    public static EnvironmentCheckTaskBuilder<?, ?> builder() {
        return new EnvironmentCheckTaskBuilderImpl();
    }

    @Generated
    private static final class EnvironmentCheckTaskBuilderImpl
    extends EnvironmentCheckTaskBuilder<EnvironmentCheckTask, EnvironmentCheckTaskBuilderImpl> {
        @Generated
        private EnvironmentCheckTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected EnvironmentCheckTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public EnvironmentCheckTask build() {
            return new EnvironmentCheckTask(this);
        }
    }

    @Generated
    public static abstract class EnvironmentCheckTaskBuilder<C extends EnvironmentCheckTask, B extends EnvironmentCheckTaskBuilder<C, B>>
    extends FcBaseTask.FcBaseTaskBuilder<EnvironmentCheckCmd, C, B> {
        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "EnvironmentCheckTask.EnvironmentCheckTaskBuilder(super=" + super.toString() + ")";
        }
    }
}

