/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.enviroment.cmd;

import com.google.common.collect.ArrayListMultimap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnvironmentCheckCmd {
    @Nullable
    private final Supplier<List<String>> oldVmIds;
    private final int cpuMuxRatio;
    private final int memoryMuxRatio;
    @NotNull
    private final Map<String, Integer> cpuReservation;
    @NotNull
    private final Map<String, Integer> memoryReservation;
    @NotNull
    private final Map<String, Integer> dataStoreReservation;
    @NotNull
    private final ArrayListMultimap<String, Integer> diskReservation;
    private final int memoryMagnification;
    private final int cpuMagnification;

    public EnvironmentCheckCmd addCpu(@NotNull String cnaName, int value) {
        this.updateReservation(cnaName, value, this.cpuReservation);
        return this;
    }

    public EnvironmentCheckCmd addMemory(@NotNull String cnaName, int value) {
        this.updateReservation(cnaName, value, this.memoryReservation);
        return this;
    }

    public EnvironmentCheckCmd addDatastore(@NotNull String datastoreName, int value) {
        this.updateReservation(datastoreName, value, this.dataStoreReservation);
        return this;
    }

    public EnvironmentCheckCmd addDisk(@NotNull String cnaName, int value) {
        if (value > 0) {
            this.diskReservation.put((Object)cnaName, (Object)value);
        }
        return this;
    }

    private void updateReservation(String newKey, int value, Map<String, Integer> reservation) {
        if (value < 0) {
            throw new IllegalArgumentException("value must not be less than 0");
        }
        reservation.compute(newKey, (originKey, origin) -> origin == null ? value : origin + value);
    }

    @Generated
    private static Map<String, Integer> $default$cpuReservation() {
        return new HashMap<String, Integer>();
    }

    @Generated
    private static Map<String, Integer> $default$memoryReservation() {
        return new HashMap<String, Integer>();
    }

    @Generated
    private static Map<String, Integer> $default$dataStoreReservation() {
        return new HashMap<String, Integer>();
    }

    @Generated
    private static ArrayListMultimap<String, Integer> $default$diskReservation() {
        return ArrayListMultimap.create();
    }

    @Generated
    private static int $default$memoryMagnification() {
        return 1;
    }

    @Generated
    private static int $default$cpuMagnification() {
        return 3;
    }

    @Generated
    EnvironmentCheckCmd(@Nullable Supplier<List<String>> oldVmIds, int cpuMuxRatio, int memoryMuxRatio, @NotNull Map<String, Integer> cpuReservation, @NotNull Map<String, Integer> memoryReservation, @NotNull Map<String, Integer> dataStoreReservation, @NotNull ArrayListMultimap<String, Integer> diskReservation, int memoryMagnification, int cpuMagnification) {
        if (cpuReservation == null) {
            throw new NullPointerException("cpuReservation is marked non-null but is null");
        }
        if (memoryReservation == null) {
            throw new NullPointerException("memoryReservation is marked non-null but is null");
        }
        if (dataStoreReservation == null) {
            throw new NullPointerException("dataStoreReservation is marked non-null but is null");
        }
        if (diskReservation == null) {
            throw new NullPointerException("diskReservation is marked non-null but is null");
        }
        this.oldVmIds = oldVmIds;
        this.cpuMuxRatio = cpuMuxRatio;
        this.memoryMuxRatio = memoryMuxRatio;
        this.cpuReservation = cpuReservation;
        this.memoryReservation = memoryReservation;
        this.dataStoreReservation = dataStoreReservation;
        this.diskReservation = diskReservation;
        this.memoryMagnification = memoryMagnification;
        this.cpuMagnification = cpuMagnification;
    }

    @Generated
    public static EnvironmentCheckCmdBuilder builder() {
        return new EnvironmentCheckCmdBuilder();
    }

    @Nullable
    @Generated
    public Supplier<List<String>> getOldVmIds() {
        return this.oldVmIds;
    }

    @Generated
    public int getCpuMuxRatio() {
        return this.cpuMuxRatio;
    }

    @Generated
    public int getMemoryMuxRatio() {
        return this.memoryMuxRatio;
    }

    @NotNull
    @Generated
    public Map<String, Integer> getCpuReservation() {
        return this.cpuReservation;
    }

    @NotNull
    @Generated
    public Map<String, Integer> getMemoryReservation() {
        return this.memoryReservation;
    }

    @NotNull
    @Generated
    public Map<String, Integer> getDataStoreReservation() {
        return this.dataStoreReservation;
    }

    @NotNull
    @Generated
    public ArrayListMultimap<String, Integer> getDiskReservation() {
        return this.diskReservation;
    }

    @Generated
    public int getMemoryMagnification() {
        return this.memoryMagnification;
    }

    @Generated
    public int getCpuMagnification() {
        return this.cpuMagnification;
    }

    @Generated
    public static class EnvironmentCheckCmdBuilder {
        @Generated
        private Supplier<List<String>> oldVmIds;
        @Generated
        private int cpuMuxRatio;
        @Generated
        private int memoryMuxRatio;
        @Generated
        private boolean cpuReservation$set;
        @Generated
        private Map<String, Integer> cpuReservation$value;
        @Generated
        private boolean memoryReservation$set;
        @Generated
        private Map<String, Integer> memoryReservation$value;
        @Generated
        private boolean dataStoreReservation$set;
        @Generated
        private Map<String, Integer> dataStoreReservation$value;
        @Generated
        private boolean diskReservation$set;
        @Generated
        private ArrayListMultimap<String, Integer> diskReservation$value;
        @Generated
        private boolean memoryMagnification$set;
        @Generated
        private int memoryMagnification$value;
        @Generated
        private boolean cpuMagnification$set;
        @Generated
        private int cpuMagnification$value;

        @Generated
        EnvironmentCheckCmdBuilder() {
        }

        @Generated
        public EnvironmentCheckCmdBuilder oldVmIds(@Nullable Supplier<List<String>> oldVmIds) {
            this.oldVmIds = oldVmIds;
            return this;
        }

        @Generated
        public EnvironmentCheckCmdBuilder cpuMuxRatio(int cpuMuxRatio) {
            this.cpuMuxRatio = cpuMuxRatio;
            return this;
        }

        @Generated
        public EnvironmentCheckCmdBuilder memoryMuxRatio(int memoryMuxRatio) {
            this.memoryMuxRatio = memoryMuxRatio;
            return this;
        }

        @Generated
        public EnvironmentCheckCmdBuilder cpuReservation(@NotNull Map<String, Integer> cpuReservation) {
            this.cpuReservation$value = cpuReservation;
            this.cpuReservation$set = true;
            return this;
        }

        @Generated
        public EnvironmentCheckCmdBuilder memoryReservation(@NotNull Map<String, Integer> memoryReservation) {
            this.memoryReservation$value = memoryReservation;
            this.memoryReservation$set = true;
            return this;
        }

        @Generated
        public EnvironmentCheckCmdBuilder dataStoreReservation(@NotNull Map<String, Integer> dataStoreReservation) {
            this.dataStoreReservation$value = dataStoreReservation;
            this.dataStoreReservation$set = true;
            return this;
        }

        @Generated
        public EnvironmentCheckCmdBuilder diskReservation(@NotNull ArrayListMultimap<String, Integer> diskReservation) {
            this.diskReservation$value = diskReservation;
            this.diskReservation$set = true;
            return this;
        }

        @Generated
        public EnvironmentCheckCmdBuilder memoryMagnification(int memoryMagnification) {
            this.memoryMagnification$value = memoryMagnification;
            this.memoryMagnification$set = true;
            return this;
        }

        @Generated
        public EnvironmentCheckCmdBuilder cpuMagnification(int cpuMagnification) {
            this.cpuMagnification$value = cpuMagnification;
            this.cpuMagnification$set = true;
            return this;
        }

        @Generated
        public EnvironmentCheckCmd build() {
            Map cpuReservation$value = this.cpuReservation$value;
            if (!this.cpuReservation$set) {
                cpuReservation$value = EnvironmentCheckCmd.$default$cpuReservation();
            }
            Map memoryReservation$value = this.memoryReservation$value;
            if (!this.memoryReservation$set) {
                memoryReservation$value = EnvironmentCheckCmd.$default$memoryReservation();
            }
            Map dataStoreReservation$value = this.dataStoreReservation$value;
            if (!this.dataStoreReservation$set) {
                dataStoreReservation$value = EnvironmentCheckCmd.$default$dataStoreReservation();
            }
            ArrayListMultimap diskReservation$value = this.diskReservation$value;
            if (!this.diskReservation$set) {
                diskReservation$value = EnvironmentCheckCmd.$default$diskReservation();
            }
            int memoryMagnification$value = this.memoryMagnification$value;
            if (!this.memoryMagnification$set) {
                memoryMagnification$value = EnvironmentCheckCmd.$default$memoryMagnification();
            }
            int cpuMagnification$value = this.cpuMagnification$value;
            if (!this.cpuMagnification$set) {
                cpuMagnification$value = EnvironmentCheckCmd.$default$cpuMagnification();
            }
            return new EnvironmentCheckCmd(this.oldVmIds, this.cpuMuxRatio, this.memoryMuxRatio, cpuReservation$value, memoryReservation$value, dataStoreReservation$value, (ArrayListMultimap<String, Integer>)diskReservation$value, memoryMagnification$value, cpuMagnification$value);
        }

        @Generated
        public String toString() {
            return "EnvironmentCheckCmd.EnvironmentCheckCmdBuilder(oldVmIds=" + this.oldVmIds + ", cpuMuxRatio=" + this.cpuMuxRatio + ", memoryMuxRatio=" + this.memoryMuxRatio + ", cpuReservation$value=" + this.cpuReservation$value + ", memoryReservation$value=" + this.memoryReservation$value + ", dataStoreReservation$value=" + this.dataStoreReservation$value + ", diskReservation$value=" + this.diskReservation$value + ", memoryMagnification$value=" + this.memoryMagnification$value + ", cpuMagnification$value=" + this.cpuMagnification$value + ")";
        }
    }
}

