/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.net;

import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.client.ApiClient;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.FcBaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.FcInfoContext;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.TaskContext;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.VmDetail;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.config.Nic;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClearInvalidNicTask
extends FcBaseTask<Integer> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClearInvalidNicTask.class);
    public static final String NAME_KEY = "clear.invalid.nic";

    public void execute() throws TaskException {
        String vmId = TaskContext.get().getVmId();
        log.info("clear invalid nic for vm: {}", (Object)vmId);
        ApiClient client = FcInfoContext.get().getService();
        VmDetail vmDetail = client.getVmDetail(vmId);
        List<Nic> nics = vmDetail.getVmConfig().getNics();
        if (CollectionUtils.isEmpty(nics)) {
            log.warn("nic config is empty, no need to clear");
        }
        this.deleteNics(vmId, client, nics);
    }

    void deleteNics(String vmId, ApiClient client, List<Nic> nics) {
        nics.stream().sorted(Comparator.comparing(Nic::getSequenceNum)).collect(Collectors.toList()).subList((Integer)this.cmd, nics.size()).forEach(nic -> this.deleteNic(vmId, client, (Nic)nic));
    }

    private void deleteNic(String vmId, ApiClient client, Nic nic) {
        client.deleteVmNic(vmId, nic.getId());
        log.info("clear invalid nic {}, id {}", (Object)nic.getName(), (Object)nic.getId());
    }

    @Generated
    protected ClearInvalidNicTask(ClearInvalidNicTaskBuilder<?, ?> b) {
        super(b);
    }

    @Generated
    public static ClearInvalidNicTaskBuilder<?, ?> builder() {
        return new ClearInvalidNicTaskBuilderImpl();
    }

    @Generated
    private static final class ClearInvalidNicTaskBuilderImpl
    extends ClearInvalidNicTaskBuilder<ClearInvalidNicTask, ClearInvalidNicTaskBuilderImpl> {
        @Generated
        private ClearInvalidNicTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected ClearInvalidNicTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ClearInvalidNicTask build() {
            return new ClearInvalidNicTask(this);
        }
    }

    @Generated
    public static abstract class ClearInvalidNicTaskBuilder<C extends ClearInvalidNicTask, B extends ClearInvalidNicTaskBuilder<C, B>>
    extends FcBaseTask.FcBaseTaskBuilder<Integer, C, B> {
        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "ClearInvalidNicTask.ClearInvalidNicTaskBuilder(super=" + super.toString() + ")";
        }
    }
}

