/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.batch;

import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.exception.CustomError;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.exception.FcTaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.FcLoginInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.batch.DeployVmsTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.batch.DeployVmsTaskManager;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.utils.RetryUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.service.FcClientService;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskStatus;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ConfigFilesUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchDeployVmsTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BatchDeployVmsTask.class);
    public static final String TASK_NAME = "batch.deploy.vms";
    private static final String CONFIG_PATH = String.join((CharSequence)File.separator, "configProperties", "fcbase.properties");
    private static final int VMS_TASK_END_TIME = Integer.parseInt(ConfigFilesUtils.getConfigValueFromCustomFile((String)CONFIG_PATH, (String)"batch.deploy.vms.timeout").orElse("300"));
    private List<String> errorVmIds;
    private FcLoginInfo fcLoginInfo;

    private boolean isTaskFinished(DeployVmsTask deployVmsTask) {
        return TaskStatus.isFinishStatus((TaskStatus)deployVmsTask.getTaskResult().getTaskStatus());
    }

    public void execute() throws TaskException {
        if (CollectionUtils.isNotEmpty(this.errorVmIds)) {
            this.errorVmIds.forEach(this::clearErrorVmId);
        }
        this.executeBatchDeployVmsTasks(this);
        this.setTaskStatus();
    }

    private void clearErrorVmId(String vmId) {
        try {
            FcClientService.createApiService(this.fcLoginInfo).deleteVm(vmId);
        }
        catch (FcTaskException exception) {
            this.appendTaskDetail(StringUtils.formatTxt((String)"delete vm %s failed", (Object[])new Object[]{vmId}));
            log.error("Failed to delete vm {}", (Object)vmId, (Object)exception);
        }
    }

    private void setTaskStatus() throws FcTaskException {
        if (!this.getSubTasks().stream().allMatch(subTask -> TaskStatus.isSuccessStatus((TaskStatus)subTask.getTaskResult().getTaskStatus()))) {
            throw new FcTaskException(CustomError.TASK_FAILED, new Object[0]);
        }
    }

    private void executeBatchDeployVmsTasks(BaseTask batchDeployVmsTask) throws FcTaskException {
        List<DeployVmsTask> deployVmsTasks = batchDeployVmsTask.getSubTasks().stream().map(this::covertBaseTaskToDeployVmsTask).filter(deployVmsTask -> deployVmsTask.canStart() && !deployVmsTask.isSuccess()).collect(Collectors.toList());
        this.appendTaskDetail(StringUtils.formatTxt((String)"start to deploy vms : %s", (Object[])new Object[]{deployVmsTasks.stream().map(BaseTask::getTaskName).collect(Collectors.joining(","))}));
        deployVmsTasks.forEach(this::setSubTasksStatus);
        DeployVmsTaskManager.getInstance().addAndStartTask(deployVmsTasks);
        RetryUtils.retry(() -> this.checkTaskStatus(deployVmsTasks), VMS_TASK_END_TIME, TimeUnit.MINUTES);
    }

    private void setSubTasksStatus(BaseTask deployVmsTask) {
        deployVmsTask.getTaskResult().setTaskStatus(TaskStatus.NOT_START);
        if (CollectionUtils.isNotEmpty((Collection)deployVmsTask.getSubTasks())) {
            deployVmsTask.getSubTasks().forEach(this::setSubTasksStatus);
        }
    }

    private Boolean checkTaskStatus(List<DeployVmsTask> deployVmsTasks) {
        return deployVmsTasks.stream().allMatch(this::isTaskFinished);
    }

    private DeployVmsTask covertBaseTaskToDeployVmsTask(BaseTask subTask) {
        if (!(subTask instanceof DeployVmsTask)) {
            throw new FcTaskException(CustomError.TASK_FAILED, new Object[0]);
        }
        return (DeployVmsTask)subTask;
    }

    @Generated
    protected BatchDeployVmsTask(BatchDeployVmsTaskBuilder<?, ?> b) {
        super(b);
        this.errorVmIds = ((BatchDeployVmsTaskBuilder)b).errorVmIds;
        this.fcLoginInfo = ((BatchDeployVmsTaskBuilder)b).fcLoginInfo;
    }

    @Generated
    public static BatchDeployVmsTaskBuilder<?, ?> builder() {
        return new BatchDeployVmsTaskBuilderImpl();
    }

    @Generated
    private static final class BatchDeployVmsTaskBuilderImpl
    extends BatchDeployVmsTaskBuilder<BatchDeployVmsTask, BatchDeployVmsTaskBuilderImpl> {
        @Generated
        private BatchDeployVmsTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected BatchDeployVmsTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public BatchDeployVmsTask build() {
            return new BatchDeployVmsTask(this);
        }
    }

    @Generated
    public static abstract class BatchDeployVmsTaskBuilder<C extends BatchDeployVmsTask, B extends BatchDeployVmsTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private List<String> errorVmIds;
        @Generated
        private FcLoginInfo fcLoginInfo;

        @Generated
        public B errorVmIds(List<String> errorVmIds) {
            this.errorVmIds = errorVmIds;
            return (B)this.self();
        }

        @Generated
        public B fcLoginInfo(FcLoginInfo fcLoginInfo) {
            this.fcLoginInfo = fcLoginInfo;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "BatchDeployVmsTask.BatchDeployVmsTaskBuilder(super=" + super.toString() + ", errorVmIds=" + this.errorVmIds + ", fcLoginInfo=" + this.fcLoginInfo + ")";
        }
    }
}

