/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.img;

import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.client.ApiClient;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.exception.ApiError;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.exception.FcTaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.FcBaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.FcInfoContext;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.TaskContext;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.datastore.file.FileUnit;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.cmd.AttachImage;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachImgTask
extends FcBaseTask<Void> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AttachImgTask.class);
    public static final String NAME_KEY = "attach.img";

    public void execute() throws TaskException {
        String vmId = TaskContext.get().getVmId();
        ApiClient client = FcInfoContext.get().getService();
        this.tryDetachImage(client, vmId);
        client.attachImage(vmId, this.buildAttachImage(client));
    }

    private AttachImage buildAttachImage(ApiClient client) {
        TaskContext taskContext = TaskContext.get();
        String fileName = taskContext.getImageFile().getName();
        String datastoreId = taskContext.getImgDataStore().getId();
        int fileId = this.getFileIdWhenFileReady(datastoreId, fileName, client);
        if (fileId <= 0) {
            throw new FcTaskException(ApiError.ISO_FILE_NOT_EXIST, new Object[0]);
        }
        return AttachImage.builder().fileId(fileId).devicePath(datastoreId + "@" + fileName).build();
    }

    int getFileIdWhenFileReady(String datastoreId, String fileName, ApiClient client) {
        FileUnit fileInfo;
        int timeout = 30;
        int count = 0;
        do {
            ThreadUtils.threadSafeSleep((int)20, (TimeUnit)TimeUnit.SECONDS);
            if (++count <= timeout) continue;
            throw new FcTaskException(ApiError.ISO_FILE_NOT_EXIST, new Object[0]);
        } while (!(fileInfo = client.getImageFileInfo(datastoreId, fileName)).isFileStatusReady());
        return fileInfo.getFileId();
    }

    private void tryDetachImage(ApiClient client, String vmsId) {
        if (client.getVmDetail(vmsId).hasAttachImage()) {
            client.detachImage(vmsId);
            log.info("detachImage vmsId{}", (Object)vmsId);
        }
    }

    @Generated
    protected AttachImgTask(AttachImgTaskBuilder<?, ?> b) {
        super(b);
    }

    @Generated
    public static AttachImgTaskBuilder<?, ?> builder() {
        return new AttachImgTaskBuilderImpl();
    }

    @Generated
    private static final class AttachImgTaskBuilderImpl
    extends AttachImgTaskBuilder<AttachImgTask, AttachImgTaskBuilderImpl> {
        @Generated
        private AttachImgTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected AttachImgTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AttachImgTask build() {
            return new AttachImgTask(this);
        }
    }

    @Generated
    public static abstract class AttachImgTaskBuilder<C extends AttachImgTask, B extends AttachImgTaskBuilder<C, B>>
    extends FcBaseTask.FcBaseTaskBuilder<Void, C, B> {
        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "AttachImgTask.AttachImgTaskBuilder(super=" + super.toString() + ")";
        }
    }
}

