/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.img;

import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.client.ApiClient;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.FcBaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.FcInfoContext;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.TaskContext;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.img.cmd.OsCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.utils.FcConfigUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.utils.RetryUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.config.VmBootOption;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshConnInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshManager;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.IpUtils;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallOsTask
extends FcBaseTask<OsCmd> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InstallOsTask.class);
    public static final String NAME_KEY = "install.os";
    private static final String BOOT_OPTION_CDROM = "cdrom";
    private static final String BOOT_OPTION_DISK = "disk";

    public void execute() throws TaskException {
        String vmId = TaskContext.get().getVmId();
        ApiClient service = FcInfoContext.get().getService();
        service.updateImageProperty(vmId, new VmBootOption(BOOT_OPTION_CDROM));
        service.rebootVm(vmId);
        service.updateImageProperty(vmId, new VmBootOption(BOOT_OPTION_DISK));
        RetryUtils.retry(() -> IpUtils.isReachable((String)((OsCmd)this.cmd).getIp()), FcConfigUtils.getCheckIpTimeout(), TimeUnit.MINUTES);
        RetryUtils.retry(this::tryToConnectOsBySsh, FcConfigUtils.getWaitTimeout(), TimeUnit.MINUTES);
        service.detachImage(vmId);
        this.deleteImgFile();
    }

    private boolean tryToConnectOsBySsh() {
        SshConnInfo connInfo = CONVERTER.toSShConnInfo((OsCmd)this.cmd);
        try {
            boolean bl = SshManager.isConnected((SshConnInfo)connInfo);
            return bl;
        }
        catch (SshException e) {
            log.warn("try to connect os failed, {}: {}.", (Object)((OsCmd)this.cmd).getIp(), (Object)e.getErrorMessage());
        }
        finally {
            SshManager.releaseSession((SshConnInfo)connInfo);
        }
        return false;
    }

    private void deleteImgFile() {
        String fileName;
        String dataStoreId;
        ApiClient client = FcInfoContext.get().getService();
        int fileId = client.getFileId(dataStoreId = TaskContext.get().getImgDataStore().getId(), fileName = TaskContext.get().getImageFile().getName());
        if (fileId > 0) {
            log.info("DeleteFile, storeId:{}, file:{}", (Object)dataStoreId, (Object)fileName);
            client.deleteFile(dataStoreId, fileId);
        }
    }

    @Generated
    protected InstallOsTask(InstallOsTaskBuilder<?, ?> b) {
        super(b);
    }

    @Generated
    public static InstallOsTaskBuilder<?, ?> builder() {
        return new InstallOsTaskBuilderImpl();
    }

    @Generated
    private static final class InstallOsTaskBuilderImpl
    extends InstallOsTaskBuilder<InstallOsTask, InstallOsTaskBuilderImpl> {
        @Generated
        private InstallOsTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected InstallOsTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public InstallOsTask build() {
            return new InstallOsTask(this);
        }
    }

    @Generated
    public static abstract class InstallOsTaskBuilder<C extends InstallOsTask, B extends InstallOsTaskBuilder<C, B>>
    extends FcBaseTask.FcBaseTaskBuilder<OsCmd, C, B> {
        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "InstallOsTask.InstallOsTaskBuilder(super=" + super.toString() + ")";
        }
    }
}

