/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.img;

import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.exception.ApiError;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.exception.FcTaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.TaskContext;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.img.cmd.ImageUpdateCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.utils.RetryUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FileOperateUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.OsCmdUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ZipUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.iamge.ImageConstant;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.iamge.IsoEulerVersion;
import java.io.File;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateImgTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UpdateImgTask.class);
    public static final String NAME_KEY = "update.img";
    @NotNull
    private final ImageUpdateCmd cmd;

    public void execute() throws TaskException {
        String imageIsoPath = this.cmd.getPath().get();
        if (StringUtils.isEmpty((CharSequence)imageIsoPath)) {
            throw new FcTaskException(ApiError.ISO_FILE_NOT_EXIST, new Object[0]);
        }
        FileOperateUtils.deleteDirectory((String)ImageConstant.CACHE_DIR);
        String cacheDir = FilePathValidatorUtils.joinChildPath((String[])new String[]{ImageConstant.CACHE_DIR, StringUtils.formatTxt((String)"%s_%s", (Object[])new Object[]{this.cmd.getIp(), StringUtils.commonFormatTimeText()})});
        if (!ZipUtils.decompressFileBy7Zip((String)ImageConstant.ZIP_TOOL_PATH, (String)imageIsoPath, (String)cacheDir)) {
            log.error("decompressFile failed");
            throw new FcTaskException(ApiError.UPDATE_IMAGE_FAILED, new Object[0]);
        }
        String updateMessage = this.cmd.getUpdateOperate().apply(cacheDir);
        if (StringUtils.isNotEmpty((CharSequence)updateMessage)) {
            log.error("Update iso failed: {}", (Object)updateMessage);
            throw new FcTaskException(ApiError.UPDATE_IMAGE_FAILED, new Object[0]);
        }
        String newImage = this.packageIsoImage(cacheDir, imageIsoPath);
        if (StringUtils.isEmpty((CharSequence)newImage)) {
            throw new FcTaskException(ApiError.UPDATE_IMAGE_FAILED, new Object[0]);
        }
        TaskContext.get().setImageFile(this.getFileUntilLengthNotChange(newImage));
    }

    private String packageIsoImage(String cacheDir, String isoPath) {
        String version = IsoEulerVersion.parse((String)isoPath).getVersion();
        String packageName = StringUtils.formatTxt((String)"%s_%s", (Object[])new Object[]{this.cmd.getIp(), new File(isoPath).getName()});
        log.info("package iso, name:{}, version:{}", (Object)packageName, (Object)version);
        String packageCmd = isoPath.toLowerCase(Locale.ROOT).contains("x86") ? ImageConstant.X86_PACKAGE_CMD : ImageConstant.ARM_PACKAGE_CMD;
        OsCmdUtils.executeCmd((String)StringUtils.formatTxt((String)packageCmd, (Object[])new Object[]{version, packageName}), null, (File)new File(cacheDir), (int)30);
        return FilePathValidatorUtils.joinChildPath((String[])new String[]{cacheDir, packageName});
    }

    private File getFileUntilLengthNotChange(String filePath) {
        File file = new File(filePath);
        RetryUtils.retry(this.lengthCheck(file, new AtomicLong(0L)));
        return file;
    }

    private Supplier<Boolean> lengthCheck(File file, AtomicLong lastLength) {
        return () -> {
            if (lastLength.get() == file.length()) {
                return true;
            }
            lastLength.set(file.length());
            return false;
        };
    }

    @Generated
    protected UpdateImgTask(UpdateImgTaskBuilder<?, ?> b) {
        super(b);
        this.cmd = ((UpdateImgTaskBuilder)b).cmd;
        if (this.cmd == null) {
            throw new NullPointerException("cmd is marked non-null but is null");
        }
    }

    @Generated
    public static UpdateImgTaskBuilder<?, ?> builder() {
        return new UpdateImgTaskBuilderImpl();
    }

    @Generated
    private static final class UpdateImgTaskBuilderImpl
    extends UpdateImgTaskBuilder<UpdateImgTask, UpdateImgTaskBuilderImpl> {
        @Generated
        private UpdateImgTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected UpdateImgTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public UpdateImgTask build() {
            return new UpdateImgTask(this);
        }
    }

    @Generated
    public static abstract class UpdateImgTaskBuilder<C extends UpdateImgTask, B extends UpdateImgTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private ImageUpdateCmd cmd;

        @Generated
        public B cmd(@NotNull ImageUpdateCmd cmd) {
            this.cmd = cmd;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "UpdateImgTask.UpdateImgTaskBuilder(super=" + super.toString() + ", cmd=" + this.cmd + ")";
        }
    }
}

