/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.img;

import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.client.ApiClient;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.exception.ApiError;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.exception.FcTaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.FcBaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.FcInfoContext;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.TaskContext;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.utils.FcConfigUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.datastore.DataStore;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.datastore.file.upload.ApplyUploadResponse;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.datastore.file.upload.UploadResponse;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.datastore.file.upload.cmd.UploadFile;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadImgTask
extends FcBaseTask<Void> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UploadImgTask.class);
    public static final String NAME_KEY = "upload.img";
    private static final int DEFAULT_BYTE_LENGTH = 0x100000;
    private static final String CONTENT_RANGE = "bytes %d-%d/%d";

    @Override
    public void beforeExecute() {
        super.beforeExecute();
        TaskContext taskContext = TaskContext.get();
        int imageSizeGb = FcConfigUtils.getImageSizeGb();
        taskContext.setImgDataStore(FcInfoContext.get().getDataStoresOfHost(taskContext.getHost().getName()).stream().filter(DataStore::isSupportUploadFile).sorted(Comparator.comparingInt(DataStore::getFreeSizeGB)).filter(store -> store.isUseSizeSuccess(imageSizeGb)).findFirst().orElseThrow(FcTaskException.thr(ApiError.DATA_STORE_INSUFFICIENT)));
    }

    public void execute() throws TaskException {
        TaskContext taskContext = TaskContext.get();
        File file = taskContext.getImageFile();
        String dataStoreId = taskContext.getImgDataStore().getId();
        log.info("upload image file datastore:{}", (Object)dataStoreId);
        this.tryDeleteFile(file, dataStoreId);
        FcInfoContext context = FcInfoContext.get();
        UploadFile uploadFile = UploadFile.builder().name(file.getName()).size(String.valueOf(file.length())).siteID(context.getSiteId()).dataStoreID(dataStoreId).build();
        this.retry3Times(() -> this.uploadFile(file, uploadFile, context.getService().applyUpload(dataStoreId, uploadFile)));
    }

    private void uploadFile(File file, UploadFile uploadFile, ApplyUploadResponse applyResponse) {
        HashMap<String, String> tokenHeaders = new HashMap<String, String>();
        tokenHeaders.put("X_UPLOAD_ACCESS", applyResponse.getToken());
        tokenHeaders.put("Content-Type", "application/octet-stream");
        ApiClient serviceClient = FcInfoContext.get().getService();
        int start = 0;
        int sliceCount = 0;
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            long fileLength = file.length();
            while ((long)start < fileLength) {
                if (sliceCount % 100 == 0) {
                    serviceClient.authCna(applyResponse.getTrustURL());
                    log.info("upload iamge file by slice, count : {}", (Object)sliceCount);
                }
                byte[] bytes = new byte[0x100000];
                int read = fileInputStream.read(bytes);
                tokenHeaders.put("Content-Length", String.valueOf(read));
                tokenHeaders.put("Content-Range", StringUtils.formatTxt((String)CONTENT_RANGE, (Object[])new Object[]{start, start + read, fileLength}));
                UploadResponse response = this.uploadSlice(uploadFile, applyResponse, tokenHeaders, bytes);
                this.checkResponse(start, response);
                start = response.getStart();
                ++sliceCount;
            }
        }
        catch (IOException e) {
            log.error("uploadFile failed", (Throwable)e);
            throw new FcTaskException(ApiError.UPLOAD_IMAGE_FAIL, new Object[0]);
        }
    }

    private UploadResponse uploadSlice(UploadFile uploadFile, ApplyUploadResponse applyResponse, Map<String, String> tokenHeaders, byte[] bytes) {
        AtomicReference response = new AtomicReference();
        this.retry3Times(() -> response.set(FcInfoContext.get().getService().postStreamUpload(tokenHeaders, applyResponse.getUploadURL(), bytes, uploadFile)));
        return (UploadResponse)response.get();
    }

    private void retry3Times(Upload upload) {
        int tryTime = 0;
        while (true) {
            try {
                upload.executeUpload();
                return;
            }
            catch (FcTaskException e) {
                log.error("upload image file failed, try {}", (Object)tryTime, (Object)e);
                if (tryTime++ >= 3) {
                    throw e;
                }
                ThreadUtils.threadSafeSleep((int)3, (TimeUnit)TimeUnit.SECONDS);
                continue;
            }
            break;
        }
    }

    private void checkResponse(int start, UploadResponse response) {
        if (!response.isSuccess()) {
            log.error("response error. {}", (Object)response.getMessage());
            throw new FcTaskException(ApiError.UPLOAD_IMAGE_SLICE_FAIL, response.getMessage());
        }
        if (response.getStart() <= start) {
            log.warn("unexpected start, response {}, now {}.", (Object)response.getStart(), (Object)start);
            throw new FcTaskException(ApiError.UPLOAD_IMAGE_FAIL, new Object[0]);
        }
    }

    private void tryDeleteFile(File file, String dataStoreId) {
        ApiClient client = FcInfoContext.get().getService();
        int fileId = client.getFileId(dataStoreId, file.getName());
        if (fileId > 0) {
            log.info("DeleteFile, storeId:{}, fileId:{}", (Object)dataStoreId, (Object)fileId);
            client.deleteFile(dataStoreId, fileId);
        }
    }

    @Generated
    protected UploadImgTask(UploadImgTaskBuilder<?, ?> b) {
        super(b);
    }

    @Generated
    public static UploadImgTaskBuilder<?, ?> builder() {
        return new UploadImgTaskBuilderImpl();
    }

    @Generated
    private static final class UploadImgTaskBuilderImpl
    extends UploadImgTaskBuilder<UploadImgTask, UploadImgTaskBuilderImpl> {
        @Generated
        private UploadImgTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected UploadImgTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public UploadImgTask build() {
            return new UploadImgTask(this);
        }
    }

    @Generated
    public static abstract class UploadImgTaskBuilder<C extends UploadImgTask, B extends UploadImgTaskBuilder<C, B>>
    extends FcBaseTask.FcBaseTaskBuilder<Void, C, B> {
        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "UploadImgTask.UploadImgTaskBuilder(super=" + super.toString() + ")";
        }
    }

    @FunctionalInterface
    private static interface Upload {
        public void executeUpload() throws FcTaskException;
    }
}

