/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template;

import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.client.ApiClient;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.exception.ApiError;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.exception.FcTaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.FcBaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.FcInfoContext;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.TaskContext;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template.cmd.CreateVmByTemplateCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template.cmd.VmNicConfigCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template.cmd.WatchDogCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.datastore.DataStore;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.host.Host;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.net.protgroup.PortGroup;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.task.TaskDetail;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.task.TaskResult;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.VmDetail;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.cmd.clone.VmClone;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.config.Disk;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.config.Nic;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.config.Property;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateVmByTemplateTask
extends FcBaseTask<CreateVmByTemplateCmd> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CreateVmByTemplateTask.class);
    public static final String NAME_KEY = "create.vm.by.template";
    private String vmId;

    public void execute() throws TaskException {
        FcInfoContext context = FcInfoContext.get();
        ApiClient serviceClient = context.getService();
        if (StringUtils.isNotEmpty((CharSequence)this.vmId)) {
            serviceClient.deleteVm(this.vmId);
        }
        String templateId = ((CreateVmByTemplateCmd)this.cmd).getTemplateId().get();
        VmDetail vmDetail = serviceClient.getVmDetail(templateId);
        TaskResult taskResult = serviceClient.cloneVm(templateId, this.buildVmClone(context, vmDetail, ((CreateVmByTemplateCmd)this.cmd).getWatchDogCmd()));
        this.vmId = taskResult.getId();
        serviceClient.getTaskUntilSuccess(taskResult.getTaskId());
        Optional.ofNullable(((CreateVmByTemplateCmd)this.cmd).getVmIdHandler()).ifPresent(handler -> handler.accept(taskResult.getId()));
        if (((CreateVmByTemplateCmd)this.cmd).isAutoStartVm()) {
            log.info("auto start vm {}", (Object)taskResult.getId());
            TaskDetail taskDetail = serviceClient.startVm(taskResult.getId());
            log.info("custom vm request id {}", (Object)taskDetail.getRequestId());
            serviceClient.customVm(taskDetail.getRequestId());
        }
        TaskContext.get().setVmId(taskResult.getId());
    }

    private VmClone buildVmClone(FcInfoContext context, VmDetail vmDetail, WatchDogCmd watchDogCmd) {
        VmClone vmClone = CONVERTER.buildVmClone((CreateVmByTemplateCmd)this.cmd, context, vmDetail);
        this.updateVmConfig(vmClone);
        this.fillNicPortGroup(context, vmClone);
        this.updateDataStore(context, vmClone);
        this.updateHugePage(context, vmClone);
        this.updateStorageProtocol(context, vmClone);
        this.updateWatchDog(vmClone, watchDogCmd);
        return vmClone;
    }

    private void updateWatchDog(VmClone vmClone, WatchDogCmd watchDogCmd) {
        Property properties = vmClone.getVmConfig().getProperties();
        Optional.ofNullable(watchDogCmd).map(WatchDogCmd::isEnableWatchDog).ifPresent(properties::setEnableWatchDog);
        Optional.ofNullable(watchDogCmd).map(WatchDogCmd::getWatchDogStrategy).ifPresent(properties::setWatchDogStrategy);
        Optional.ofNullable(watchDogCmd).map(WatchDogCmd::getWatchDogPreTimeOut).ifPresent(properties::setWatchDogPreTimeOut);
        Optional.ofNullable(watchDogCmd).map(WatchDogCmd::getWatchDogTimeOut).ifPresent(properties::setWatchDogTimeOut);
    }

    private void updateStorageProtocol(FcInfoContext context, VmClone vmClone) {
        Host host = context.getHostByName(((CreateVmByTemplateCmd)this.cmd).getCnaName());
        CollectionUtils.emptyIfNull(vmClone.getVmConfig().getDisks()).stream().filter(disk -> context.getDataStoreByUrn(disk.getDatastoreUrn()).isHostProtocolNvme(host.getId())).forEach(disk -> disk.setStorageProtocol("1"));
    }

    private void updateHugePage(FcInfoContext context, VmClone vmClone) {
        if (this.hasNvmeProtocol(context, vmClone)) {
            Optional.ofNullable(vmClone.getVmConfig().getMemory()).ifPresent(memory -> memory.updateHugePage("1G"));
        }
    }

    private boolean hasNvmeProtocol(FcInfoContext context, VmClone vmClone) {
        if (vmClone.getDiskSize() == 0) {
            return false;
        }
        Host host = context.getHostByName(((CreateVmByTemplateCmd)this.cmd).getCnaName());
        return vmClone.getVmConfig().getDisks().stream().map(disk -> context.getDataStoreByUrn(disk.getDatastoreUrn())).anyMatch(dataStore -> dataStore.isHostProtocolNvme(host.getId()));
    }

    private void updateVmConfig(VmClone vmClone) {
        if (((CreateVmByTemplateCmd)this.cmd).getCpuCores() > 0) {
            Optional.ofNullable(vmClone.getVmConfig().getCpu()).ifPresent(cpu -> cpu.updateCore(((CreateVmByTemplateCmd)this.cmd).getCpuCores()));
        }
        if (((CreateVmByTemplateCmd)this.cmd).getMemorySizeGb() > 0) {
            Optional.ofNullable(vmClone.getVmConfig().getMemory()).ifPresent(memory -> memory.updateSize(((CreateVmByTemplateCmd)this.cmd).getMemorySizeGb()));
        }
    }

    private void fillNicPortGroup(FcInfoContext context, VmClone vmClone) {
        int cmdNicSize;
        int nicSize = vmClone.getNicSize();
        if (nicSize < (cmdNicSize = ((CreateVmByTemplateCmd)this.cmd).getNicConfigs().size())) {
            log.warn("origin template has {} nic configuration, cmd {} nic.", (Object)nicSize, (Object)cmdNicSize);
            vmClone.addNics(IntStream.range(nicSize, cmdNicSize).mapToObj(seqNum -> new Nic("", seqNum)).collect(Collectors.toList()));
        }
        if (cmdNicSize != vmClone.getNicSize()) {
            throw new FcTaskException(ApiError.NIC_NOT_MATCH, new Object[0]);
        }
        List<VmNicConfigCmd> nicConfigs = ((CreateVmByTemplateCmd)this.cmd).getNicConfigs();
        List<Nic> nics = vmClone.getVmConfig().getNics();
        for (int i = 0; i < nicConfigs.size(); ++i) {
            VmNicConfigCmd nicConfig = nicConfigs.get(i);
            PortGroup portGroup = context.getPortGroupByName(nicConfig.getPortGroupName());
            nics.get(i).setPortGroupUrn(portGroup.getUrn());
        }
    }

    private void updateDataStore(FcInfoContext context, VmClone vmClone) {
        if (vmClone.getDiskSize() == 0) {
            log.warn("origin template has no disk configuration");
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)((CreateVmByTemplateCmd)this.cmd).getDatastoreName())) {
            DataStore dataStore = context.getDataStoreByNameAndHost(((CreateVmByTemplateCmd)this.cmd).getDatastoreName(), ((CreateVmByTemplateCmd)this.cmd).getCnaName());
            vmClone.getVmConfig().getDisks().forEach(disk -> disk.update(dataStore));
            return;
        }
        List<DataStore> dataStores = context.getDataStoresOfHost(((CreateVmByTemplateCmd)this.cmd).getCnaName());
        vmClone.getVmConfig().getDisks().forEach(disk -> disk.update(this.getMinDataStore((Disk)disk, dataStores)));
    }

    private DataStore getMinDataStore(Disk disk, List<DataStore> dataStores) {
        return dataStores.stream().filter(dataStore -> dataStore.isUseSizeSuccess(disk.getQuantityGB())).min(Comparator.comparingInt(DataStore::getFreeSizeGB)).orElseThrow(FcTaskException.thr(ApiError.DATA_STORE_INSUFFICIENT));
    }

    @Generated
    protected CreateVmByTemplateTask(CreateVmByTemplateTaskBuilder<?, ?> b) {
        super(b);
        this.vmId = ((CreateVmByTemplateTaskBuilder)b).vmId;
    }

    @Generated
    public static CreateVmByTemplateTaskBuilder<?, ?> builder() {
        return new CreateVmByTemplateTaskBuilderImpl();
    }

    @Generated
    private static final class CreateVmByTemplateTaskBuilderImpl
    extends CreateVmByTemplateTaskBuilder<CreateVmByTemplateTask, CreateVmByTemplateTaskBuilderImpl> {
        @Generated
        private CreateVmByTemplateTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected CreateVmByTemplateTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public CreateVmByTemplateTask build() {
            return new CreateVmByTemplateTask(this);
        }
    }

    @Generated
    public static abstract class CreateVmByTemplateTaskBuilder<C extends CreateVmByTemplateTask, B extends CreateVmByTemplateTaskBuilder<C, B>>
    extends FcBaseTask.FcBaseTaskBuilder<CreateVmByTemplateCmd, C, B> {
        @Generated
        private String vmId;

        @Generated
        public B vmId(String vmId) {
            this.vmId = vmId;
            return (B)((Object)this.self());
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "CreateVmByTemplateTask.CreateVmByTemplateTaskBuilder(super=" + super.toString() + ", vmId=" + this.vmId + ")";
        }
    }
}

