/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template;

import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.client.ApiClient;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.client.HostClientImpl;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.exception.ApiError;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.exception.CustomError;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.exception.FcTaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.FcBaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.FcInfoContext;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.TaskContext;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template.cmd.UploadTemplateCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.utils.FcConfigUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.utils.FcRequestUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.utils.RetryUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.HostRequestApi;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.host.Host;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.net.protgroup.PortGroup;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.os.OsVersion;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.task.TemplateTaskResult;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.config.Nic;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.config.VmConfig;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.template.TemplateInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.template.cmd.ImportTemplate;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.vm.template.serverlease.ServerLeaseResponse;
import com.huawei.yinglong.river.sitedeployment.dcs.http.HttpRequestApiFactory;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import okhttp3.Interceptor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadTemplateTask
extends FcBaseTask<UploadTemplateCmd> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UploadTemplateTask.class);
    public static final String NAME_KEY = "upload.template";
    private static final long SIZE_1M = 0x100000L;

    @Override
    public void beforeExecute() {
        super.beforeExecute();
        FcInfoContext fcInfoContext = FcInfoContext.get();
        Host host = fcInfoContext.getHostByName(((UploadTemplateCmd)this.cmd).getCnaName());
        TaskContext taskContext = TaskContext.get();
        taskContext.setHost(host);
        taskContext.setDataStore(fcInfoContext.getDatastoreByNameOrMax(((UploadTemplateCmd)this.cmd).getDatastoreName(), ((UploadTemplateCmd)this.cmd).getCnaName()));
        List<PortGroup> portGroups = fcInfoContext.getPortGroups();
        if (CollectionUtils.isEmpty(portGroups)) {
            throw new FcTaskException(ApiError.DATA_ERROR, new Object[0]);
        }
        taskContext.setPortGroup(portGroups.get(0));
    }

    public void execute() throws TaskException {
        FcInfoContext context = FcInfoContext.get();
        ApiClient serviceClient = context.getService();
        ImportTemplate importTemplate = this.getImportTemplate(context, serviceClient);
        TemplateTaskResult importTask = serviceClient.importTemplate(importTemplate);
        String serverLeaseId = FcRequestUtils.getIdFromUrn(importTask.getServerLeaseUrn());
        this.uploadTemplate(serviceClient, serverLeaseId, ((UploadTemplateCmd)this.cmd).getFilePath().get());
        serviceClient.getTaskUntilSuccess(importTask.getTaskId());
        Optional.ofNullable(((UploadTemplateCmd)this.cmd).getTemplateIdHandler()).ifPresent(handler -> handler.accept(importTask.getId()));
    }

    @Override
    public void afterExecute() {
        super.afterExecute();
        TaskContext.clear();
    }

    private ImportTemplate getImportTemplate(FcInfoContext context, ApiClient serviceClient) {
        TaskContext taskContext = TaskContext.get();
        TemplateInfo templateInfo = ((UploadTemplateCmd)this.cmd).getOvfFilePath() != null ? this.getTemplateByOvf(serviceClient, taskContext) : this.getTemplateByOs(serviceClient, taskContext);
        this.updateTemplate(taskContext, templateInfo);
        return CONVERTER.toImportTemplate((UploadTemplateCmd)this.cmd, context.getSite().getUrn(), templateInfo, taskContext.getHost());
    }

    private TemplateInfo getTemplateByOs(ApiClient serviceClient, TaskContext taskContext) {
        if (StringUtils.isEmpty((CharSequence)((UploadTemplateCmd)this.cmd).getOsVersionName())) {
            throw new FcTaskException(CustomError.PARAM_REQUIRED, new Object[0]);
        }
        OsVersion osVersion = serviceClient.getOsVersions(CONVERTER.toOsQuery(taskContext.getHost())).findOsVersionByName(((UploadTemplateCmd)this.cmd).getOsVersionName());
        String imageFormat = FilePathValidatorUtils.getSuffix((String)((UploadTemplateCmd)this.cmd).getFilePath().get());
        return CONVERTER.toTemplateInfo(osVersion, taskContext, imageFormat);
    }

    private TemplateInfo getTemplateByOvf(ApiClient serviceClient, TaskContext taskContext) {
        File file = this.getVaildOvfFile(((UploadTemplateCmd)this.cmd).getOvfFilePath());
        TemplateInfo template = serviceClient.parseTemplate(CONVERTER.toParseCmd(file.getName(), this.getFileStr(file)));
        this.fillVmConfig(template, taskContext);
        return template;
    }

    private void updateTemplate(TaskContext taskContext, TemplateInfo templateInfo) {
        templateInfo.getVmConfig().getDisks().forEach(disk -> disk.setThin(taskContext.getDataStore().isThin()));
        if (taskContext.getDataStore().isHostProtocolNvme(taskContext.getHost().getId())) {
            templateInfo.getVmConfig().getMemory().updateHugePage("1G");
            CollectionUtils.emptyIfNull(templateInfo.getVmConfig().getDisks()).forEach(disk -> disk.setStorageProtocol("1"));
        }
    }

    @NotNull
    private File getVaildOvfFile(Supplier<String> ovfFilePath) {
        File file = new File(ovfFilePath.get());
        if (!file.exists() || !file.isFile() || file.length() > 0x100000L) {
            log.info("ovf file illegal: {}", (Object)file.getName());
            throw new FcTaskException(ApiError.TEMPLATE_FILE_ILLEGAL, new Object[0]);
        }
        return file;
    }

    private void uploadTemplate(ApiClient serviceClient, String serverLeaseId, String filePath) {
        ServerLeaseResponse serverLeaseInfo = this.getSuccessServerLease(serviceClient, serverLeaseId);
        HostClientImpl hostServiceClient = new HostClientImpl((HostRequestApi)HttpRequestApiFactory.createRequestApi((String)StringUtils.formatTxt((String)"https://%s:8443", (Object[])new Object[]{serverLeaseInfo.getHost()}), HostRequestApi.class, (Duration)Duration.ofMinutes(20L), (Interceptor[])new Interceptor[0]));
        log.info("authCna");
        hostServiceClient.authCna();
        log.info("authTemplate");
        hostServiceClient.authTemplate(serverLeaseInfo.getToken());
        log.info("uploadTemplate");
        List files = Arrays.stream(filePath.split(",")).map(File::new).collect(Collectors.toList());
        for (int i = 0; i < files.size(); ++i) {
            log.info("current file index: {}, current fileName:{}, current UrlPostFix{}", new Object[]{i, ((File)files.get(i)).getName(), serverLeaseInfo.getUrlPostFix(i)});
            hostServiceClient.uploadTemplate((File)files.get(i), serverLeaseInfo.getToken(), serverLeaseInfo.getUrlPostFix(i));
        }
        log.info("completeServerLease");
        serviceClient.completeServerLease(serverLeaseId);
        ThreadUtils.threadSafeSleep((int)3, (TimeUnit)TimeUnit.SECONDS);
    }

    private ServerLeaseResponse getSuccessServerLease(ApiClient serviceClient, String serverLeaseId) {
        ServerLeaseResponse serverLeaseInfo = RetryUtils.retry(() -> serviceClient.getServerLeaseInfo(serverLeaseId), info -> !info.isInitializing(), FcConfigUtils.getServerLeaseTimeout(), TimeUnit.MINUTES);
        if (serverLeaseInfo.isError()) {
            throw new FcTaskException(ApiError.SERVER_LEASE_INIT_FAILED, new Object[0]);
        }
        return serverLeaseInfo;
    }

    private String getFileStr(File file) {
        try {
            return FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            log.error("Failed to read template file {}", (Object)file.getName(), (Object)e);
            throw new FcTaskException(ApiError.TEMPLATE_FILE_ILLEGAL, new Object[0]);
        }
    }

    private void fillVmConfig(TemplateInfo template, TaskContext taskContext) {
        VmConfig vmConfig = template.getVmConfig();
        if (CollectionUtils.isNotEmpty(vmConfig.getDisks())) {
            String dataStoreUrn = taskContext.getDataStore().getUrn();
            vmConfig.getDisks().forEach(disk -> disk.setDatastoreUrn(dataStoreUrn));
        }
        if (CollectionUtils.isNotEmpty(vmConfig.getNics())) {
            String portGroupUrn = taskContext.getPortGroup().getUrn();
            List<Nic> nicList = vmConfig.getNics().stream().map(nic -> new Nic(portGroupUrn, nic.getSequenceNum())).collect(Collectors.toList());
            vmConfig.setNics(nicList);
        }
    }

    @Generated
    protected UploadTemplateTask(UploadTemplateTaskBuilder<?, ?> b) {
        super(b);
    }

    @Generated
    public static UploadTemplateTaskBuilder<?, ?> builder() {
        return new UploadTemplateTaskBuilderImpl();
    }

    @Generated
    private static final class UploadTemplateTaskBuilderImpl
    extends UploadTemplateTaskBuilder<UploadTemplateTask, UploadTemplateTaskBuilderImpl> {
        @Generated
        private UploadTemplateTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected UploadTemplateTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public UploadTemplateTask build() {
            return new UploadTemplateTask(this);
        }
    }

    @Generated
    public static abstract class UploadTemplateTaskBuilder<C extends UploadTemplateTask, B extends UploadTemplateTaskBuilder<C, B>>
    extends FcBaseTask.FcBaseTaskBuilder<UploadTemplateCmd, C, B> {
        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "UploadTemplateTask.UploadTemplateTaskBuilder(super=" + super.toString() + ")";
        }
    }
}

