/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.utils;

import com.huawei.yinglong.river.sitedeployment.dcs.utils.ConfigFilesUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.NumberUtils;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;

public final class FcConfigUtils {
    private static final String DEFAULT_MEMORY = "deploy.vm.memory";
    private static final String CHECK_IP_TIMEOUT = "deploy.vm.check.ip.timeout";
    private static final String WAIT_TIME_AFTER_CHECK_IP = "deploy.vm.check.ip.wait";
    private static final String EXECUTE_TIMEOUT = "execute.timeout";
    private static final String SERVER_LEASE_INIT_TIMEOUT = "server.lease.init.timeout";
    private static final String DATA_STORE_TYPES = "data.store.types";
    private static final String DEFAULT_IMAGE = "deploy.vm.image";
    private static final String CONFIG_PATH = String.join((CharSequence)File.separator, "configProperties", "fcbase.properties");

    public static int getDefaultMemoryGb() {
        String defaultMemoryGb = ConfigFilesUtils.getConfigValueFromCustomFile((String)CONFIG_PATH, (String)DEFAULT_MEMORY).orElse("64");
        return Math.max(0, NumberUtils.parseInt((String)defaultMemoryGb, (int)64));
    }

    public static int getCheckIpTimeout() {
        String checkIpTimeout = ConfigFilesUtils.getConfigValueFromCustomFile((String)CONFIG_PATH, (String)CHECK_IP_TIMEOUT).orElse("15");
        return Math.max(0, NumberUtils.parseInt((String)checkIpTimeout, (int)15));
    }

    public static int getWaitTimeout() {
        String waitTimeout = ConfigFilesUtils.getConfigValueFromCustomFile((String)CONFIG_PATH, (String)WAIT_TIME_AFTER_CHECK_IP).orElse("10");
        return Math.max(0, NumberUtils.parseInt((String)waitTimeout, (int)10));
    }

    public static int getTimeout() {
        String waitTimeout = ConfigFilesUtils.getConfigValueFromCustomFile((String)CONFIG_PATH, (String)EXECUTE_TIMEOUT).orElse("30");
        return Math.max(0, NumberUtils.parseInt((String)waitTimeout, (int)30));
    }

    public static int getServerLeaseTimeout() {
        String waitTimeout = ConfigFilesUtils.getConfigValueFromCustomFile((String)CONFIG_PATH, (String)SERVER_LEASE_INIT_TIMEOUT).orElse("5");
        return Math.max(0, NumberUtils.parseInt((String)waitTimeout, (int)5));
    }

    public static List<String> getDataStoreTypes() {
        String dataStoreTypes = ConfigFilesUtils.getConfigValueFromCustomFile((String)CONFIG_PATH, (String)DATA_STORE_TYPES).orElse("LOCALPOME");
        return Arrays.asList(dataStoreTypes.split(";"));
    }

    public static int getImageSizeGb() {
        String imageSize = ConfigFilesUtils.getConfigValueFromCustomFile((String)CONFIG_PATH, (String)DEFAULT_IMAGE).orElse("2");
        return Math.max(0, NumberUtils.parseInt((String)imageSize, (int)2));
    }

    @Generated
    private FcConfigUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

