/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.utils;

import com.huawei.smartkit.drop.util.JsonUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.exception.ApiError;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.exception.FcTaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.base.ErrorResponse;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.io.IOException;
import lombok.Generated;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

public final class FcRequestUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FcRequestUtils.class);

    public static String getIdFromUrn(String urn) {
        if (StringUtils.isEmpty((CharSequence)urn) || !urn.contains(":")) {
            throw new FcTaskException(ApiError.DATA_ERROR, new Object[0]);
        }
        return urn.substring(urn.lastIndexOf(":") + 1);
    }

    public static <T> T dealResponse(Response<T> response) {
        if (response.isSuccessful()) {
            return (T)response.body();
        }
        String errorDesc = FcRequestUtils.getErrorDesc(response);
        if (StringUtils.isEmpty((CharSequence)errorDesc)) {
            throw new FcTaskException(ApiError.REQUEST_FAILED, new Object[0]);
        }
        throw new FcTaskException(ApiError.TASK_FAIL, errorDesc);
    }

    public static String toFcUrl(String ip) {
        return StringUtils.formatTxt((String)"https://%s:7443", (Object[])new Object[]{ip});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getErrorDesc(Response<?> response) {
        try (ResponseBody errorBody = response.errorBody();){
            if (errorBody == null) {
                log.warn("{} errorBody is null", response);
                String string = "";
                return string;
            }
            String errorStr = errorBody.string();
            if (StringUtils.isEmpty((CharSequence)errorStr) || !errorStr.startsWith("{")) {
                String string = errorStr;
                return string;
            }
            ErrorResponse errorResponse = (ErrorResponse)JsonUtils.toObject((String)errorStr, ErrorResponse.class);
            String string = errorResponse == null ? "" : errorResponse.getErrorDes();
            return string;
        }
        catch (IOException e) {
            log.error("deal errorBody error", (Throwable)e);
            return "";
        }
    }

    @Generated
    private FcRequestUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

