/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.utils;

import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.exception.CustomError;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.exception.FcTaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.utils.FcConfigUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import java.time.LocalDateTime;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lombok.Generated;

public final class RetryUtils {
    private static final int INTERVAL_SECOND = 10;

    public static <T> T retry(Supplier<T> producer, Predicate<T> stopCondition) {
        return RetryUtils.retry(producer, stopCondition, 10);
    }

    public static <T> T retry(Supplier<T> producer, Predicate<T> stopCondition, int intervalSeconds) {
        return RetryUtils.retry(producer, stopCondition, FcConfigUtils.getTimeout(), TimeUnit.MINUTES, intervalSeconds);
    }

    public static void retry(Supplier<Boolean> producer) {
        RetryUtils.retry(producer, FcConfigUtils.getTimeout(), TimeUnit.MINUTES);
    }

    public static void retry(Supplier<Boolean> producer, int timeout, TimeUnit timeUnit) {
        RetryUtils.retry(producer, result -> result, timeout, timeUnit);
    }

    public static <T> T retry(Supplier<T> producer, Predicate<T> stopCondition, int timeout, TimeUnit timeUnit) {
        return RetryUtils.retry(producer, stopCondition, timeout, timeUnit, 10);
    }

    public static <T> T retry(Supplier<T> producer, Predicate<T> stopCondition, int timeout, TimeUnit timeUnit, int intervalSeconds) {
        T result = producer.get();
        LocalDateTime timeLimit = LocalDateTime.now().plusSeconds(timeUnit.toSeconds(timeout));
        while (!stopCondition.test(result)) {
            if (timeLimit.isBefore(LocalDateTime.now())) {
                throw new FcTaskException(CustomError.EXECUTE_TIMEOUT, new Object[0]);
            }
            ThreadUtils.threadSafeSleep((int)intervalSeconds, (TimeUnit)TimeUnit.SECONDS);
            result = producer.get();
        }
        return result;
    }

    @Generated
    private RetryUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

