/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.datastore;

import com.google.common.collect.ImmutableList;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.base.FcEntityBase;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.datastore.ConnectProtocol;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.apidata.datastore.StorageUnit;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;

public class DataStore
extends FcEntityBase {
    private static final List<String> NOT_SUPPORT_FILE_UPLOAD = ImmutableList.of((Object)"DSWARE", (Object)"advanceSan");
    private String storageType;
    private String status;
    private int capacityGB;
    private int usedSizeGB;
    private int freeSizeGB;
    private boolean isThin;
    private String suUrn;
    private String suName;
    private List<StorageUnit> storageUnits;
    private List<String> hosts;
    private List<ConnectProtocol> hostConnectProtocols;

    public boolean isUseSizeSuccess(int sizeGb) {
        if (this.freeSizeGB - sizeGb < 0) {
            return false;
        }
        this.freeSizeGB -= sizeGb;
        return true;
    }

    public boolean isBelongHost(String hostUrn) {
        return CollectionUtils.isNotEmpty(this.hosts) && this.hosts.contains(hostUrn);
    }

    public boolean isAvailableStatus() {
        return Objects.equals(this.status, "NORMAL") || Objects.equals(this.status, "CONNECTED");
    }

    public boolean isHostProtocolNvme(String hostId) {
        return CollectionUtils.isNotEmpty(this.hostConnectProtocols) && this.hostConnectProtocols.stream().filter(protocol -> hostId.equals(protocol.getUrn())).anyMatch(protocol -> "NVMe".equals(protocol.getAccessProtocol()));
    }

    public boolean isSupportUploadFile() {
        return !NOT_SUPPORT_FILE_UPLOAD.contains(this.storageType);
    }

    @Generated
    public String getStorageType() {
        return this.storageType;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public int getCapacityGB() {
        return this.capacityGB;
    }

    @Generated
    public int getUsedSizeGB() {
        return this.usedSizeGB;
    }

    @Generated
    public int getFreeSizeGB() {
        return this.freeSizeGB;
    }

    @Generated
    public boolean isThin() {
        return this.isThin;
    }

    @Generated
    public String getSuUrn() {
        return this.suUrn;
    }

    @Generated
    public String getSuName() {
        return this.suName;
    }

    @Generated
    public List<StorageUnit> getStorageUnits() {
        return this.storageUnits;
    }

    @Generated
    public List<String> getHosts() {
        return this.hosts;
    }

    @Generated
    public List<ConnectProtocol> getHostConnectProtocols() {
        return this.hostConnectProtocols;
    }

    @Generated
    public void setStorageType(String storageType) {
        this.storageType = storageType;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setCapacityGB(int capacityGB) {
        this.capacityGB = capacityGB;
    }

    @Generated
    public void setUsedSizeGB(int usedSizeGB) {
        this.usedSizeGB = usedSizeGB;
    }

    @Generated
    public void setFreeSizeGB(int freeSizeGB) {
        this.freeSizeGB = freeSizeGB;
    }

    @Generated
    public void setThin(boolean isThin) {
        this.isThin = isThin;
    }

    @Generated
    public void setSuUrn(String suUrn) {
        this.suUrn = suUrn;
    }

    @Generated
    public void setSuName(String suName) {
        this.suName = suName;
    }

    @Generated
    public void setStorageUnits(List<StorageUnit> storageUnits) {
        this.storageUnits = storageUnits;
    }

    @Generated
    public void setHosts(List<String> hosts) {
        this.hosts = hosts;
    }

    @Generated
    public void setHostConnectProtocols(List<ConnectProtocol> hostConnectProtocols) {
        this.hostConnectProtocols = hostConnectProtocols;
    }
}

