/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.support;

import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.exception.FcTaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.FcInfoContext;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.utils.RetryUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.infrastructure.FcApiConstant;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import lombok.Generated;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FcRequestInterceptor
implements Interceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FcRequestInterceptor.class);
    private final Supplier<String> tokenSupplier;
    private final int timeOutMinute = 3;

    @NotNull
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Request.Builder requestBuilder = request.newBuilder();
        this.replaceSiteIdPlaceHolder(request, requestBuilder);
        this.appendRequestHeader(request, requestBuilder);
        return this.dealLoginFail(chain, requestBuilder.build());
    }

    private Response dealLoginFail(Interceptor.Chain chain, Request request) throws IOException {
        Response response = chain.proceed(request);
        if (response.isSuccessful() || response.code() != 401) {
            return response;
        }
        log.info("close original request");
        response.close();
        log.info("retry to get token.");
        String token = RetryUtils.retry(this::getToken, StringUtils::isNotEmpty, 3, TimeUnit.MINUTES);
        log.info("retry to get token success.");
        return chain.proceed(this.updateToken(request, token));
    }

    private String getToken() {
        try {
            return this.tokenSupplier.get();
        }
        catch (FcTaskException e) {
            log.error("Failed to get token.", (Throwable)((Object)e));
            return "";
        }
    }

    private Request updateToken(Request request, String token) {
        Request.Builder builder = request.newBuilder();
        builder.removeHeader("X-Auth-Token");
        builder.addHeader("X-Auth-Token", token);
        return builder.build();
    }

    private void replaceSiteIdPlaceHolder(Request request, Request.Builder requestBuilder) {
        String url = request.url().toString();
        if (url.contains("SITE_ID_PLACE_HOLDER")) {
            requestBuilder.url(url.replace("SITE_ID_PLACE_HOLDER", FcInfoContext.get().getSiteId()));
        }
    }

    private void appendRequestHeader(Request request, Request.Builder requestBuilder) {
        Set existHeaders = request.headers().names();
        this.getDefaultHeaders().entrySet().stream().filter(entry -> !existHeaders.contains(entry.getKey())).forEach(header -> requestBuilder.addHeader((String)header.getKey(), (String)header.getValue()));
    }

    private Map<String, String> getDefaultHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>(FcApiConstant.DEFAULT_HEADERS);
        String token = FcInfoContext.get().getToken();
        if (token != null) {
            headers.put("X-Auth-Token", token);
        }
        return headers;
    }

    @Generated
    public FcRequestInterceptor(Supplier<String> tokenSupplier) {
        this.tokenSupplier = tokenSupplier;
    }
}

