/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.sfs.client;

import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.DeployTaskInfoVo;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.constant.SfsConstant;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.context.SfsContext;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.entity.SfsParam;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.task.DeploySfsTaskFactory;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.task.service.SfsExecuteInstallTask;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.utils.SfsTaskUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.CommonTaskManager;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FileOperateUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ResponseUtils;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DeploySfsClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeploySfsClient.class);

    private static void startDeploySfsTask() {
        FileOperateUtils.deleteDirectory((String)SfsConstant.SFS_CACHE);
        log.info("delete sfs temporary cache directory.");
        BaseTask deploySfsVmsTask = DeploySfsTaskFactory.createDeploySfsTask();
        SfsContext.getInstance().setDeploySfsVmsTaskId(deploySfsVmsTask.getTaskId());
        CommonTaskManager.getInstance().addTask(deploySfsVmsTask);
        CommonTaskManager.getInstance().startTaskById(deploySfsVmsTask.getTaskId());
    }

    public void retrySubTask(String taskId) {
        SfsExecuteInstallTask scriptTask = SfsContext.getInstance().getScriptTask();
        if (taskId.equals(scriptTask.getTaskId())) {
            scriptTask.getSubTasks().forEach(BaseTask::clearTaskResult);
            CommonTaskManager.getInstance().retrySubTaskById(taskId);
        } else {
            CommonTaskManager.getInstance().retrySubTaskById(taskId);
        }
    }

    public void startDeployTask(SfsParam sfsParam) {
        log.info("start deploy sfs task.");
        SfsContext.getInstance().reset();
        SfsContext.getInstance().setSfsParam(sfsParam);
        DeploySfsClient.startDeploySfsTask();
    }

    public void retryDeployTask(SfsParam sfsParam) {
        log.info("start to retry deploy sfs task.");
        SfsContext.getInstance().clearResource();
        SfsContext.getInstance().setSfsParam(sfsParam);
        DeploySfsClient.startDeploySfsTask();
    }

    public Response<DeployTaskInfoVo> querySfsTaskDetail(String taskId) {
        Optional deployTaskInfoVo = CommonTaskManager.getInstance().queryTaskDetailById(taskId);
        return deployTaskInfoVo.map(ResponseUtils::success).orElseGet(() -> ResponseUtils.failed((Object)DeployTaskInfoVo.builder().build()));
    }

    public void skipItem(String itemId) {
        log.info("start skip sfs task [{}]", (Object)itemId);
        SfsTaskUtils.skipTask(itemId);
        this.retrySubTask(itemId);
    }
}

