/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.sfs.task;

import com.huawei.yinglong.river.sitedeployment.dcs.constant.TaskOperateEnum;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.FcLoginInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.TaskContext;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.disk.cmd.AttachDiskCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.enviroment.cmd.EnvironmentCheckCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.batch.cmd.BatchDeployVmsCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template.cmd.CreateVmByTemplateCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.vm.template.cmd.UploadTemplateCmd;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.service.FcTaskService;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.context.SfsContext;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.entity.SfsParam;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.entity.SfsVmParam;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.task.DeploySfsTask;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.task.SfsTemplateCleanTask;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.task.SfsTemplateUnzipTask;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.task.SfsVmsStatusCheckTask;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.task.configuration.SfsConfigurationTaskFactory;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.task.security.SfsSecureHardenTaskFactory;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.task.service.SfsExecuteInstallFactory;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.utils.SfsResourceBundleUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DeploySfsTaskFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeploySfsTaskFactory.class);

    public static BaseTask createDeploySfsTask() {
        return ((DeploySfsTask.DeploySfsTaskBuilder)((DeploySfsTask.DeploySfsTaskBuilder)((DeploySfsTask.DeploySfsTaskBuilder)((DeploySfsTask.DeploySfsTaskBuilder)((DeploySfsTask.DeploySfsTaskBuilder)DeploySfsTask.builder().taskName(SfsResourceBundleUtils.getTaskNameFromResource("deploy.sfs.vm.task"))).subTasks(DeploySfsTaskFactory.createSubTasks())).taskId(SfsContext.getInstance().getSfsParam().getTaskId())).eventType("sfsDeployEvent")).supportOperates(Collections.singletonList(TaskOperateEnum.RETRY))).build();
    }

    private static List<BaseTask> createSubTasks() {
        ArrayList<BaseTask> subTasks = new ArrayList<BaseTask>();
        subTasks.add(DeploySfsTaskFactory.createEnvironmentTask());
        subTasks.add(DeploySfsTaskFactory.createSfsTemplateUnzipTask());
        subTasks.add(DeploySfsTaskFactory.createUploadTemplateTask());
        subTasks.add(DeploySfsTaskFactory.createDeployVmsTasks());
        subTasks.add(DeploySfsTaskFactory.createSfsVmCheckTask());
        subTasks.add(DeploySfsTaskFactory.createSfsTemplateCleanTask());
        subTasks.add(SfsExecuteInstallFactory.createSfsExecuteInstallTask());
        subTasks.add(SfsConfigurationTaskFactory.createSfsConfigurationTask());
        subTasks.add(SfsSecureHardenTaskFactory.createSfsSecureHardenTask());
        subTasks.forEach(task -> task.setEventType("sfsDeployEvent"));
        return subTasks;
    }

    private static BaseTask createSfsVmCheckTask() {
        return ((SfsVmsStatusCheckTask.SfsVmsStatusCheckTaskBuilder)((SfsVmsStatusCheckTask.SfsVmsStatusCheckTaskBuilder)((SfsVmsStatusCheckTask.SfsVmsStatusCheckTaskBuilder)((SfsVmsStatusCheckTask.SfsVmsStatusCheckTaskBuilder)SfsVmsStatusCheckTask.builder().taskName(SfsResourceBundleUtils.getTaskNameFromResource("sfs.vm.status.task.name"))).duration(SfsResourceBundleUtils.getTaskDuration("sfs.vm.status.task.name"))).taskDescription(SfsResourceBundleUtils.getDescriptionFromResource("sfs.vm.status.task.name"))).supportOperates(Collections.singletonList(TaskOperateEnum.RETRY))).build();
    }

    private static SfsTemplateUnzipTask createSfsTemplateUnzipTask() {
        return ((SfsTemplateUnzipTask.SfsTemplateUnzipTaskBuilder)((SfsTemplateUnzipTask.SfsTemplateUnzipTaskBuilder)((SfsTemplateUnzipTask.SfsTemplateUnzipTaskBuilder)((SfsTemplateUnzipTask.SfsTemplateUnzipTaskBuilder)SfsTemplateUnzipTask.builder().taskName(SfsResourceBundleUtils.getTaskNameFromResource("sfs.template.unzip.task.name"))).duration(SfsResourceBundleUtils.getTaskDuration("sfs.template.unzip.task.name"))).taskDescription(SfsResourceBundleUtils.getDescriptionFromResource("sfs.template.unzip.task.name"))).supportOperates(Collections.singletonList(TaskOperateEnum.RETRY))).build();
    }

    private static SfsTemplateCleanTask createSfsTemplateCleanTask() {
        return ((SfsTemplateCleanTask.SfsTemplateCleanTaskBuilder)((SfsTemplateCleanTask.SfsTemplateCleanTaskBuilder)((SfsTemplateCleanTask.SfsTemplateCleanTaskBuilder)((SfsTemplateCleanTask.SfsTemplateCleanTaskBuilder)SfsTemplateCleanTask.builder().taskName(SfsResourceBundleUtils.getTaskNameFromResource("sfs.template.clean.task.name"))).duration(SfsResourceBundleUtils.getTaskDuration("sfs.template.clean.task.name"))).taskDescription(SfsResourceBundleUtils.getDescriptionFromResource("sfs.template.clean.task.name"))).supportOperates(Collections.singletonList(TaskOperateEnum.RETRY))).build();
    }

    private static BaseTask createDeployVmsTasks() {
        return FcTaskService.createBatchDeployVmsTask(DeploySfsTaskFactory.buildBatchDeployVmsCmd(), (FcLoginInfo)SfsContext.getInstance().getSfsParam().getFcLoginInfo());
    }

    private static List<BatchDeployVmsCmd> buildBatchDeployVmsCmd() {
        return SfsContext.getInstance().getSfsParam().getSfsVmParams().stream().map(DeploySfsTaskFactory::buildVmsCmd).collect(Collectors.toList());
    }

    private static BatchDeployVmsCmd buildVmsCmd(SfsVmParam sfsVmParam) {
        return BatchDeployVmsCmd.builder().createVmByTemplateCmdSupplier(() -> DeploySfsTaskFactory.buildVmParams(sfsVmParam)).vmId(() -> SfsContext.getInstance().getTemplateId()).attachDiskCmdSupplier(DeploySfsTaskFactory::buildAttachDisk).isBindHost(true).cnaName(sfsVmParam.getCnaName()).build();
    }

    private static AttachDiskCmd buildAttachDisk() {
        return AttachDiskCmd.builder().vmId(() -> TaskContext.get().getVmId()).diskCmds(Collections.emptyList()).build();
    }

    private static CreateVmByTemplateCmd buildVmParams(SfsVmParam sfsVmParam) {
        return ((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)((CreateVmByTemplateCmd.CreateVmByTemplateCmdBuilder)CreateVmByTemplateCmd.builder().taskName(sfsVmParam.getHostName())).vmName(sfsVmParam.getHostName())).cnaName(sfsVmParam.getCnaName())).datastoreName(sfsVmParam.getDataStore())).cpuCores(sfsVmParam.getCpu())).memorySizeGb(sfsVmParam.getMemory())).hostName(sfsVmParam.getHostName()).nicConfigs(sfsVmParam.getNicConfigs()).templateId(() -> SfsContext.getInstance().getTemplateId()).vmIdHandler(DeploySfsTaskFactory::setVmIdContext)).isAutoStartVm(false)).build();
    }

    private static void setVmIdContext(String vmId) {
        TaskContext.get().setVmId(vmId);
        SfsContext.getInstance().addVmId(vmId);
    }

    private static BaseTask createUploadTemplateTask() {
        return FcTaskService.uploadTemplateTask(() -> DeploySfsTaskFactory.buildUploadTemplateCmd(SfsContext.getInstance().getSfsParam()), (FcLoginInfo)SfsContext.getInstance().getSfsParam().getFcLoginInfo());
    }

    private static UploadTemplateCmd buildUploadTemplateCmd(SfsParam sfsParam) {
        return UploadTemplateCmd.builder().cnaName(sfsParam.getSfsBaseParam().getTemplateCnaName()).datastoreName(sfsParam.getSfsBaseParam().getTemplateDataStoreName()).filePath(() -> SfsContext.getInstance().getTemplateVhdFile()).ovfFilePath(() -> SfsContext.getInstance().getTemplateOvfFile()).templateName("sfsTemplate").templateIdHandler(DeploySfsTaskFactory.templateIdHandler()).build();
    }

    private static Consumer<String> templateIdHandler() {
        SfsContext sfsContext = SfsContext.getInstance();
        return templateId -> {
            sfsContext.setTemplateId((String)templateId);
            sfsContext.addVmId((String)templateId);
        };
    }

    private static BaseTask createEnvironmentTask() {
        return FcTaskService.createEnvironmentCheckTask(DeploySfsTaskFactory::buildEnvironmentCmd, (FcLoginInfo)SfsContext.getInstance().getSfsParam().getFcLoginInfo());
    }

    private static EnvironmentCheckCmd buildEnvironmentCmd() {
        EnvironmentCheckCmd sfsEnvironmentCheckCmd = EnvironmentCheckCmd.builder().oldVmIds(() -> SfsContext.getInstance().getVmIds()).build();
        SfsContext.getInstance().getSfsParam().getSfsVmParams().forEach(sfsVmParam -> DeploySfsTaskFactory.computeResource(sfsEnvironmentCheckCmd, sfsVmParam));
        return sfsEnvironmentCheckCmd;
    }

    private static void computeResource(EnvironmentCheckCmd environmentCheckCmd, SfsVmParam sfsVmParam) {
        environmentCheckCmd.addDatastore(sfsVmParam.getDataStore(), sfsVmParam.getSysDisk());
        environmentCheckCmd.addCpu(sfsVmParam.getCnaName(), sfsVmParam.getCpu());
        environmentCheckCmd.addMemory(sfsVmParam.getCnaName(), sfsVmParam.getMemory());
    }

    @Generated
    private DeploySfsTaskFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

