/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.sfs.task;

import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.client.ApiClient;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.exception.FcTaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.task.base.FcLoginInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.service.FcClientService;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.constant.SfsConstant;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.context.SfsContext;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FileOperateUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SfsTemplateCleanTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SfsTemplateCleanTask.class);
    public static final String TASK_NAME = "sfs.template.clean.task.name";

    public void execute() throws TaskException {
        SfsContext sfsContext = SfsContext.getInstance();
        if (StringUtils.isEmpty((CharSequence)sfsContext.getTemplateId())) {
            log.info("template id is empty, no need to delete.");
            return;
        }
        log.info("start to delete sfs template.");
        try {
            ApiClient apiService = FcClientService.createApiService((FcLoginInfo)sfsContext.getSfsParam().getFcLoginInfo());
            if (!apiService.deleteVm(sfsContext.getTemplateId())) {
                log.warn("delete sfs template failed");
                return;
            }
            log.info("delete template {}", (Object)sfsContext.getTemplateId());
            this.appendTaskDetail("delete sfs template, id:" + sfsContext.getTemplateId());
        }
        catch (FcTaskException e) {
            this.appendTaskDetail(StringUtils.formatTxt((String)"delete vm %s failed", (Object[])new Object[]{sfsContext.getTemplateId()}));
            log.error("clear sfs template failed", (Throwable)e);
        }
        finally {
            FileOperateUtils.deleteDirectory((String)SfsConstant.SFS_CACHE);
        }
    }

    @Generated
    protected SfsTemplateCleanTask(SfsTemplateCleanTaskBuilder<?, ?> b) {
        super(b);
    }

    @Generated
    public static SfsTemplateCleanTaskBuilder<?, ?> builder() {
        return new SfsTemplateCleanTaskBuilderImpl();
    }

    @Generated
    private static final class SfsTemplateCleanTaskBuilderImpl
    extends SfsTemplateCleanTaskBuilder<SfsTemplateCleanTask, SfsTemplateCleanTaskBuilderImpl> {
        @Generated
        private SfsTemplateCleanTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected SfsTemplateCleanTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SfsTemplateCleanTask build() {
            return new SfsTemplateCleanTask(this);
        }
    }

    @Generated
    public static abstract class SfsTemplateCleanTaskBuilder<C extends SfsTemplateCleanTask, B extends SfsTemplateCleanTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "SfsTemplateCleanTask.SfsTemplateCleanTaskBuilder(super=" + super.toString() + ")";
        }
    }
}

