/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.sfs.task;

import com.huawei.yinglong.river.sitedeployment.dcs.sfs.constant.SfsConstant;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.context.SfsContext;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.entity.SfsBaseParam;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.exception.DeploySfsError;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.exception.DeploySfsException;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FileOperateUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ZipUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.exception.ErrorKey;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

public class SfsTemplateUnzipTask
extends BaseTask {
    public static final String TASK_NAME = "sfs.template.unzip.task.name";
    private String sfsTemplateFilePath;

    public void beforeExecute() {
        this.sfsTemplateFilePath = Optional.ofNullable(SfsContext.getInstance().getSfsParam().getSfsBaseParam()).map(SfsBaseParam::getTemplatePath).orElse("");
        if (StringUtils.isEmpty((CharSequence)this.sfsTemplateFilePath) || !FilePathValidatorUtils.isValidExistPaths((String[])new String[]{this.sfsTemplateFilePath})) {
            throw new TaskException((ErrorKey)DeploySfsError.PARAM_ERROR);
        }
        FileOperateUtils.deleteDirectory((String)SfsConstant.SFS_TEMPORARY_CACHE);
        this.createTemplateCache(new File(SfsConstant.SFS_TEMPORARY_CACHE));
    }

    public void execute() throws TaskException {
        SfsContext context = SfsContext.getInstance();
        this.appendTaskDetail("start to unzip template file.");
        ZipUtils.decompressFileBy7Zip((String)SfsConstant.ZIP_TOOL_PATH, (String)this.getSfsTemplateFilePath(), (String)SfsConstant.SFS_TEMPORARY_CACHE);
        context.setTemplateVhdFile(this.getTemplateUnzipFile(SfsConstant.SFS_TEMPORARY_CACHE, "vhd"));
        context.setTemplateOvfFile(this.getTemplateUnzipFile(SfsConstant.SFS_TEMPORARY_CACHE, "ovf"));
        this.appendTaskDetail("finish to unzip template file.");
    }

    @NotNull
    private String getSfsTemplateFilePath() {
        List zipFiles = Arrays.stream((Object[])Objects.requireNonNull(new File(this.sfsTemplateFilePath).listFiles())).filter(file -> file.getName().matches("^DCS_SFS.*\\.zip$")).map(String::valueOf).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(zipFiles)) {
            throw new DeploySfsException(DeploySfsError.TEMPLATE_FILE_NOT_EXIST);
        }
        if (zipFiles.size() > 1) {
            throw new DeploySfsException(DeploySfsError.MULTI_TEMPLATE_ZIP_EXIST);
        }
        return (String)zipFiles.get(0);
    }

    private void createTemplateCache(File file) {
        if (!file.exists() && !file.mkdirs()) {
            throw new DeploySfsException(DeploySfsError.CREATE_TEMPLATE_CACHE_FAILED);
        }
    }

    private String getTemplateUnzipFile(String sfsTemporaryCache, String fileSuffix) {
        return (String)FileUtils.listFiles((File)new File(sfsTemporaryCache), (String[])new String[]{fileSuffix}, (boolean)false).stream().findFirst().flatMap(FilePathValidatorUtils::getSafePath).orElseThrow(() -> new DeploySfsException(DeploySfsError.VHD_OVF_FILE_NOT_EXIST));
    }

    @Generated
    protected SfsTemplateUnzipTask(SfsTemplateUnzipTaskBuilder<?, ?> b) {
        super(b);
        this.sfsTemplateFilePath = ((SfsTemplateUnzipTaskBuilder)b).sfsTemplateFilePath;
    }

    @Generated
    public static SfsTemplateUnzipTaskBuilder<?, ?> builder() {
        return new SfsTemplateUnzipTaskBuilderImpl();
    }

    @Generated
    private static final class SfsTemplateUnzipTaskBuilderImpl
    extends SfsTemplateUnzipTaskBuilder<SfsTemplateUnzipTask, SfsTemplateUnzipTaskBuilderImpl> {
        @Generated
        private SfsTemplateUnzipTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected SfsTemplateUnzipTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SfsTemplateUnzipTask build() {
            return new SfsTemplateUnzipTask(this);
        }
    }

    @Generated
    public static abstract class SfsTemplateUnzipTaskBuilder<C extends SfsTemplateUnzipTask, B extends SfsTemplateUnzipTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private String sfsTemplateFilePath;

        @Generated
        public B sfsTemplateFilePath(String sfsTemplateFilePath) {
            this.sfsTemplateFilePath = sfsTemplateFilePath;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "SfsTemplateUnzipTask.SfsTemplateUnzipTaskBuilder(super=" + super.toString() + ", sfsTemplateFilePath=" + this.sfsTemplateFilePath + ")";
        }
    }
}

