/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.sfs.task;

import com.huawei.yinglong.river.sitedeployment.dcs.fcvm.business.utils.RetryUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.context.SfsContext;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.entity.SfsVmParam;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.exception.DeploySfsError;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.exception.DeploySfsException;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.IpUtils;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SfsVmsStatusCheckTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SfsVmsStatusCheckTask.class);
    public static final String TASK_NAME = "sfs.vm.status.task.name";
    private List<SfsVmParam> sfsVmParams;

    public void execute() throws TaskException {
        this.sfsVmParams = SfsContext.getInstance().getSfsParam().getSfsVmParams();
        try {
            RetryUtils.retry(this::checkAllIpReachable, (int)30, (TimeUnit)TimeUnit.MINUTES);
        }
        catch (TaskException e) {
            throw new DeploySfsException(DeploySfsError.SFS_VMS_IP_CHECK_FAILED);
        }
    }

    private boolean checkAllIpReachable() {
        return this.sfsVmParams.stream().allMatch(sfsVmParam -> IpUtils.isReachable((String)sfsVmParam.getOmIp()));
    }

    @Generated
    protected SfsVmsStatusCheckTask(SfsVmsStatusCheckTaskBuilder<?, ?> b) {
        super(b);
        this.sfsVmParams = ((SfsVmsStatusCheckTaskBuilder)b).sfsVmParams;
    }

    @Generated
    public static SfsVmsStatusCheckTaskBuilder<?, ?> builder() {
        return new SfsVmsStatusCheckTaskBuilderImpl();
    }

    @Generated
    private static final class SfsVmsStatusCheckTaskBuilderImpl
    extends SfsVmsStatusCheckTaskBuilder<SfsVmsStatusCheckTask, SfsVmsStatusCheckTaskBuilderImpl> {
        @Generated
        private SfsVmsStatusCheckTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected SfsVmsStatusCheckTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SfsVmsStatusCheckTask build() {
            return new SfsVmsStatusCheckTask(this);
        }
    }

    @Generated
    public static abstract class SfsVmsStatusCheckTaskBuilder<C extends SfsVmsStatusCheckTask, B extends SfsVmsStatusCheckTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private List<SfsVmParam> sfsVmParams;

        @Generated
        public B sfsVmParams(List<SfsVmParam> sfsVmParams) {
            this.sfsVmParams = sfsVmParams;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "SfsVmsStatusCheckTask.SfsVmsStatusCheckTaskBuilder(super=" + super.toString() + ", sfsVmParams=" + this.sfsVmParams + ")";
        }
    }
}

