/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.sfs.task.configuration;

import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.entity.SfsParam;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.entity.SfsVmParam;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.exception.DeploySfsError;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.exception.DeploySfsException;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.utils.SfsTaskUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.utils.SshConnectSfsServiceUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.DefaultSshEndJudge;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshEndJudge;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.util.function.Supplier;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SfsSetDmeInfoTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SfsSetDmeInfoTask.class);
    private final DefaultSshEndJudge endJudge = new DefaultSshEndJudge();
    private Supplier<SfsParam> sfsParamSupplier;
    private Supplier<SfsVmParam> sfsVmParamSupplier;

    public void beforeExecute() {
        String detail = StringUtils.formatTxt((String)"start to execute the setting eDME information task, vm name = %s.", (Object[])new Object[]{this.sfsVmParamSupplier.get().getHostName()});
        log.info(detail);
        this.appendTaskDetail(detail);
    }

    public void execute() throws TaskException {
        try (SshShellService shellClient = SshConnectSfsServiceUtils.getShellClient(this.sfsParamSupplier.get().getSfsPassword(), this.sfsVmParamSupplier.get());){
            shellClient.connect();
            String result = shellClient.execCommand("su openstack -s /bin/bash");
            this.appendTaskDetail(result);
            if (!result.endsWith("$ ")) {
                this.appendTaskDetail("Failed to switch to the openstack user");
                throw new DeploySfsException(DeploySfsError.SFS_CHANGE_OPENSTACK_USER_ERROR);
            }
            result = shellClient.execCommand("source /opt/huawei/dj/inst/run_utils.sh;echo last cmd result: $?");
            this.appendTaskDetail(result);
            if (!result.contains("last cmd result: 0")) {
                this.appendTaskDetail("Failed to execute source /opt/huawei/dj/inst/run_utils.sh, not last cmd result: 0");
                throw new DeploySfsException(DeploySfsError.SFS_SET_E_DME_INFORMATION_ERROR);
            }
            String cmd = this.getConfigurationCmd();
            result = shellClient.execCommand(cmd, (SshEndJudge)this.endJudge);
            this.appendTaskDetail(result);
            if (StringUtils.containIgnoreCase((String)result, (String[])new String[]{"Please input the password of op_service user:"})) {
                result = shellClient.execCommand(StringUtils.defaultString((String)this.sfsParamSupplier.get().getSfsPassword().getDjPwd()));
            }
            this.appendTaskDetail(SfsTaskUtils.replaceSensitiveTexts(result, this.sfsParamSupplier.get().getSfsPassword().getDjPwd()));
            if (!result.contains("last cmd result: 0")) {
                this.appendTaskDetail("Failed to set the eDME information, not last cmd result: 0");
                throw new DeploySfsException(DeploySfsError.SFS_SET_E_DME_INFORMATION_ERROR);
            }
        }
        catch (SshException e) {
            log.error("ssh execute error: ", (Throwable)e);
            throw new DeploySfsException(DeploySfsError.SFS_SSH_OPTION_ERROR);
        }
        catch (Exception e) {
            log.error("ssh connect error: ", (Throwable)e);
            throw new DeploySfsException(DeploySfsError.SFS_SSH_CONNECT_ERROR);
        }
    }

    @NotNull
    private String getConfigurationCmd() {
        return StringUtils.formatTxt((String)"set_edme --edme_host %s --lang %s;echo last cmd result: $?", (Object[])new Object[]{this.sfsParamSupplier.get().getSfsBaseParam().getEDmeIp(), this.sfsParamSupplier.get().getSfsBaseParam().getLanguage()});
    }

    @Generated
    protected SfsSetDmeInfoTask(SfsSetDmeInfoTaskBuilder<?, ?> b) {
        super(b);
        this.sfsParamSupplier = ((SfsSetDmeInfoTaskBuilder)b).sfsParamSupplier;
        this.sfsVmParamSupplier = ((SfsSetDmeInfoTaskBuilder)b).sfsVmParamSupplier;
    }

    @Generated
    public static SfsSetDmeInfoTaskBuilder<?, ?> builder() {
        return new SfsSetDmeInfoTaskBuilderImpl();
    }

    @Generated
    private static final class SfsSetDmeInfoTaskBuilderImpl
    extends SfsSetDmeInfoTaskBuilder<SfsSetDmeInfoTask, SfsSetDmeInfoTaskBuilderImpl> {
        @Generated
        private SfsSetDmeInfoTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected SfsSetDmeInfoTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SfsSetDmeInfoTask build() {
            return new SfsSetDmeInfoTask(this);
        }
    }

    @Generated
    public static abstract class SfsSetDmeInfoTaskBuilder<C extends SfsSetDmeInfoTask, B extends SfsSetDmeInfoTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private Supplier<SfsParam> sfsParamSupplier;
        @Generated
        private Supplier<SfsVmParam> sfsVmParamSupplier;

        @Generated
        public B sfsParamSupplier(Supplier<SfsParam> sfsParamSupplier) {
            this.sfsParamSupplier = sfsParamSupplier;
            return (B)this.self();
        }

        @Generated
        public B sfsVmParamSupplier(Supplier<SfsVmParam> sfsVmParamSupplier) {
            this.sfsVmParamSupplier = sfsVmParamSupplier;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "SfsSetDmeInfoTask.SfsSetDmeInfoTaskBuilder(super=" + super.toString() + ", sfsParamSupplier=" + this.sfsParamSupplier + ", sfsVmParamSupplier=" + this.sfsVmParamSupplier + ")";
        }
    }
}

