/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.sfs.task.security;

import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.entity.SfsParam;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.entity.SfsVmParam;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.exception.DeploySfsError;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.exception.DeploySfsException;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.utils.SshConnectSfsServiceUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.DefaultSshEndJudge;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshEndJudge;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SfsChangePasswordTask
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SfsChangePasswordTask.class);
    private final DefaultSshEndJudge endJudge = new DefaultSshEndJudge();
    private Supplier<SfsParam> sfsParamSupplier;
    private Supplier<SfsVmParam> sfsVmParamSupplier;

    public void beforeExecute() {
        String detail = StringUtils.formatTxt((String)"start to execute the secure harden task, vm name = %s.", (Object[])new Object[]{this.sfsVmParamSupplier.get().getHostName()});
        log.info(detail);
        this.appendTaskDetail(detail);
    }

    public void execute() throws TaskException {
        try (SshShellService shellClient = SshConnectSfsServiceUtils.getShellClient(this.sfsParamSupplier.get().getSfsPassword(), this.sfsVmParamSupplier.get());){
            shellClient.connect();
            String cmd = "bash /root/SFS/scripts/shell_scripts/security_harden.sh;echo last cmd result: $?";
            String result = shellClient.execCommand(cmd, (SshEndJudge)this.endJudge);
            log.info("execute {}.", (Object)cmd);
            this.appendTaskDetail("bash /root/SFS/scripts/shell_scripts/security_harden.sh;echo last cmd result: $?");
            if (StringUtils.containIgnoreCase((String)result, (String[])new String[]{"Please input password of djmanager:"})) {
                result = shellClient.execCommand(StringUtils.defaultString((String)this.sfsParamSupplier.get().getSfsPassword().getDjmanagerPassword()), (SshEndJudge)this.endJudge);
            }
            if (StringUtils.containIgnoreCase((String)result, (String[])new String[]{"Please input password of root:"})) {
                result = shellClient.execCommand(StringUtils.defaultString((String)this.sfsParamSupplier.get().getSfsPassword().getRootPassword()));
            }
            if (!result.contains("last cmd result: 0")) {
                this.appendTaskDetail("not last cmd result: 0");
                throw new DeploySfsException(DeploySfsError.SFS_SECURE_HARDEN_ERROR);
            }
            this.appendTaskDetail("last cmd result: 0");
            log.info("{} vm change password success", (Object)this.sfsVmParamSupplier.get().getHostName());
        }
        catch (SshException e) {
            log.error("ssh execute error: ", (Throwable)e);
            throw new DeploySfsException(DeploySfsError.SFS_SSH_OPTION_ERROR);
        }
        catch (Exception e) {
            log.error("ssh connect error: ", (Throwable)e);
            throw new DeploySfsException(DeploySfsError.SFS_SSH_CONNECT_ERROR);
        }
    }

    @Generated
    protected SfsChangePasswordTask(SfsChangePasswordTaskBuilder<?, ?> b) {
        super(b);
        this.sfsParamSupplier = ((SfsChangePasswordTaskBuilder)b).sfsParamSupplier;
        this.sfsVmParamSupplier = ((SfsChangePasswordTaskBuilder)b).sfsVmParamSupplier;
    }

    @Generated
    public static SfsChangePasswordTaskBuilder<?, ?> builder() {
        return new SfsChangePasswordTaskBuilderImpl();
    }

    @Generated
    private static final class SfsChangePasswordTaskBuilderImpl
    extends SfsChangePasswordTaskBuilder<SfsChangePasswordTask, SfsChangePasswordTaskBuilderImpl> {
        @Generated
        private SfsChangePasswordTaskBuilderImpl() {
        }

        @Override
        @Generated
        protected SfsChangePasswordTaskBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SfsChangePasswordTask build() {
            return new SfsChangePasswordTask(this);
        }
    }

    @Generated
    public static abstract class SfsChangePasswordTaskBuilder<C extends SfsChangePasswordTask, B extends SfsChangePasswordTaskBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private Supplier<SfsParam> sfsParamSupplier;
        @Generated
        private Supplier<SfsVmParam> sfsVmParamSupplier;

        @Generated
        public B sfsParamSupplier(Supplier<SfsParam> sfsParamSupplier) {
            this.sfsParamSupplier = sfsParamSupplier;
            return (B)this.self();
        }

        @Generated
        public B sfsVmParamSupplier(Supplier<SfsVmParam> sfsVmParamSupplier) {
            this.sfsVmParamSupplier = sfsVmParamSupplier;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "SfsChangePasswordTask.SfsChangePasswordTaskBuilder(super=" + super.toString() + ", sfsParamSupplier=" + this.sfsParamSupplier + ", sfsVmParamSupplier=" + this.sfsVmParamSupplier + ")";
        }
    }
}

