/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.sfs.task.service;

import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.entity.SfsParam;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.entity.SfsVmParam;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.exception.DeploySfsError;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.exception.DeploySfsException;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.utils.SshConnectSfsServiceUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.util.function.Supplier;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SfsExecuteInstallScript
extends BaseTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SfsExecuteInstallScript.class);
    private Supplier<SfsParam> sfsParamSupplier;
    private Supplier<SfsVmParam> sfsVmParamSupplier;

    public void beforeExecute() {
        log.info("start to invoke the installation script, vm name = {}.", (Object)this.sfsVmParamSupplier.get().getHostName());
        this.appendTaskDetail("start to invoke the installation script.");
    }

    public void execute() throws TaskException {
        try (SshShellService shellClient = SshConnectSfsServiceUtils.getShellClient(this.sfsParamSupplier.get().getSfsPassword(), this.sfsVmParamSupplier.get());){
            shellClient.connect();
            String cmd = "bash /root/SFS/install.sh rollback; echo last cmd result $?";
            String result = shellClient.execCommand(cmd);
            this.appendTaskDetail(result);
            log.info(result);
            if (!result.contains("last cmd result 0")) {
                throw new DeploySfsException(DeploySfsError.SFS_CLEAN_SCRIPT_ERROR);
            }
            cmd = this.buildInitScriptCmd();
            result = shellClient.execCommandWithTimeout(cmd, 1800);
            this.appendTaskDetail(result);
            log.info(result);
            if (!result.contains("last cmd result 0")) {
                throw new DeploySfsException(DeploySfsError.SFS_INVOKE_SCRIPT_ERROR);
            }
            log.info("{} vm invoke script success", (Object)this.sfsVmParamSupplier.get().getHostName());
        }
        catch (SshException e) {
            log.error("ssh execute error: ", (Throwable)e);
            throw new DeploySfsException(DeploySfsError.SFS_SSH_OPTION_ERROR);
        }
        catch (Exception e) {
            log.error("ssh connect error: ", (Throwable)e);
            throw new DeploySfsException(DeploySfsError.SFS_SSH_CONNECT_ERROR);
        }
    }

    @NotNull
    private String buildInitScriptCmd() {
        SfsParam sfsParam = this.sfsParamSupplier.get();
        return StringUtils.formatTxt((String)"bash /root/SFS/install.sh %s,%s %s %s --usage_scene DCS; echo last cmd result $?", (Object[])new Object[]{sfsParam.getSfsVmParams().get(0).getOmIp(), sfsParam.getSfsVmParams().get(1).getOmIp(), sfsParam.getSfsBaseParam().getGaussDbFloatIp(), sfsParam.getSfsBaseParam().getManageFloatIp()});
    }

    @Generated
    protected SfsExecuteInstallScript(SfsExecuteInstallScriptBuilder<?, ?> b) {
        super(b);
        this.sfsParamSupplier = ((SfsExecuteInstallScriptBuilder)b).sfsParamSupplier;
        this.sfsVmParamSupplier = ((SfsExecuteInstallScriptBuilder)b).sfsVmParamSupplier;
    }

    @Generated
    public static SfsExecuteInstallScriptBuilder<?, ?> builder() {
        return new SfsExecuteInstallScriptBuilderImpl();
    }

    @Generated
    private static final class SfsExecuteInstallScriptBuilderImpl
    extends SfsExecuteInstallScriptBuilder<SfsExecuteInstallScript, SfsExecuteInstallScriptBuilderImpl> {
        @Generated
        private SfsExecuteInstallScriptBuilderImpl() {
        }

        @Override
        @Generated
        protected SfsExecuteInstallScriptBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public SfsExecuteInstallScript build() {
            return new SfsExecuteInstallScript(this);
        }
    }

    @Generated
    public static abstract class SfsExecuteInstallScriptBuilder<C extends SfsExecuteInstallScript, B extends SfsExecuteInstallScriptBuilder<C, B>>
    extends BaseTask.BaseTaskBuilder<C, B> {
        @Generated
        private Supplier<SfsParam> sfsParamSupplier;
        @Generated
        private Supplier<SfsVmParam> sfsVmParamSupplier;

        @Generated
        public B sfsParamSupplier(Supplier<SfsParam> sfsParamSupplier) {
            this.sfsParamSupplier = sfsParamSupplier;
            return (B)this.self();
        }

        @Generated
        public B sfsVmParamSupplier(Supplier<SfsVmParam> sfsVmParamSupplier) {
            this.sfsVmParamSupplier = sfsVmParamSupplier;
            return (B)this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "SfsExecuteInstallScript.SfsExecuteInstallScriptBuilder(super=" + super.toString() + ", sfsParamSupplier=" + this.sfsParamSupplier + ", sfsVmParamSupplier=" + this.sfsVmParamSupplier + ")";
        }
    }
}

