/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.sfs.utils;

import com.huawei.yinglong.river.sitedeployment.dcs.sfs.context.SfsContext;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.exception.DeploySfsError;
import com.huawei.yinglong.river.sitedeployment.dcs.sfs.exception.DeploySfsException;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.CommonTaskManager;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskStatus;
import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SfsTaskUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SfsTaskUtils.class);

    public static String replaceSensitiveTexts(String result, String sensitive) {
        return result.replace(sensitive.trim(), "******");
    }

    public static void skipTask(String taskId) {
        BaseTask task = (BaseTask)CommonTaskManager.getInstance().queryTaskById(SfsContext.getInstance().getDeploySfsVmsTaskId()).orElseThrow(() -> new DeploySfsException(DeploySfsError.TASK_ID_NOT_FOUND_ERROR));
        SfsTaskUtils.setSkipStatus(SfsTaskUtils.findSubTasks(task, taskId).orElseThrow(() -> new DeploySfsException(DeploySfsError.TASK_ID_NOT_FOUND_ERROR)));
    }

    private static void setSkipStatus(BaseTask baseTask) {
        if (CollectionUtils.isEmpty((Collection)baseTask.getSubTasks())) {
            return;
        }
        for (BaseTask task : baseTask.getSubTasks()) {
            if (task.getTaskResult().getTaskStatus() != TaskStatus.ERROR && task.getTaskResult().getTaskStatus() != TaskStatus.NOT_START) continue;
            task.getTaskResult().setTaskStatus(TaskStatus.SKIP);
            SfsTaskUtils.setSkipStatus(task);
        }
    }

    private static Optional<BaseTask> findSubTasks(BaseTask task, String taskId) {
        if (task.getTaskId().equals(taskId)) {
            return Optional.of(task);
        }
        if (CollectionUtils.isNotEmpty((Collection)task.getSubTasks())) {
            for (BaseTask baseTask : task.getSubTasks()) {
                Optional<BaseTask> optionalBaseTask = SfsTaskUtils.findSubTasks(baseTask, taskId);
                if (!optionalBaseTask.isPresent()) continue;
                return optionalBaseTask;
            }
        }
        return Optional.empty();
    }

    @Generated
    private SfsTaskUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

