/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.annotation.impl;

import com.huawei.yinglong.river.sitedeployment.dcs.annotation.Hostname;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.lang.annotation.Annotation;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class HostnameValidator
implements ConstraintValidator<Hostname, String> {
    private static final Pattern PATTERN_HOSTNAME = Pattern.compile("^[a-zA-Z\\d]([a-zA-Z\\d_-]){0,62}$");
    private boolean isRequired = true;

    public void initialize(Hostname constraintAnnotation) {
        super.initialize((Annotation)constraintAnnotation);
        this.isRequired = constraintAnnotation.required();
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (!this.isRequired && StringUtils.isEmpty(value)) {
            return true;
        }
        return PATTERN_HOSTNAME.matcher(value).find();
    }
}

