/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.annotation.impl;

import com.huawei.yinglong.river.sitedeployment.dcs.annotation.IpAddress;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.IpUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.lang.annotation.Annotation;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class IpAddressValidator
implements ConstraintValidator<IpAddress, String> {
    private boolean isNetmask;
    private boolean isRequired;
    private boolean allowLoopbackAddress;

    public void initialize(IpAddress constraintAnnotation) {
        super.initialize((Annotation)constraintAnnotation);
        this.isNetmask = constraintAnnotation.isNetmask();
        this.isRequired = constraintAnnotation.required();
        this.allowLoopbackAddress = constraintAnnotation.allowLoopbackAddress();
    }

    public boolean isValid(String value, ConstraintValidatorContext constraintValidatorContext) {
        if (!this.isRequired && StringUtils.isEmpty(value)) {
            return true;
        }
        if (this.isNetmask) {
            return IpUtils.isValidNetmask(value);
        }
        if (!this.allowLoopbackAddress && StringUtils.isNotEmpty(value) && value.matches("127(\\.\\d{1,3}){3}")) {
            return false;
        }
        return IpUtils.isValidIpV4(value) || IpUtils.isValidIpV6(value);
    }
}

