/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.annotation.impl;

import com.huawei.yinglong.river.sitedeployment.dcs.annotation.NetworkSegment;
import com.huawei.yinglong.river.sitedeployment.dcs.annotation.validation.NetworkSegmentCheckable;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.IpUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.stream.Stream;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class NetworkSegmentValidator
implements ConstraintValidator<NetworkSegment, NetworkSegmentCheckable> {
    private boolean isRequired = true;

    public void initialize(NetworkSegment constraintAnnotation) {
        super.initialize((Annotation)constraintAnnotation);
        this.isRequired = constraintAnnotation.required();
    }

    public boolean isValid(NetworkSegmentCheckable checkable, ConstraintValidatorContext constraintValidatorContext) {
        String[] ipAddress;
        String netmask;
        if (!this.isRequired && checkable == null) {
            return true;
        }
        String gateway = checkable.getGateway();
        if (this.isInvalidParams(gateway, netmask = checkable.getNetmask(), ipAddress = checkable.getIpAddress())) {
            return !this.isRequired;
        }
        return Stream.of(ipAddress).filter(StringUtils::isNotEmpty).allMatch(ip -> IpUtils.checkNetworkRangeValid(ip, netmask, gateway));
    }

    private boolean isInvalidParams(String gateway, String netmask, String[] ipAddress) {
        if (StringUtils.isEmpty(gateway) || StringUtils.isEmpty(netmask)) {
            return true;
        }
        return ipAddress == null || ipAddress.length <= 0 || Stream.of(ipAddress).allMatch(Objects::isNull);
    }
}

