/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.annotation.impl;

import com.huawei.encryptbase.exception.ProcessEncryptException;
import com.huawei.yinglong.river.sitedeployment.dcs.annotation.Password;
import com.huawei.yinglong.river.sitedeployment.dcs.constant.PasswordValidTypeEnum;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.KmcCryptUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.WeakPasswordValidUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.valid.PasswordCommonValidUtils;
import java.lang.annotation.Annotation;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordValidator
implements ConstraintValidator<Password, String> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PasswordValidator.class);
    private static final String SPACIAL_CHARS = "~!@#$%^&*( )-_=+|\\[{}];:\",<.>/?";
    private static final int MIN_PASSWORD_TYPE_NUM = 2;
    private boolean isRequired = true;
    private String regex;
    private PasswordValidTypeEnum type;
    private String username;
    private String invalidChars;
    private boolean shouldValidWeakPassword = false;
    private int minLength;
    private int maxLength;
    private int maxAllowSameCharCount;

    public void initialize(Password constraintAnnotation) {
        super.initialize((Annotation)constraintAnnotation);
        this.isRequired = constraintAnnotation.required();
        this.shouldValidWeakPassword = constraintAnnotation.needValidWeakPassword();
        this.username = constraintAnnotation.username();
        this.invalidChars = constraintAnnotation.invalidChars();
        this.minLength = constraintAnnotation.minLength();
        this.maxLength = constraintAnnotation.maxLength();
        this.maxAllowSameCharCount = constraintAnnotation.maxAllowConsecutiveSameCharCount();
        this.regex = constraintAnnotation.regex();
        this.type = constraintAnnotation.type();
    }

    private boolean checkMaxAllowSameChars(String value) {
        if (this.maxAllowSameCharCount >= this.maxLength) {
            return true;
        }
        char[] valueChars = value.toCharArray();
        int i = 0;
        for (int j = i + 1; j < valueChars.length; ++j) {
            if (j - i > this.maxAllowSameCharCount) {
                return false;
            }
            if (valueChars[i] == valueChars[j]) continue;
            i = j;
        }
        return true;
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        String pwd = value;
        try {
            pwd = KmcCryptUtils.decrypt(value);
        }
        catch (ProcessEncryptException e) {
            log.warn("Current password is not encrypted.");
        }
        if (!this.isRequired && StringUtils.isEmpty(pwd)) {
            return true;
        }
        if (PasswordValidTypeEnum.needValid(this.type)) {
            return PasswordValidTypeEnum.validPassword(this.type, pwd);
        }
        if (StringUtils.isNotEmpty(this.regex)) {
            return pwd.matches(this.regex);
        }
        if (StringUtils.isEmpty(pwd) || pwd.length() < this.minLength || pwd.length() > this.maxLength) {
            return false;
        }
        if (!PasswordCommonValidUtils.validCommonCharacterPassword(pwd, 2)) {
            return false;
        }
        if (PasswordCommonValidUtils.validContainUsername(pwd, this.username)) {
            return false;
        }
        if (StringUtils.isNotEmpty(this.invalidChars) && Pattern.compile(this.invalidChars).matcher(pwd).find()) {
            return false;
        }
        if (!this.checkMaxAllowSameChars(pwd)) {
            return false;
        }
        return !this.shouldValidWeakPassword || WeakPasswordValidUtils.validWeakPassword(pwd);
    }
}

