/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.annotation.validation;

import com.huawei.yinglong.river.sitedeployment.dcs.annotation.validation.ItemNamedValidatable;
import com.huawei.yinglong.river.sitedeployment.dcs.annotation.validation.NetworkSegmentCheckable;
import com.huawei.yinglong.river.sitedeployment.dcs.annotation.validation.ValidResourceSupplier;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.NumberUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.resource.ResourceBundleUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import lombok.Generated;
import org.hibernate.validator.messageinterpolation.ResourceBundleMessageInterpolator;
import org.hibernate.validator.resourceloading.AggregateResourceBundleLocator;
import org.hibernate.validator.spi.resourceloading.ResourceBundleLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ObjectValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ObjectValidator.class);
    private static final String RESOURCE_NAME = "ValidationMessages";
    private static final List<String> VALIDATION_RESOURCE_NAMES = Collections.unmodifiableList(Arrays.asList("ValidationMessages", "ValidationMessages_fc", "ValidationMessages_ebackup", "ValidationMessages_ultravr", "ValidationMessages_dme", "ValidationMessages_fcvp"));
    private static final Pattern PATTERN_IDX = Pattern.compile("\\[\\d+]");
    private static final Validator VALIDATOR;

    public static <T> List<String> valid(T object, Class<?> ... groups) {
        return ObjectValidator.valid(object, (String key) -> ResourceBundleUtils.getStringFromResource(RESOURCE_NAME, key), groups);
    }

    public static <T> List<String> valid(T object, ValidResourceSupplier supplier, Class<?> ... groups) {
        Set constrains = VALIDATOR.validate(object, (Class[])groups);
        return constrains.stream().filter(Objects::nonNull).map(cv -> ObjectValidator.getFieldName(cv, supplier) + ": " + cv.getMessage()).collect(Collectors.toList());
    }

    private static String getFieldName(ConstraintViolation<?> constraintViolation, ValidResourceSupplier supplier) {
        Object leafBean = constraintViolation.getLeafBean();
        String key = String.valueOf(constraintViolation.getPropertyPath());
        if (StringUtils.isNotEmpty(key)) {
            String validName = Optional.ofNullable(leafBean).filter(bean -> bean instanceof ItemNamedValidatable).map(ItemNamedValidatable.class::cast).map(ItemNamedValidatable::getValidName).orElse("");
            return ObjectValidator.getFieldName(key, validName, supplier);
        }
        if (leafBean instanceof NetworkSegmentCheckable && StringUtils.isNotEmpty(key = ((NetworkSegmentCheckable)leafBean).getKey())) {
            return supplier.get(key);
        }
        return "";
    }

    private static List<Integer> parseArrIdx(String resKey) {
        LinkedList<Integer> paramIds = new LinkedList<Integer>();
        Matcher matcher = PATTERN_IDX.matcher(resKey);
        while (matcher.find()) {
            String idx = matcher.group();
            paramIds.add(NumberUtils.parseInt(idx.substring(1, idx.length() - 1), 0) + 1);
        }
        return paramIds;
    }

    private static String getFieldName(String resKey, String validName, ValidResourceSupplier supplier) {
        try {
            String realKey = resKey.replaceAll("\\[\\d+]", "");
            String realValue = supplier.get(realKey);
            List<Integer> fieldIdx = ObjectValidator.parseArrIdx(resKey);
            if (fieldIdx.isEmpty()) {
                return realValue;
            }
            if (StringUtils.isNotEmpty(validName)) {
                return StringUtils.formatTxt(realValue, validName);
            }
            return StringUtils.formatTxt(realValue, fieldIdx.toArray(new Object[0]));
        }
        catch (MissingResourceException e) {
            log.error("not find resource key {}.", (Object)resKey);
            return resKey;
        }
    }

    @Generated
    private ObjectValidator() {
    }

    static {
        try (ValidatorFactory factory = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ResourceBundleMessageInterpolator((ResourceBundleLocator)new AggregateResourceBundleLocator(VALIDATION_RESOURCE_NAMES))).buildValidatorFactory();){
            VALIDATOR = factory.getValidator();
        }
    }
}

