/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.consistency;

import com.huawei.yinglong.river.sitedeployment.dcs.consistency.ConsistencyCheckItem;
import com.huawei.yinglong.river.sitedeployment.dcs.consistency.ConsistencyTaskInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.consistency.ConsistencyType;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistencyCheckTask
extends Thread {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConsistencyCheckTask.class);
    private final ConsistencyTaskInfo taskInfo;

    ConsistencyCheckTask(ConsistencyTaskInfo taskInfo) {
        super(taskInfo.getUuid());
        this.taskInfo = taskInfo;
    }

    private boolean verifyConsistencyFile(ConsistencyCheckItem checkItem) {
        ConsistencyType consistencyType = checkItem.getConsistencyType();
        if (consistencyType == null) {
            consistencyType = this.taskInfo.getConsistencyType();
        }
        return consistencyType != null && consistencyType.verify(checkItem.getPkgFile(), checkItem.getSignFile());
    }

    List<ConsistencyCheckItem> executeCheckItem() {
        List<ConsistencyCheckItem> checkItems = this.taskInfo.getItems();
        if (CollectionUtils.isEmpty(checkItems)) {
            log.warn("not find consistency check item.");
            return Collections.emptyList();
        }
        checkItems.stream().peek(checkItem -> checkItem.setResult(1)).forEach(this::verifyPackageConsistency);
        return checkItems;
    }

    @Override
    public void run() {
        this.executeCheckItem();
    }

    private void verifyPackageConsistency(ConsistencyCheckItem checkItem) {
        if (!checkItem.getSignFile().exists()) {
            checkItem.setResult(4);
            return;
        }
        checkItem.setResult(this.verifyConsistencyFile(checkItem) ? this.getConsistencySuccessValue(checkItem) : 3);
    }

    private int getConsistencySuccessValue(ConsistencyCheckItem checkItem) {
        return checkItem.getConsistencyType() == ConsistencyType.NONE ? 5 : 2;
    }
}

