/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.consistency;

import com.huawei.yinglong.river.sitedeployment.dcs.consistency.ConsistencyCheckItem;
import com.huawei.yinglong.river.sitedeployment.dcs.consistency.ConsistencyFilterType;
import com.huawei.yinglong.river.sitedeployment.dcs.consistency.ConsistencyPattern;
import com.huawei.yinglong.river.sitedeployment.dcs.consistency.ConsistencyType;
import com.huawei.yinglong.river.sitedeployment.dcs.consistency.fusioncube.FusionCubeConsistencyValidate;
import com.huawei.yinglong.river.sitedeployment.dcs.constant.InstallModeEnum;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.BasicException;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.ConsistencyErrorCode;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.ConsistencyException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FileContentOperateUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FileOperateUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistencyFilterFileTask
implements Callable<List<ConsistencyCheckItem>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConsistencyFilterFileTask.class);
    private final String path;
    private final ConsistencyType consistencyType;
    private final ConsistencyFilterType filterType;
    private Boolean isPackageArchEqualArm = null;
    private boolean isInterruptWhenException = true;
    private List<String> installModes;

    ConsistencyFilterFileTask(String path, ConsistencyFilterType filterType, ConsistencyType consistencyType) {
        this.path = path;
        this.filterType = filterType;
        this.consistencyType = consistencyType;
    }

    private boolean isNeedCheckVrm() {
        return this.filterType == ConsistencyFilterType.ONLY_VRM || this.filterType == ConsistencyFilterType.ALL_VRM_CNA || this.isNeedCheckByAutoMode(InstallModeEnum.VRM);
    }

    private boolean isNeedCheckCna() {
        return this.filterType == ConsistencyFilterType.ONLY_CNA || this.filterType == ConsistencyFilterType.ALL_VRM_CNA || this.isNeedCheckByAutoMode(InstallModeEnum.CNA);
    }

    private boolean isNeedCheckDmeData() {
        return this.filterType == ConsistencyFilterType.DME_DATA || this.isNeedCheckByAutoMode(InstallModeEnum.DME);
    }

    private boolean isNeedCheckUltraVR() {
        return this.filterType == ConsistencyFilterType.ULTRAVR || this.isNeedCheckByAutoMode(InstallModeEnum.ULTRAVR);
    }

    private boolean isNeedCheckEbackup() {
        return this.filterType == ConsistencyFilterType.E_BACKUP || this.isNeedCheckByAutoMode(InstallModeEnum.EBACKUP);
    }

    private boolean isNeedCheckRoCEDriver() {
        return this.filterType == ConsistencyFilterType.MLNX_ROCE_DRIVER;
    }

    private boolean isNeedCheckEDataInsight() {
        return this.filterType == ConsistencyFilterType.E_DATA_INSIGHT || this.isNeedCheckByAutoMode(InstallModeEnum.EDATAINSIGHT);
    }

    private boolean isNeedCheckHiCloud() {
        return this.filterType == ConsistencyFilterType.HI_CLOUD || this.isNeedCheckByAutoMode(InstallModeEnum.HICLOUD);
    }

    private boolean isNeedCheckSfs() {
        return this.filterType == ConsistencyFilterType.SFS || this.isNeedCheckByAutoMode(InstallModeEnum.SFS);
    }

    private boolean isNeedCheckA3000() {
        return this.filterType == ConsistencyFilterType.A3000;
    }

    private boolean isNeedCheckSdn() {
        return this.filterType == ConsistencyFilterType.SDN || this.isNeedCheckByAutoMode(InstallModeEnum.SDN);
    }

    private boolean isNeedCheckSfsIntegrate() {
        return this.filterType == ConsistencyFilterType.SFS_INTEGRATE || this.isNeedCheckByAutoMode(InstallModeEnum.SFS_INTEGRATE);
    }

    private boolean isNeedCheckHiCloudIntegrate() {
        return this.filterType == ConsistencyFilterType.HI_CLOUD_INTEGRATE || this.isNeedCheckByAutoMode(InstallModeEnum.HICLOUD_INTEGRATE);
    }

    private boolean isNeedCheckUltraVrIntegrate() {
        return this.filterType == ConsistencyFilterType.ULTRAVR_INTEGRATE || this.isNeedCheckByAutoMode(InstallModeEnum.ULTRAVR_INTEGRATE);
    }

    private boolean isNeedCheckCampusIntegrate() {
        return this.filterType == ConsistencyFilterType.CAMPUS_INTEGRATE || this.isNeedCheckByAutoMode(InstallModeEnum.CAMPUS_INTEGRATE);
    }

    private boolean isNeedCheckByAutoMode(InstallModeEnum modeEnum) {
        return this.filterType == ConsistencyFilterType.AUTO_BY_MODE && ListUtils.emptyIfNull(this.installModes).contains(modeEnum.getInstallMode());
    }

    private boolean checkPackageArchIsArm(String fileName) {
        String lowerFileName = fileName.toLowerCase(Locale.ROOT);
        return lowerFileName.contains("arm") || lowerFileName.contains("aarch64");
    }

    @Override
    public List<ConsistencyCheckItem> call() throws BasicException {
        LinkedList<ConsistencyCheckItem> checkItems = new LinkedList<ConsistencyCheckItem>();
        File pathFile = new File(this.path);
        if (this.isNeedCheckUltraVR()) {
            this.executeCheckable(checkItems, pathFile, this::checkUltraVRTemplateFile);
        }
        if (this.isNeedCheckEbackup()) {
            this.executeCheckable(checkItems, pathFile, this::checkEbackupTemplateFile);
        }
        this.checkEdme(checkItems, pathFile);
        if (this.isNeedCheckEDataInsight()) {
            this.executeCheckable(checkItems, pathFile, this::checkEDataInsightPackageFile);
        }
        if (this.isNeedCheckHiCloud()) {
            this.executeCheckable(checkItems, pathFile, this::checkHiCloudPackageFile);
        }
        if (this.isNeedCheckSfs()) {
            this.executeCheckable(checkItems, pathFile, this::checkSfsPackageFile);
        }
        if (this.isNeedCheckA3000()) {
            this.executeCheckable(checkItems, pathFile, this::checkA3000PackageFile);
        }
        if (this.isNeedCheckSdn()) {
            this.executeCheckable(checkItems, pathFile, this::checkSdnPackageFile);
        }
        this.checkIntegrateCompent(checkItems, pathFile);
        this.checkVrmOrCna(checkItems, pathFile);
        if (this.isNeedCheckRoCEDriver()) {
            this.executeCheckable(checkItems, pathFile, this::checkRoCEDriverFile);
        }
        if (this.isNeedCheckECampusCore()) {
            this.executeCheckable(checkItems, pathFile, this::checkECampusCoreFile);
        }
        if (this.isNeedCheckFusionCubeMigration()) {
            this.executeCheckable(checkItems, pathFile, this::isNeedCheckFusionCubeMigrationFile);
        }
        return checkItems;
    }

    private void checkVrmOrCna(List<ConsistencyCheckItem> checkItems, File pathFile) throws ConsistencyException {
        if (this.isNeedCheckVrm() || this.isNeedCheckCna()) {
            this.executeCheckable(checkItems, pathFile, this::checkFcInstallerFile);
            if (this.isNeedCheckVrm()) {
                this.executeCheckable(checkItems, pathFile, this::checkVrmTemplFile);
                this.executeCheckable(checkItems, pathFile, this::checkFcVmToolsFile);
            }
            if (this.isNeedCheckCna()) {
                this.executeCheckable(checkItems, pathFile, this::checkCnaIsoFile);
            }
        }
    }

    private void checkEdme(List<ConsistencyCheckItem> checkItems, File pathFile) throws ConsistencyException {
        if (this.isNeedCheckDmeData()) {
            this.executeCheckable(checkItems, pathFile, this::checkDmeSoftwarePackageFile);
            this.executeCheckable(checkItems, pathFile, this::checkDmeEulerIsoPackageFile);
            this.executeCheckable(checkItems, pathFile, this::checkDmeEDiOmEulerPackageFile);
            this.executeCheckable(checkItems, pathFile, this::checkDmeCcsPackageFile);
            this.executeCheckable(checkItems, pathFile, this::checkDmeAsPackageFile);
            this.executeCheckable(checkItems, pathFile, this::checkDmeImsPackageFile);
        }
    }

    private void isNeedCheckFusionCubeMigrationFile(List<ConsistencyCheckItem> consistencyCheckItems, File pathFile) throws ConsistencyException {
        List<String> fileNames = FileOperateUtils.getSpecialFileNames(pathFile, FusionCubeConsistencyValidate::isFusionCubeMigrationTemplate);
        if (fileNames.isEmpty()) {
            log.info("not find fusion cube migration template file in special path.");
            throw new ConsistencyException(ConsistencyErrorCode.FUSION_CUBE_MIGRATION_TEMPLATE_FILE_NOT_EXIST);
        }
        if (fileNames.size() > 1) {
            log.error("find fuion cube migration template file in special path, but it is too much.");
            throw new ConsistencyException(ConsistencyErrorCode.FUSION_CUBE_MIGRATION_TEMPLATE_FILE_EXIST_MORE);
        }
        consistencyCheckItems.add(this.buildConsistencyCheckItem(new File(pathFile, fileNames.get(0)), 1033));
    }

    private boolean isNeedCheckFusionCubeMigration() {
        return this.filterType == ConsistencyFilterType.FUSION_CUBE_MIGRATION || this.isNeedCheckByAutoMode(InstallModeEnum.FUSION_CUBE_8_2_MIGRATION);
    }

    private void checkECampusCoreFile(List<ConsistencyCheckItem> consistencyCheckItems, File file) throws ConsistencyException {
        ArrayList<String> moreFile = new ArrayList<String>();
        ArrayList<String> missFile = new ArrayList<String>();
        Map<String, String> ecampusCorePattern = ConsistencyPattern.getEcampusCorePattern();
        ecampusCorePattern.keySet().forEach(key -> this.getEcampusCoreErrorMessage((String)key, file, (List<String>)moreFile, (List<String>)missFile, ecampusCorePattern));
        if (CollectionUtils.isNotEmpty(moreFile)) {
            throw new ConsistencyException(ConsistencyErrorCode.E_CAMPUS_CORE_PACKAGE_EXIST_MORE, this.getErrorMessage(moreFile));
        }
        if (CollectionUtils.isNotEmpty(missFile)) {
            throw new ConsistencyException(ConsistencyErrorCode.E_CAMPUS_CORE_PACKAGE_NOT_EXIST, this.getErrorMessage(missFile));
        }
        ecampusCorePattern.keySet().forEach(key -> this.checkeCampusCoreSign((String)key, file, consistencyCheckItems));
    }

    private void checkeCampusCoreSign(String key, File file, List<ConsistencyCheckItem> consistencyCheckItems) {
        if (ConsistencyPattern.CAMPUS_CERT_FILE.contains(ConsistencyPattern.getEcampusCorePattern().get(key))) {
            return;
        }
        consistencyCheckItems.add(this.buildConsistencyCheckItem(new File(file, this.getMatchFiles(key, file).get(0)), 1030));
    }

    private String getErrorMessage(List<String> messages) {
        StringBuilder stringBuilder = new StringBuilder();
        messages.stream().forEach(message -> {
            stringBuilder.append((String)message);
            stringBuilder.append(",");
        });
        return stringBuilder.toString();
    }

    private void getEcampusCoreErrorMessage(String key, File files, List<String> moreFile, List<String> missFile, Map<String, String> ecampusCorePattern) {
        List<String> matcherFiles = this.getMatchFiles(key, files);
        if (CollectionUtils.isEmpty(matcherFiles)) {
            missFile.add(ecampusCorePattern.get(key));
        }
        if (CollectionUtils.isNotEmpty(matcherFiles) && matcherFiles.size() > 1) {
            moreFile.add(ecampusCorePattern.get(key));
        }
    }

    private List<String> getMatchFiles(String key, File files) {
        return Arrays.stream((Object[])Optional.ofNullable(files.listFiles()).orElse(new File[0])).map(File::getName).filter(fileName -> this.checkEcampusCoreFilePattern(key, (String)fileName)).collect(Collectors.toList());
    }

    private boolean checkEcampusCoreFilePattern(String key, String fileName) {
        return Pattern.compile(key).matcher(fileName).find();
    }

    private boolean isNeedCheckECampusCore() {
        return this.filterType == ConsistencyFilterType.CAMPUS || this.isNeedCheckByAutoMode(InstallModeEnum.E_CAMPUSCORE);
    }

    private void checkDmeAsPackageFile(List<ConsistencyCheckItem> checkItems, File pathFile) throws ConsistencyException {
        List<String> fileNames = FileOperateUtils.getSpecialFileNames(pathFile, ConsistencyPattern::isMatchDmeAsSoftwarePackage);
        if (fileNames.isEmpty()) {
            log.info("not find as file in special path.");
            return;
        }
        if (fileNames.size() > 1) {
            log.error("find as file in special path, but it is too much.");
            throw new ConsistencyException(ConsistencyErrorCode.DME_AS_PACKAGE_EXIST_MORE);
        }
        String fileName = fileNames.get(0);
        if (!ConsistencyPattern.hasDmeDatSoftwareCmsFile(pathFile, fileName)) {
            log.error("validate dme as software cms sign is not exist.");
            throw new ConsistencyException(ConsistencyErrorCode.DME_AS_PACKAGE_CMS_NOT_EXIST);
        }
        if (!ConsistencyPattern.hasDmeDatSoftwareCrlFile(pathFile, fileName)) {
            log.error("validate dme as software crl sign is not exist.");
            throw new ConsistencyException(ConsistencyErrorCode.DME_AS_PACKAGE_CRL_NOT_EXIST);
        }
        checkItems.add(this.buildConsistencyCheckItem(new File(pathFile, fileName), 21));
    }

    private void checkDmeImsPackageFile(List<ConsistencyCheckItem> checkItems, File pathFile) throws ConsistencyException {
        List<String> fileNames = FileOperateUtils.getSpecialFileNames(pathFile, ConsistencyPattern::isMatchDmeImsSoftwarePackage);
        if (fileNames.isEmpty()) {
            log.info("not find as file in special path.");
            return;
        }
        if (fileNames.size() > 1) {
            log.error("find ims file in special path, but it is too much.");
            throw new ConsistencyException(ConsistencyErrorCode.DME_IMS_PACKAGE_EXIST_MORE);
        }
        String fileName = fileNames.get(0);
        if (!ConsistencyPattern.hasDmeDatSoftwareCmsFile(pathFile, fileName)) {
            log.error("validate dme ims software cms sign is not exist.");
            throw new ConsistencyException(ConsistencyErrorCode.DME_IMS_CMS_PACKAGE_NOT_EXIST);
        }
        if (!ConsistencyPattern.hasDmeDatSoftwareCrlFile(pathFile, fileName)) {
            log.error("validate dme ims software crl sign is not exist.");
            throw new ConsistencyException(ConsistencyErrorCode.DME_IMS_CRL_PACKAGE_NOT_EXIST);
        }
        checkItems.add(this.buildConsistencyCheckItem(new File(pathFile, fileName), 21));
    }

    private void checkIntegrateCompent(List<ConsistencyCheckItem> checkItems, File pathFile) throws ConsistencyException {
        if (this.isNeedCheckSfsIntegrate()) {
            this.executeCheckable(checkItems, pathFile, this::checkSfsIntegratePackageFile);
        }
        if (this.isNeedCheckHiCloudIntegrate()) {
            this.executeCheckable(checkItems, pathFile, this::checkHiCloudIntegratePackageFile);
        }
        if (this.isNeedCheckUltraVrIntegrate()) {
            this.executeCheckable(checkItems, pathFile, this::checkUltraVrIntegratePackageFile);
        }
        if (this.isNeedCheckCampusIntegrate()) {
            this.executeCheckable(checkItems, pathFile, this::checkCampusIntegratePackageFile);
        }
    }

    private void checkDmeCcsPackageFile(List<ConsistencyCheckItem> checkItems, File pathFile) throws ConsistencyException {
        List<String> fileNames = FileOperateUtils.getSpecialFileNames(pathFile, ConsistencyPattern::isMatchDmeCssSoftwarePackage);
        if (fileNames.isEmpty()) {
            log.info("not find ccs file in special path.");
            return;
        }
        if (fileNames.size() > 1) {
            log.error("find ccs file in special path, but it is too much.");
            throw new ConsistencyException(ConsistencyErrorCode.DME_CCS_PACKAGE_EXIST_MORE);
        }
        String fileName = fileNames.get(0);
        if (!ConsistencyPattern.hasDmeDatSoftwareCmsFile(pathFile, fileName)) {
            log.error("validate dme ccs software cms sign is not exist.");
            throw new ConsistencyException(ConsistencyErrorCode.DME_CCS_PACKAGE_CMS_NOT_EXIST);
        }
        if (!ConsistencyPattern.hasDmeDatSoftwareCrlFile(pathFile, fileName)) {
            log.error("validate dme ccs software crl sign is not exist.");
            throw new ConsistencyException(ConsistencyErrorCode.DME_CCS_PACKAGE_CRL_NOT_EXIST);
        }
        checkItems.add(this.buildConsistencyCheckItem(new File(pathFile, fileName), 20));
    }

    private void executeCheckable(List<ConsistencyCheckItem> checkItems, File pathFile, Checkable checkable) throws ConsistencyException {
        try {
            checkable.check(checkItems, pathFile);
        }
        catch (ConsistencyException exception) {
            if (this.isInterruptWhenException) {
                throw exception;
            }
            log.error("It is not interrupt when exception.", (Throwable)exception);
        }
    }

    private void checkRoCEDriverFile(List<ConsistencyCheckItem> checkItems, File pathFile) throws ConsistencyException {
        this.checkFcInstallerFile(new ArrayList<ConsistencyCheckItem>(), pathFile);
        int oldCheckItemSize = checkItems.size();
        this.findRoCEDriverFile(pathFile, ConsistencyPattern::isMatchEulerMlnxRoCEDriver, 8).ifPresent(checkItem -> checkItems.add(checkItem.updateConsistencyType(ConsistencyType.SHA256)));
        this.findRoCEDriverFile(pathFile, ConsistencyPattern::isMatchHifc1822RoCEDriver, 9).ifPresent(checkItems::add);
        this.findRoCEDriverFile(pathFile, ConsistencyPattern::isMatchTxgbeRoCEDriver, 10).ifPresent(checkItems::add);
        if (checkItems.size() == oldCheckItemSize) {
            log.error("find RoCE Driver file in special path, but it is empty.");
            throw new ConsistencyException(ConsistencyErrorCode.MLNX_ROCE_DRIVER_FILE_NOT_EXIST);
        }
    }

    private Optional<ConsistencyCheckItem> findRoCEDriverFile(File pathFile, Predicate<String> predicate, int fileType) throws ConsistencyException {
        List<String> fileNames = FileOperateUtils.getSpecialFileNames(pathFile, predicate);
        if (fileNames.size() > 1) {
            log.error("find RoCE Driver file in special path, but it is too much.");
            throw new ConsistencyException(ConsistencyErrorCode.ROCE_DRIVER_FILE_EXIST_MORE);
        }
        if (fileNames.size() == 1 && fileType == 8) {
            boolean isArchArm = this.checkPackageArchIsArm(fileNames.get(0));
            if (this.isPackageArchEqualArm != null && this.isPackageArchEqualArm ^ isArchArm) {
                log.error("validate package RoCE driver [{}] arch is not same.", (Object)fileType);
                throw new ConsistencyException(ConsistencyErrorCode.SOFTWARE_ARCH_NOT_MATCH);
            }
        }
        return fileNames.stream().findFirst().map(fileName -> this.buildConsistencyCheckItem(new File(pathFile, (String)fileName), fileType));
    }

    private void checkUltraVRTemplateFile(List<ConsistencyCheckItem> checkItems, File pathFile) throws ConsistencyException {
        Optional<String> opFileName = this.checkFileInPath(pathFile, ConsistencyPattern::isMatchUltraVRTemplateFile, ConsistencyErrorCode.ULTRAVR_TEMPLATE_FILE_NOT_EXIST, ConsistencyErrorCode.ULTRAVR_TEMPLATE_FILE_EXIST_MORE);
        File templateFile = pathFile;
        if (opFileName.isPresent()) {
            templateFile = new File(pathFile, opFileName.get());
        }
        if (!templateFile.exists() || !ConsistencyPattern.isMatchUltraVRTemplateFile(templateFile.getName())) {
            log.error("validate ultraVR template file is empty. exist : {}.", (Object)templateFile.exists());
            throw new ConsistencyException(ConsistencyErrorCode.ULTRAVR_TEMPLATE_FILE_NOT_EXIST);
        }
        checkItems.add(this.buildConsistencyCheckItem(templateFile, 6));
    }

    private void checkEbackupTemplateFile(List<ConsistencyCheckItem> checkItems, File pathFile) throws ConsistencyException {
        Optional<String> opFileName = this.checkFileInPath(pathFile, ConsistencyPattern::isMatchEbackupTemplateFile, ConsistencyErrorCode.EBACKUP_TEMPLATE_FILE_NOT_EXIST, ConsistencyErrorCode.EBACKUP_TEMPLATE_FILE_EXIST_MORE);
        File templateFile = pathFile;
        if (opFileName.isPresent()) {
            templateFile = new File(pathFile, opFileName.get());
        }
        if (!templateFile.exists() || !ConsistencyPattern.isMatchEbackupTemplateFile(templateFile.getName())) {
            log.error("validate eBackup template file is empty. exist : {}.", (Object)templateFile.exists());
            throw new ConsistencyException(ConsistencyErrorCode.EBACKUP_TEMPLATE_FILE_NOT_EXIST);
        }
        checkItems.add(this.buildConsistencyCheckItem(templateFile, 7));
    }

    private Optional<String> checkFileInPath(File pathFile, Predicate<String> predicate, ConsistencyErrorCode emptyErrorCode, ConsistencyErrorCode moreErrorCode) throws ConsistencyException {
        if (pathFile.exists() && pathFile.isFile()) {
            return Optional.empty();
        }
        List<String> fileNames = FileOperateUtils.getSpecialFileNames(pathFile, predicate);
        if (fileNames.isEmpty()) {
            if (emptyErrorCode == null) {
                log.warn("find {} file in special path, but it is empty.", (Object)moreErrorCode.name());
                return Optional.empty();
            }
            log.error("find {} file in special path, but it is empty.", (Object)emptyErrorCode.name());
            throw new ConsistencyException(emptyErrorCode);
        }
        if (fileNames.size() > 1) {
            log.error("find {} file in special path, but it is too much.", (Object)moreErrorCode.name());
            throw new ConsistencyException(moreErrorCode);
        }
        if (this.isPackageArchEqualArm != null && this.isPackageArchEqualArm ^ this.checkPackageArchIsArm(fileNames.get(0))) {
            log.error("{} arch is not same.", fileNames);
            throw new ConsistencyException(ConsistencyErrorCode.SOFTWARE_ARCH_NOT_MATCH);
        }
        return Optional.of(fileNames.get(0));
    }

    private ConsistencyCheckItem buildConsistencyCheckItem(File templateFile, int type) {
        File signFile = new File(templateFile.getParentFile(), this.consistencyType.getConsistencyFileName(templateFile.getName()));
        return ConsistencyCheckItem.builder().result(0).type(type).pkgFile(templateFile).signFile(signFile).build();
    }

    private void checkDmeEulerIsoPackageFile(List<ConsistencyCheckItem> checkItems, File pathFile) throws ConsistencyException {
        Optional<String> opFileName = this.checkFileInPath(pathFile, ConsistencyPattern::isMatchDmeDataEulerIsoPackage, ConsistencyErrorCode.DME_EULER_ISO_NOT_EXIST, ConsistencyErrorCode.DME_EULER_ISO_EXIST_MORE);
        if (opFileName.isPresent()) {
            String softwareFileName = opFileName.get();
            if (!ConsistencyPattern.hasDmeDatSoftwareCmsFile(pathFile, softwareFileName)) {
                log.error("validate dme iso software cms sign is not exist.");
                throw new ConsistencyException(ConsistencyErrorCode.DME_EULER_ISO_CMS_NOT_EXIST);
            }
            if (!ConsistencyPattern.hasDmeDatSoftwareCrlFile(pathFile, softwareFileName)) {
                log.error("validate dme iso software crl sign is not exist.");
                throw new ConsistencyException(ConsistencyErrorCode.DME_EULER_ISO_CRL_NOT_EXIST);
            }
        }
        opFileName.ifPresent(fileName -> checkItems.add(this.buildConsistencyCheckItem(new File(pathFile, (String)fileName), 5)));
    }

    private void checkEDataInsightPackageFile(List<ConsistencyCheckItem> checkItems, File pathFile) throws ConsistencyException {
        Optional<String> opFileName = this.checkFileInPath(pathFile, ConsistencyPattern::isMatchEDataInsightImageFile, ConsistencyErrorCode.EDATAINSIGHT_IMAGE_FILE_NOT_EXIST, ConsistencyErrorCode.EDATAINSIGHT_IMAGE_FILE_EXIST_MORE);
        opFileName.ifPresent(fileName -> checkItems.add(this.buildConsistencyCheckItem(new File(pathFile, (String)fileName), 13)));
        opFileName = this.checkFileInPath(pathFile, ConsistencyPattern::isMatchEDataInsightSoftwareFile, ConsistencyErrorCode.EDATAINSIGHT_SOFTWARE_FILE_NOT_EXIST, ConsistencyErrorCode.EDATAINSIGHT_SOFTWARE_FILE_EXIST_MORE);
        opFileName.ifPresent(fileName -> checkItems.add(this.buildConsistencyCheckItem(new File(pathFile, (String)fileName), 14)));
    }

    private void checkA3000PackageFile(List<ConsistencyCheckItem> checkItems, File pathFile) throws ConsistencyException {
        this.checkA3000CommonPackageFile(checkItems, pathFile);
        this.checkA3000OsInstallPackageFile(checkItems, pathFile);
        this.checkA3000SoftwareDeployPackageFile(checkItems, pathFile);
        this.checkA3000DriverPluginPackageFile(checkItems, pathFile);
    }

    private boolean checkHasInstallMode(InstallModeEnum modeEnum) {
        return CollectionUtils.isEmpty(this.installModes) || this.installModes.contains(modeEnum.getInstallMode());
    }

    private void checkA3000CommonPackageFile(List<ConsistencyCheckItem> checkItems, File pathFile) throws ConsistencyException {
        this.checkFileInPath(pathFile, ConsistencyPattern::isA3000EContainerInstallerPackage, ConsistencyErrorCode.A3000_ECONTAINER_INSTALLER_FILE_NOT_EXIST, ConsistencyErrorCode.A3000_ECONTAINER_INSTALLER_FILE_EXIST_MORE).ifPresent(fileName -> {
            this.isPackageArchEqualArm = this.checkPackageArchIsArm((String)fileName);
            checkItems.add(this.buildConsistencyCheckItem(new File(pathFile, (String)fileName), 769));
        });
    }

    private void checkA3000OsInstallPackageFile(List<ConsistencyCheckItem> checkItems, File pathFile) throws ConsistencyException {
        if (!this.checkHasInstallMode(InstallModeEnum.A3000_OS)) {
            return;
        }
        this.checkFileInPath(pathFile, ConsistencyPattern::isA3000EulerOsPackage, ConsistencyErrorCode.A3000_EULEROS_ISO_FILE_NOT_EXIST, ConsistencyErrorCode.A3000_EULEROS_ISO_FILE_EXIST_MORE).ifPresent(fileName -> checkItems.add(this.buildConsistencyCheckItem(new File(pathFile, (String)fileName), 768)));
    }

    private void checkA3000SoftwareDeployPackageFile(List<ConsistencyCheckItem> checkItems, File pathFile) throws ConsistencyException {
        if (!this.checkHasInstallMode(InstallModeEnum.A3000_SOFTWARE)) {
            return;
        }
        this.checkFileInPath(pathFile, ConsistencyPattern::isA3000FusionCubeMetaVisionPackage, ConsistencyErrorCode.A3000_FUSIONCUBE_METAVISION_FILE_NOT_EXIST, ConsistencyErrorCode.A3000_FUSIONCUBE_METAVISION_FILE_EXIST_MORE).ifPresent(fileName -> checkItems.add(this.buildConsistencyCheckItem(new File(pathFile, (String)fileName), 770)));
        this.checkFileInPath(pathFile, ConsistencyPattern::isA3000EContainerSoftwarePackage, ConsistencyErrorCode.A3000_ECONTAINER_SOFTWARE_FILE_NOT_EXIST, ConsistencyErrorCode.A3000_ECONTAINER_SOFTWARE_FILE_EXIST_MORE).ifPresent(fileName -> checkItems.add(this.buildConsistencyCheckItem(new File(pathFile, (String)fileName), 778)));
        this.checkFileInPath(pathFile, ConsistencyPattern::isA3000FusionComputeK8SPackage, ConsistencyErrorCode.A3000_FUSIONCOMPUTE_K8S_FILE_NOT_EXIST, ConsistencyErrorCode.A3000_FUSIONCOMPUTE_K8S_FILE_EXIST_MORE).ifPresent(fileName -> checkItems.add(this.buildConsistencyCheckItem(new File(pathFile, (String)fileName), 771)));
        this.checkFileInPath(pathFile, ConsistencyPattern::isA3000EsdkCsiPackage, ConsistencyErrorCode.A3000_ESDK_CSI_FILE_NOT_EXIST, ConsistencyErrorCode.A3000_ESDK_CSI_FILE_EXIST_MORE).ifPresent(fileName -> checkItems.add(this.buildConsistencyCheckItem(new File(pathFile, (String)fileName), 772).updateConsistencyType(ConsistencyType.NONE)));
    }

    private void checkA3000DriverPluginPackageFile(List<ConsistencyCheckItem> checkItems, File pathFile) throws ConsistencyException {
        if (!this.checkHasInstallMode(InstallModeEnum.A3000_DRIVER_PLUGIN)) {
            return;
        }
        this.checkFileInPath(pathFile, ConsistencyPattern::isA3000NpuExporterPackage, null, ConsistencyErrorCode.A3000_NPU_EXPORTER_FILE_EXIST_MORE).ifPresent(fileName -> checkItems.add(this.buildConsistencyCheckItem(new File(pathFile, (String)fileName), 774).updateConsistencyType(ConsistencyType.NONE)));
        this.checkFileInPath(pathFile, ConsistencyPattern::isA3000NpuDriverPackage, null, ConsistencyErrorCode.A3000_NPU_DRIVER_FILE_EXIST_MORE).ifPresent(fileName -> checkItems.add(this.buildConsistencyCheckItem(new File(pathFile, (String)fileName), 773)));
        this.checkFileInPath(pathFile, ConsistencyPattern::isA3000DevicePluginPackage, null, ConsistencyErrorCode.A3000_DEVICE_PLUGIN_FILE_EXIST_MORE).ifPresent(fileName -> checkItems.add(this.buildConsistencyCheckItem(new File(pathFile, (String)fileName), 775).updateConsistencyType(ConsistencyType.NONE)));
        this.checkFileInPath(pathFile, ConsistencyPattern::isA3000DockerRuntimePackage, ConsistencyErrorCode.A3000_DOCKER_RUNTIME_FILE_NOT_EXIST, ConsistencyErrorCode.A3000_DOCKER_RUNTIME_FILE_EXIST_MORE).ifPresent(fileName -> checkItems.add(this.buildConsistencyCheckItem(new File(pathFile, (String)fileName), 776).updateConsistencyType(ConsistencyType.SHA256)));
        this.checkFileInPath(pathFile, ConsistencyPattern::isA3000IBMAZipPackage, ConsistencyErrorCode.A3000_IBMA_FILE_NOT_EXIST, ConsistencyErrorCode.A3000_IBMA_FILE_EXIST_MORE).ifPresent(fileName -> checkItems.add(this.buildConsistencyCheckItem(new File(pathFile, (String)fileName), 777)));
    }

    private void checkHiCloudPackageFile(List<ConsistencyCheckItem> checkItems, File pathFile) throws ConsistencyException {
        String fileName2;
        Optional<String> opFileName = this.checkFileInPath(pathFile, ConsistencyPattern::isHiCloudGKitImageFilePackage, ConsistencyErrorCode.HICLOUD_GKIT_IMAGE_FILE_NOT_EXIST, ConsistencyErrorCode.HICLOUD_GKIT_IMAGE_FILE_EXIST_MORE);
        boolean isPkgArchArm = false;
        if (opFileName.isPresent()) {
            fileName2 = opFileName.get();
            isPkgArchArm = this.checkPackageArchIsArm(fileName2);
            checkItems.add(this.buildConsistencyCheckItem(new File(pathFile, fileName2), 15));
        }
        opFileName = this.checkFileInPath(pathFile, ConsistencyPattern::isHiCloudVmImageFilePackage, ConsistencyErrorCode.HICLOUD_VM_IMAGE_FILE_NOT_EXIST, ConsistencyErrorCode.HICLOUD_VM_IMAGE_FILE_EXIST_MORE);
        opFileName.ifPresent(fileName -> checkItems.add(this.buildConsistencyCheckItem(new File(pathFile, (String)fileName), 16)));
        opFileName = this.checkFileInPath(pathFile, ConsistencyPattern::isHiCloudQemuPackage, ConsistencyErrorCode.HICLOUD_QEMU_FILE_NOT_EXIST, ConsistencyErrorCode.HICLOUD_QEMU_FILE_EXIST_MORE);
        opFileName.ifPresent(fileName -> checkItems.add(this.buildConsistencyCheckItem(new File(pathFile, (String)fileName), 17)));
        opFileName = this.checkFileInPath(pathFile, ConsistencyPattern::isHiCloudConversionScriptPackage, ConsistencyErrorCode.HICLOUD_CONVERSION_SCRIPT_FILE_NOT_EXIST, ConsistencyErrorCode.HICLOUD_CONVERSION_SCRIPT_FILE_EXIST_MORE);
        opFileName.ifPresent(fileName -> checkItems.add(this.buildConsistencyCheckItem(new File(pathFile, (String)fileName), 18)));
        opFileName = this.checkFileInPath(pathFile, ConsistencyPattern::isHiCloudAutoInstallScriptPackage, ConsistencyErrorCode.HICLOUD_AUTO_INSTALL_SCRIPT_FILE_NOT_EXIST, ConsistencyErrorCode.HICLOUD_AUTO_INSTALL_SCRIPT_FILE_EXIST_MORE);
        if (opFileName.isPresent()) {
            fileName2 = opFileName.get();
            checkItems.add(this.buildConsistencyCheckItem(new File(pathFile, fileName2), 19));
            this.parseDependencyPackageList(checkItems, pathFile, fileName2, isPkgArchArm);
        }
    }

    private boolean isHiCloudSceneFile(String dependencyFileName, File zipFile) {
        return this.findHiCloudSceneFileList(zipFile).contains(dependencyFileName);
    }

    private void parseDependencyPackageList(List<ConsistencyCheckItem> checkItems, File pathFile, String fileName, boolean isPkgArchArm) throws ConsistencyException {
        File zipFile = new File(pathFile, fileName);
        LinkedList<String> dependencyFileNames = new LinkedList<String>(this.findHiCloudSceneFileList(zipFile));
        log.info("parse hicloud scene file size : {}.", (Object)dependencyFileNames.size());
        dependencyFileNames.addAll(this.findHiCloudDependencyFileList(zipFile, isPkgArchArm));
        log.info("parse hicloud dependency files : {}.", dependencyFileNames);
        List<String> fileNames = FileOperateUtils.getSpecialFileNames(pathFile, file -> true);
        List notFoundFiles = dependencyFileNames.stream().filter(file -> !fileNames.contains(file)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(notFoundFiles)) {
            log.warn("not find file list : {}.", notFoundFiles);
            throw new ConsistencyException(ConsistencyErrorCode.HICLOUD_DEPENDENCY_PACKAGE_NOT_EXIST, String.join((CharSequence)",", notFoundFiles));
        }
        AtomicInteger pkgIdx = new AtomicInteger(0);
        checkItems.addAll(dependencyFileNames.stream().map(dependencyFileName -> this.getHiCloudDependencyPackageCheckItem(pathFile, zipFile, pkgIdx, (String)dependencyFileName)).collect(Collectors.toList()));
    }

    private ConsistencyCheckItem getHiCloudDependencyPackageCheckItem(File pathFile, File zipFile, AtomicInteger pkgIdx, String dependencyFileName) {
        ConsistencyCheckItem checkItem = this.buildConsistencyCheckItem(new File(pathFile, dependencyFileName), 256 + pkgIdx.getAndIncrement());
        if (this.isHiCloudSceneFile(dependencyFileName, zipFile)) {
            checkItem.updateConsistencyType(ConsistencyType.NONE);
        }
        return checkItem;
    }

    private List<String> findHiCloudDependencyFileList(File zipFile, boolean isArchArm) {
        return FileContentOperateUtils.readFileContentInZipFile(FilePathValidatorUtils.getSafePath(zipFile).orElse(""), isArchArm ? "package_arm.list" : "package_x86.list").map(text -> Arrays.stream(text.split("\n")).map(String::trim).filter(StringUtils::isNotEmpty).filter(line -> !line.startsWith("#")).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    private List<String> findHiCloudSceneFileList(File zipFile) {
        return FileContentOperateUtils.readFileContentInZipFile(FilePathValidatorUtils.getSafePath(zipFile).orElse(""), "common.conf").map(text -> Arrays.stream(text.split("\n")).map(String::trim).filter(StringUtils::isNotEmpty).filter(line -> line.startsWith("SCENARIO_PACKAGE_NAME=")).map(line -> line.replace("SCENARIO_PACKAGE_NAME=", "")).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    private void checkSfsPackageFile(List<ConsistencyCheckItem> checkItems, File pathFile) throws ConsistencyException {
        Optional<String> sfsVhdFileName = this.checkFileInPath(pathFile, ConsistencyPattern::isSfsVhdFilePackage, ConsistencyErrorCode.SFS_TEMPLATE_PACKAGE_NOT_EXIST, ConsistencyErrorCode.SFS_TEMPLATE_PACKAGE_EXIST_MORE);
        sfsVhdFileName.ifPresent(fileName -> checkItems.add(this.buildConsistencyCheckItem(new File(pathFile, (String)fileName), 779)));
    }

    private void checkSdnPackageFile(List<ConsistencyCheckItem> checkItems, File pathFile) throws ConsistencyException {
        Optional<String> sdnVhdFileName = this.checkFileInPath(pathFile, ConsistencyPattern::isSdnVhdFilePackage, ConsistencyErrorCode.SDN_TEMPLATE_PACKAGE_NOT_EXIST, ConsistencyErrorCode.SDN_TEMPLATE_PACKAGE_EXIST_MORE);
        sdnVhdFileName.ifPresent(fileName -> checkItems.add(this.buildConsistencyCheckItem(new File(pathFile, (String)fileName), 780)));
    }

    private void checkSfsIntegratePackageFile(List<ConsistencyCheckItem> checkItems, File pathFile) throws ConsistencyException {
        this.checkFileInPath(pathFile, ConsistencyPattern::isSfsIntegrateFilePackage, ConsistencyErrorCode.SFS_INTEGRATE_ADAPT_PACKAGE_NOT_EXIST, ConsistencyErrorCode.SFS_INTEGRATE_ADAPT_PACKAGE_EXIST_MORE).ifPresent(fileName -> checkItems.add(this.buildConsistencyCheckItem(new File(pathFile, (String)fileName), 1024)));
        this.checkFileInPath(pathFile, ConsistencyPattern::isSfsIntegrateCmsFilePackage, ConsistencyErrorCode.SFS_INTEGRATE_ADAPT_PACKAGE_CMS_NOT_EXIST, ConsistencyErrorCode.SFS_INTEGRATE_ADAPT_PACKAGE_CMS_EXIST_MORE);
        this.checkFileInPath(pathFile, ConsistencyPattern::isSfsIntegrateCrlFilePackage, ConsistencyErrorCode.SFS_INTEGRATE_ADAPT_PACKAGE_CRL_NOT_EXIST, ConsistencyErrorCode.SFS_INTEGRATE_ADAPT_PACKAGE_CRL_EXIST_MORE);
    }

    private void checkHiCloudIntegratePackageFile(List<ConsistencyCheckItem> checkItems, File pathFile) throws ConsistencyException {
        this.checkFileInPath(pathFile, ConsistencyPattern::isHiCloudBmsIntegrateFilePackage, null, ConsistencyErrorCode.HICLOUD_INTEGRATE_BMSS_PACKAGE_EXIST_MORE).ifPresent(fileName -> checkItems.add(this.buildConsistencyCheckItem(new File(pathFile, (String)fileName), 1025)));
        this.checkFileInPath(pathFile, ConsistencyPattern::isHiCloudDBaasIntegrateFilePackage, null, ConsistencyErrorCode.HICLOUD_INTEGRATE_DBAAS_PACKAGE_EXIST_MORE).ifPresent(fileName -> checkItems.add(this.buildConsistencyCheckItem(new File(pathFile, (String)fileName), 1026)));
        this.checkFileInPath(pathFile, ConsistencyPattern::isHiCloudVmWareIntegrateFilePackage, null, ConsistencyErrorCode.HICLOUD_INTEGRATE_VMWARE_PACKAGE_EXIST_MORE).ifPresent(fileName -> checkItems.add(this.buildConsistencyCheckItem(new File(pathFile, (String)fileName), 1027)));
        this.checkFileInPath(pathFile, ConsistencyPattern::isHiCloudSecurityIntegrateFilePackage, null, ConsistencyErrorCode.HICLOUD_INTEGRATE_SECURITY_PACKAGE_EXIST_MORE).ifPresent(fileName -> checkItems.add(this.buildConsistencyCheckItem(new File(pathFile, (String)fileName), 1028)));
    }

    private void checkUltraVrIntegratePackageFile(List<ConsistencyCheckItem> checkItems, File pathFile) throws ConsistencyException {
        this.checkFileInPath(pathFile, ConsistencyPattern::isUltraVrIntegrateFilePackage, ConsistencyErrorCode.ULTRAVR_INTEGRATE_ADAPT_PACKAGE_NOT_EXIST, ConsistencyErrorCode.ULTRAVR_INTEGRATE_ADAPT_PACKAGE_EXIST_MORE).ifPresent(fileName -> checkItems.add(this.buildConsistencyCheckItem(new File(pathFile, (String)fileName), 1029)));
    }

    private void checkCampusIntegratePackageFile(List<ConsistencyCheckItem> checkItems, File pathFile) throws ConsistencyException {
        this.checkFileInPath(pathFile, ConsistencyPattern::isCampusIntegrateLinkFilePackage, null, ConsistencyErrorCode.CAMPUS_INTEGRATE_LINK_ADAPT_PACKAGE_EXIST_MORE).ifPresent(fileName -> checkItems.add(this.buildConsistencyCheckItem(new File(pathFile, (String)fileName), 1031)));
        this.checkFileInPath(pathFile, ConsistencyPattern::isCampusIntegrateApiFilePackage, null, ConsistencyErrorCode.CAMPUS_INTEGRATE_API_ADAPT_PACKAGE_EXIST_MORE).ifPresent(fileName -> checkItems.add(this.buildConsistencyCheckItem(new File(pathFile, (String)fileName), 1032)));
    }

    private void checkDmeEDiOmEulerPackageFile(List<ConsistencyCheckItem> checkItems, File pathFile) throws ConsistencyException {
        List<String> fileNames = FileOperateUtils.getSpecialFileNames(pathFile, ConsistencyPattern::isMatchDmeEDiOmSoftwarePackage);
        if (fileNames.isEmpty()) {
            log.info("not find eDI-OM file in special path.");
            return;
        }
        if (fileNames.size() > 1) {
            log.error("find eDI-OM file in special path, but it is too much.");
            throw new ConsistencyException(ConsistencyErrorCode.DME_EDI_OM_SOFTWARE_EXIST_MORE);
        }
        String fileName = fileNames.get(0);
        if (!ConsistencyPattern.hasDmeDatSoftwareCmsFile(pathFile, fileName)) {
            log.error("validate dme edi-om software cms sign is cms not exist.");
            throw new ConsistencyException(ConsistencyErrorCode.DME_EDI_OM_SOFTWARE_SIGN_CMS_NOT_EXIST);
        }
        if (!ConsistencyPattern.hasDmeDatSoftwareCrlFile(pathFile, fileName)) {
            log.error("validate dme edi-om software crl sign crl is not exist.");
            throw new ConsistencyException(ConsistencyErrorCode.DME_EDI_OM_SOFTWARE_SIGN_CRL_NOT_EXIST);
        }
        checkItems.add(this.buildConsistencyCheckItem(new File(pathFile, fileName), 12));
    }

    private void checkDmeSoftwarePackageFile(List<ConsistencyCheckItem> checkItems, File pathFile) throws ConsistencyException {
        Optional<String> opFileName = this.checkFileInPath(pathFile, ConsistencyPattern::isMatchDmeDataSoftwarePackage, ConsistencyErrorCode.DME_SOFTWARE_NOT_EXIST, ConsistencyErrorCode.DME_SOFTWARE_EXIST_MORE);
        if (opFileName.isPresent()) {
            String softwareFileName = opFileName.get();
            if (!ConsistencyPattern.hasDmeDatSoftwareCmsFile(pathFile, softwareFileName)) {
                log.error("validate dme data software cms sign is not exist.");
                throw new ConsistencyException(ConsistencyErrorCode.DME_SOFTWARE_CMS_SIGN_NOT_EXIST);
            }
            if (!ConsistencyPattern.hasDmeDatSoftwareCrlFile(pathFile, softwareFileName)) {
                log.error("validate dme data software crl sign is not exist.");
                throw new ConsistencyException(ConsistencyErrorCode.DME_SOFTWARE_CRL_SIGN_NOT_EXIST);
            }
            checkItems.add(this.buildConsistencyCheckItem(new File(pathFile, softwareFileName), 4));
        }
    }

    private void checkFcInstallerFile(List<ConsistencyCheckItem> checkItems, File pathFile) throws ConsistencyException {
        Optional<String> opFileName = this.checkFileInPath(pathFile, ConsistencyPattern::isMatchFusionComputeInstallerPackage, ConsistencyErrorCode.FC_INSTALLER_NOT_EXIST, ConsistencyErrorCode.FC_INSTALLER_EXIST_MORE);
        if (opFileName.isPresent()) {
            String fcInstallerFileName = opFileName.get();
            this.isPackageArchEqualArm = this.checkPackageArchIsArm(fcInstallerFileName);
            checkItems.add(this.buildConsistencyCheckItem(new File(pathFile, fcInstallerFileName), 1));
        }
    }

    private void checkFcVmToolsFile(List<ConsistencyCheckItem> checkItems, File pathFile) throws ConsistencyException {
        if (this.isPackageArchEqualArm != null && this.isPackageArchEqualArm.booleanValue()) {
            log.info("current arch is arm, ignore to check vm tools.");
            return;
        }
        Optional<String> opFileName = this.checkFileInPath(pathFile, ConsistencyPattern::isMatchFusionComputeVmToolsPackage, ConsistencyErrorCode.FC_X86_VMTOOLS_NOT_EXIST, ConsistencyErrorCode.FC_X86_VMTOOLS_EXIST_MORE);
        opFileName.ifPresent(fileName -> checkItems.add(this.buildConsistencyCheckItem(new File(pathFile, (String)fileName), 11)));
    }

    private void checkCnaIsoFile(List<ConsistencyCheckItem> checkItems, File pathFile) throws ConsistencyException {
        this.checkFileInPath(pathFile, ConsistencyPattern::isMatchCnaIsoPackage, ConsistencyErrorCode.CNA_ISO_NOT_EXIST, ConsistencyErrorCode.CNA_ISO_EXIST_MORE).ifPresent(isoFileName -> checkItems.add(this.buildConsistencyCheckItem(new File(pathFile, (String)isoFileName), 3)));
    }

    private void checkVrmTemplFile(List<ConsistencyCheckItem> checkItems, File pathFile) throws ConsistencyException {
        this.checkFileInPath(pathFile, ConsistencyPattern::isMatchVrmTemplatePackage, ConsistencyErrorCode.VRM_TEMPLATE_NOT_EXIST, ConsistencyErrorCode.VRM_TEMPLATE_EXIST_MORE).ifPresent(tempFileName -> checkItems.add(this.buildConsistencyCheckItem(new File(pathFile, (String)tempFileName), 2)));
    }

    @Generated
    public ConsistencyFilterFileTask setInterruptWhenException(boolean isInterruptWhenException) {
        this.isInterruptWhenException = isInterruptWhenException;
        return this;
    }

    @Generated
    public ConsistencyFilterFileTask setInstallModes(List<String> installModes) {
        this.installModes = installModes;
        return this;
    }

    private static interface Checkable {
        public void check(List<ConsistencyCheckItem> var1, File var2) throws ConsistencyException;
    }
}

