/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.consistency;

import com.huawei.yinglong.river.sitedeployment.dcs.consistency.ConsistencyCheckItem;
import com.huawei.yinglong.river.sitedeployment.dcs.consistency.ConsistencyCheckTask;
import com.huawei.yinglong.river.sitedeployment.dcs.consistency.ConsistencyFilterFileTask;
import com.huawei.yinglong.river.sitedeployment.dcs.consistency.ConsistencyFilterType;
import com.huawei.yinglong.river.sitedeployment.dcs.consistency.ConsistencyTaskInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.consistency.ConsistencyType;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.BasicException;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistencyManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConsistencyManager.class);
    private static final ConsistencyManager MANAGER = new ConsistencyManager();
    private final Map<String, ConsistencyTaskInfo> consistencyCheckResults = new ConcurrentHashMap<String, ConsistencyTaskInfo>();

    public static ConsistencyManager getManager() {
        return MANAGER;
    }

    public List<ConsistencyCheckItem> queryCheckResult(String uuid) {
        ConsistencyTaskInfo taskInfo = this.consistencyCheckResults.get(uuid);
        if (taskInfo == null || taskInfo.getItems() == null) {
            log.error("not find check task ,uuid = {}.", (Object)uuid);
            return Collections.emptyList();
        }
        return new ArrayList<ConsistencyCheckItem>(taskInfo.getItems());
    }

    public List<ConsistencyCheckItem> queryCheckItems(String path, ConsistencyFilterType filterType, ConsistencyType consistencyType, String installModes) throws BasicException {
        return this.queryCheckItems(path, true, filterType, consistencyType, installModes);
    }

    public List<ConsistencyCheckItem> queryCheckItems(String path, boolean interrupt, ConsistencyFilterType filterType, ConsistencyType consistencyType, String installModes) throws BasicException {
        ConsistencyFilterFileTask filterFileTask = new ConsistencyFilterFileTask(path, filterType, consistencyType);
        filterFileTask.setInterruptWhenException(interrupt);
        filterFileTask.setInstallModes(StringUtils.isEmpty(installModes) ? Collections.emptyList() : Arrays.asList(installModes.split(",")));
        Future<List<ConsistencyCheckItem>> future = ThreadUtils.submit(filterFileTask);
        try {
            return future.get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.error("query Consistency check item failed.", (Throwable)e);
            Throwable throwable = e.getCause();
            if (throwable instanceof BasicException) {
                throw (BasicException)throwable;
            }
            return Collections.emptyList();
        }
    }

    public String startConsistencyCheck(List<ConsistencyCheckItem> checkItems, ConsistencyType consistencyType) {
        if (CollectionUtils.isEmpty(checkItems)) {
            log.error("check package has empty.");
            return "";
        }
        String uuid = UUID.randomUUID().toString();
        ConsistencyTaskInfo taskInfo = ConsistencyTaskInfo.builder().uuid(uuid).consistencyType(consistencyType).items(checkItems).build();
        ThreadUtils.execute(new ConsistencyCheckTask(taskInfo));
        this.consistencyCheckResults.put(uuid, taskInfo);
        return uuid;
    }

    public List<ConsistencyCheckItem> syncStartConsistencyCheck(String path, ConsistencyFilterType filterType, ConsistencyType consistencyType) throws BasicException {
        return new ConsistencyCheckTask(ConsistencyTaskInfo.builder().uuid(UUID.randomUUID().toString()).consistencyType(consistencyType).items(this.queryCheckItems(path, false, filterType, consistencyType, "")).build()).executeCheckItem();
    }
}

