/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.consistency;

import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConsistencyPattern {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConsistencyPattern.class);
    public static final Pattern PATTERN_A3000_FUSIONCUBE_METAVISION = Pattern.compile("^FusionCube_A3000_(.*)?_MetaVision_(aarch64|x86_64)\\.tar\\.gz$");
    public static final Pattern PATTERN_A3000_FUSIONCOMPUTE_K8S = Pattern.compile("^eContainer-K8S-Software-(.*)?-(aarch64|x86_64)\\.zip$");
    public static final Pattern PATTERN_A3000_EULEROS_FILE = Pattern.compile("^eContainer_EulerOS-(.*)?_(.*)?_(aarch64|x86_64)\\.tgz$");
    public static final List<String> CAMPUS_CERT_FILE = Collections.unmodifiableList(Arrays.asList("rootCA.crt", "server_chain.cer.pem"));
    private static final Pattern PATTERN_FC_INSTALLER = Pattern.compile("^FusionCompute-LinuxInstaller-(\\d\\.)+\\w+-(X86_64|ARM_64)\\.zip$");
    private static final Pattern PATTERN_FC_VMTOOLS_X86 = Pattern.compile("^FusionCompute_SIA-(\\d\\.)+\\w+-GuestOSDriver_X86\\.zip$");
    private static final Pattern PATTERN_CNA_ISO = Pattern.compile("^FusionCompute_CNA-(\\d\\.)+\\w+-(X86_64|ARM_64)\\.iso$");
    private static final Pattern PATTERN_VRM_TEMPLATE = Pattern.compile("^FusionCompute_VRM-(\\d\\.)+\\w+-(X86_64|ARM_64)\\.zip$");
    private static final Pattern PATTERN_DME_DATA_EULER_ISO_ARM = Pattern.compile("^(e)?DME(-Data)?_(.+)?EulerOS(.+)?_ARM(_64)?\\.iso$");
    private static final Pattern PATTERN_DME_DATA_EULER_ISO_X86 = Pattern.compile("^(e)?DME(-Data)?_(.+)?EulerOS(.+)?_X86(_64)?\\.iso$");
    private static final Pattern PATTERN_DME_DATA_SOFTWARE_ARM = Pattern.compile("^(e)?DME(-Data)?_(.+)?(.B\\d{0,3})?_Software_Euler_ARM\\.zip$");
    private static final Pattern PATTERN_DME_DATA_SOFTWARE_X86 = Pattern.compile("^(e)?DME(-Data)?_(.+)?(.B\\d{0,3})?_Software_Euler_X86\\.zip$");
    private static final Pattern PATTERN_DME_EDI_OM_SOFTWARE_ARM = Pattern.compile("^eDataInsight[-_](.+)?(\\.B\\d{0,3})?[-_]Manager[-_]Euler(-ARM_64)?\\.zip$");
    private static final Pattern PATTERN_DME_EDI_OM_SOFTWARE_X86 = Pattern.compile("^eDataInsight[-_](.+)?(\\.B\\d{0,3})?[-_]Manager[-_]Euler(-X86_64)?\\.zip$");
    private static final Pattern PATTERN_DME_CCS_SOFTWARE = Pattern.compile("DCSCCS_(.*)?_Manager_Euler\\.zip$");
    private static final Pattern PATTERN_DME_DCSAS_SOFTWARE = Pattern.compile("DCSAS_(.*)?_Manager_Euler\\.zip$");
    private static final Pattern PATTERN_DME_IMS_SOFTWARE = Pattern.compile("DCSIMS_(.*)?_Manager_Euler\\.zip$");
    private static final Pattern PATTERN_ULTRAVR = Pattern.compile("^UltraVR V\\d{3}R\\d{3}C\\d{2}(SPC\\d{3})?_VHD_For_Euler_(X86|ARM)\\.zip$");
    private static final Pattern PATTERN_ULTRAVR_NEW = Pattern.compile("^OceanStor_BCManager_(\\d\\.)+\\w+_UltraVR_VHD_for_Euler_(X86|ARM)\\.zip$");
    private static final Pattern PATTERN_EBACKUP = Pattern.compile("^OceanStor BCManager (\\d\\.)+\\w+_eBackup_KVMtemplate_euler_(x86_64|aarch64)_virtualization\\.zip$");
    private static final Pattern PATTERN_MLNX_ROCE_DRIVER = Pattern.compile("^MLNX_OFED_LINUX-.*?-euleros(\\d\\.)+\\dsp\\d+-(x86_64|aarch64)\\.tgz$");
    private static final Pattern PATTERN_HIFC_1822_DRIVER = Pattern.compile("^hifc-.+eulerosv2r10\\.aarch64-1\\.aarch64\\.rpm$");
    private static final Pattern PATTERN_TXGBE_DRIVER = Pattern.compile("^txgbe.ko$");
    private static final Pattern PATTERN_VM_IMAGE = Pattern.compile("^ITInfra_.*?_Software_Euleros.*?-(X86|Aarch64)_Pkg-FusionSphereVMImage40g-(Any|OP)\\.zip$");
    private static final Pattern PATTERN_GKIT_IMAGE = Pattern.compile("^ITInfra_.*?_Software_Euleros.*?-(X86|Aarch64)_Pkg-OriginalISO-OP\\.zip$");
    private static final Pattern PATTERN_CONVERSION_SCRIPT = Pattern.compile("^HiCloud_.*?_Tool_Any-Any_HicloudVMToolBox-OP\\.zip$");
    private static final Pattern PATTERN_AUTO_INSTALL_SCRIPT = Pattern.compile("^HiCloud_.*?_Tool_Any-Any_HicloudAutoInstallTool-OP\\.zip$");
    private static final Pattern PATTERN_QEMU = Pattern.compile("^HiCloud_.*?_Tool_Euler-(X86|Aarch64)_Docker-Qemu\\.zip$");
    private static final Pattern PATTERN_QCOW2_FILE = Pattern.compile(".*\\.qcow2");
    private static final Pattern PATTERN_EDATAINSIGHT_IMAGE_FILE = Pattern.compile("^eDataInsight_.*?_DayuImage_Euler-(x86_64|aarch64)\\.zip$");
    private static final Pattern PATTERN_EDATAINSIGHT_SOFTWARE_FILE = Pattern.compile("^eDataInsight_.*?_Software_Euler-(x86_64|aarch64)\\.zip$");
    private static final Pattern PATTERN_SFS_VHD = Pattern.compile("^DCS_SFS_.*?_(ARM|X86)\\.zip$");
    private static final Pattern PATTERN_SDN_VHD = Pattern.compile("^iMasterNCEServerInstall_.*?_EulerOS.*?-vhd-(aarch64|x86-64)\\.zip$");
    private static final Pattern PATTERN_SFS_INTEGRATE_ADAPT = Pattern.compile("^resource_uniteAccess_sfs_.*?\\.tar\\.gz$");
    private static final Pattern PATTERN_SFS_INTEGRATE_ADAPT_CMS = Pattern.compile("^resource_uniteAccess_sfs_.*?\\.tar\\.gz\\.cms$");
    private static final Pattern PATTERN_SFS_INTEGRATE_ADAPT_CRL = Pattern.compile("^resource_uniteAccess_sfs_.*?\\.tar\\.gz\\.crl$");
    private static final Pattern PATTERN_HICLOUD_INTEGRATE_BMSS = Pattern.compile("^HiCloud_.*?_Software_Euler-Any_Docker-BMSSCUI\\.7z$");
    private static final Pattern PATTERN_HICLOUD_INTEGRATE_DBAAS = Pattern.compile("^HiCloud_.*?_Software_Euler-Any_Docker-DBaasSCUI\\.7z$");
    private static final Pattern PATTERN_HICLOUD_INTEGRATE_VMWARE = Pattern.compile("^HiCloud_.*?_Software_Euler-Any_Docker-VMwareSCUI\\.7z$");
    private static final Pattern PATTERN_HICLOUD_INTEGRATE_SECURITY = Pattern.compile("^HiCloud_.*?_Software_Euler-Any_Docker-SecuritySCUI\\.7z$");
    private static final Pattern PATTERN_ULTRAVE_INTEGRATE_ADAPT = Pattern.compile("^resource_uniteAccess_csha_.*?\\.zip$");
    private static final Pattern PATTERN_CAMPUS_INTEGRATE_LINK_ADAPT = Pattern.compile("^eCampusCore_.*?_PaaSeLink\\.zip$");
    private static final Pattern PATTERN_CAMPUS_INTEGRATE_API_ADAPT = Pattern.compile("^eCampusCore_.*?_PaaSAPIGW\\.zip$");
    private static final Pattern PATTERN_A3000_ECONTAINER_INSTALLER = Pattern.compile("^eContainerInstaller-Linux-.*?-(ARM_64|x86_64)\\.tar$");
    private static final Pattern PATTERN_A3000_ESDK_CSI = Pattern.compile("^huawei_csi_install_package_(arm|x86)\\.tar$");
    private static final Pattern PATTERN_A3000_NPU_DRIVER = Pattern.compile("^Ascend-hdk-.*?-npu_.*?_linux-(aarch64|x86-64)\\.zip$");
    private static final Pattern PATTERN_A3000_NPU_EXPORTER = Pattern.compile("^Ascend-mindxdl-npu-exporter_.*?_linux-(aarch64|X86_64)\\.tar$");
    private static final Pattern PATTERN_A3000_DEVICE_PLUGIN = Pattern.compile("^Ascend-mindxdl-device-plugin_.*?_linux-(aarch64|X86_64)\\.tar$");
    private static final Pattern PATTERN_A3000_IBMA_ZIP = Pattern.compile("^iBMA_.*?_Software_Linux_(aarch64|x86_64)\\.zip$");
    private static final Pattern PATTERN_A3000_IBMA_TAR = Pattern.compile("^iBMA-Linux-.*?(-aarch64|)\\.tar\\.gz$");
    private static final Pattern PATTERN_A3000_DOCKER_RUNTIME = Pattern.compile("^Ascend-docker-runtime_.*?_linux-(aarch64|x86_64)\\.run$");
    private static final Pattern NPU_DRIVER_VERSION = Pattern.compile("^Ascend-hdk-(?<type>[0-9a-zA-Z]+)-npu_(?<version>[.0-9a-zA-Z]+)_linux-(aarch64|x86-64)\\.zip$");
    private static final Pattern PATTERN_A3000_ECONTAINER_SOFTWARE = Pattern.compile("^eContainer_.*?_(aarch64|x86_64)\\.tar\\.gz$");

    public static boolean isMatchFusionComputeInstallerPackage(String fileName) {
        return PATTERN_FC_INSTALLER.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isMatchFusionComputeVmToolsPackage(String fileName) {
        return PATTERN_FC_VMTOOLS_X86.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isMatchCnaIsoPackage(String fileName) {
        return PATTERN_CNA_ISO.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isMatchVrmTemplatePackage(String fileName) {
        return PATTERN_VRM_TEMPLATE.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isMatchDmeDataEulerIsoPackage(String fileName) {
        return ConsistencyPattern.isMatchDmeDataArmEulerIsoPackage(fileName) || ConsistencyPattern.isMatchDmeDataX86EulerIsoPackage(fileName);
    }

    public static boolean isMatchDmeDataArmEulerIsoPackage(String fileName) {
        return PATTERN_DME_DATA_EULER_ISO_ARM.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isMatchDmeDataX86EulerIsoPackage(String fileName) {
        return PATTERN_DME_DATA_EULER_ISO_X86.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isMatchDmeDataSoftwarePackage(String fileName) {
        return ConsistencyPattern.isMatchDmeDataArmSoftwarePackage(fileName) || ConsistencyPattern.isMatchDmeDataX86SoftwarePackage(fileName);
    }

    public static boolean isMatchUltraVRTemplateFile(String fileName) {
        return PATTERN_ULTRAVR.matcher(StringUtils.defaultString(fileName)).find() || PATTERN_ULTRAVR_NEW.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isMatchEbackupTemplateFile(String fileName) {
        return PATTERN_EBACKUP.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isMatchEDataInsightImageFile(String fileName) {
        return PATTERN_EDATAINSIGHT_IMAGE_FILE.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isMatchEDataInsightSoftwareFile(String fileName) {
        return PATTERN_EDATAINSIGHT_SOFTWARE_FILE.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isMatchDmeDataArmSoftwarePackage(String fileName) {
        return PATTERN_DME_DATA_SOFTWARE_ARM.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isMatchDmeDataX86SoftwarePackage(String fileName) {
        return PATTERN_DME_DATA_SOFTWARE_X86.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isMatchDmeEDiOmSoftwarePackage(String fileName) {
        return ConsistencyPattern.isMatchDmeEDiOmArmSoftwarePackage(fileName) || ConsistencyPattern.isMatchDmeEDiOmX86SoftwarePackage(fileName);
    }

    public static boolean isMatchDmeEDiOmArmSoftwarePackage(String fileName) {
        return PATTERN_DME_EDI_OM_SOFTWARE_ARM.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isMatchDmeEDiOmX86SoftwarePackage(String fileName) {
        return PATTERN_DME_EDI_OM_SOFTWARE_X86.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isMatchDmeCssSoftwarePackage(String fileName) {
        return PATTERN_DME_CCS_SOFTWARE.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isMatchDmeAsSoftwarePackage(String fileName) {
        return PATTERN_DME_DCSAS_SOFTWARE.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isMatchDmeImsSoftwarePackage(String fileName) {
        return PATTERN_DME_IMS_SOFTWARE.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isMatchEulerMlnxRoCEDriver(String fileName) {
        return PATTERN_MLNX_ROCE_DRIVER.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isMatchHifc1822RoCEDriver(String fileName) {
        return PATTERN_HIFC_1822_DRIVER.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isMatchTxgbeRoCEDriver(String fileName) {
        return PATTERN_TXGBE_DRIVER.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean hasDmeDatSoftwareCmsFile(String filePath, String fileName) {
        return FilePathValidatorUtils.getSafePath(filePath).filter(s -> new File((String)s, fileName + ".cms").exists()).isPresent();
    }

    public static boolean hasDmeDatSoftwareCmsFile(File file, String fileName) {
        return FilePathValidatorUtils.getSafePath(file).filter(s -> new File((String)s, fileName + ".cms").exists()).isPresent();
    }

    public static boolean hasDmeDatSoftwareCrlFile(String filePath, String fileName) {
        return FilePathValidatorUtils.getSafePath(filePath).filter(s -> new File((String)s, fileName + ".crl").exists()).isPresent();
    }

    public static boolean hasDmeDatSoftwareCrlFile(File file, String fileName) {
        return FilePathValidatorUtils.getSafePath(file).filter(s -> new File((String)s, fileName + ".crl").exists()).isPresent();
    }

    public static boolean isHiCloudConversionScriptPackage(String fileName) {
        return PATTERN_CONVERSION_SCRIPT.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isHiCloudAutoInstallScriptPackage(String fileName) {
        return PATTERN_AUTO_INSTALL_SCRIPT.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isHiCloudVmImageFilePackage(String fileName) {
        return PATTERN_VM_IMAGE.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isHiCloudGKitImageFilePackage(String fileName) {
        return PATTERN_GKIT_IMAGE.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isHiCloudQemuPackage(String fileName) {
        return PATTERN_QEMU.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isSfsVhdFilePackage(String fileName) {
        return PATTERN_SFS_VHD.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isSdnVhdFilePackage(String fileName) {
        return PATTERN_SDN_VHD.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isSfsIntegrateFilePackage(String fileName) {
        return PATTERN_SFS_INTEGRATE_ADAPT.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isSfsIntegrateCmsFilePackage(String fileName) {
        return PATTERN_SFS_INTEGRATE_ADAPT_CMS.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isSfsIntegrateCrlFilePackage(String fileName) {
        return PATTERN_SFS_INTEGRATE_ADAPT_CRL.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isHiCloudBmsIntegrateFilePackage(String fileName) {
        return PATTERN_HICLOUD_INTEGRATE_BMSS.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isHiCloudDBaasIntegrateFilePackage(String fileName) {
        return PATTERN_HICLOUD_INTEGRATE_DBAAS.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isHiCloudVmWareIntegrateFilePackage(String fileName) {
        return PATTERN_HICLOUD_INTEGRATE_VMWARE.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isHiCloudSecurityIntegrateFilePackage(String fileName) {
        return PATTERN_HICLOUD_INTEGRATE_SECURITY.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isUltraVrIntegrateFilePackage(String fileName) {
        return PATTERN_ULTRAVE_INTEGRATE_ADAPT.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isCampusIntegrateLinkFilePackage(String fileName) {
        return PATTERN_CAMPUS_INTEGRATE_LINK_ADAPT.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isCampusIntegrateApiFilePackage(String fileName) {
        return PATTERN_CAMPUS_INTEGRATE_API_ADAPT.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isA3000EulerOsPackage(String fileName) {
        return PATTERN_A3000_EULEROS_FILE.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isA3000EContainerInstallerPackage(String fileName) {
        return PATTERN_A3000_ECONTAINER_INSTALLER.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isA3000EContainerSoftwarePackage(String fileName) {
        return PATTERN_A3000_ECONTAINER_SOFTWARE.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isA3000IBMAZipPackage(String fileName) {
        return PATTERN_A3000_IBMA_ZIP.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isA3000IBMATarPackage(String fileName) {
        return PATTERN_A3000_IBMA_TAR.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isA3000FusionCubeMetaVisionPackage(String fileName) {
        return PATTERN_A3000_FUSIONCUBE_METAVISION.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isA3000FusionComputeK8SPackage(String fileName) {
        return PATTERN_A3000_FUSIONCOMPUTE_K8S.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isA3000EsdkCsiPackage(String fileName) {
        return PATTERN_A3000_ESDK_CSI.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isA3000NpuExporterPackage(String fileName) {
        return PATTERN_A3000_NPU_EXPORTER.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isA3000NpuDriverPackage(String fileName) {
        return PATTERN_A3000_NPU_DRIVER.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isA3000DevicePluginPackage(String fileName) {
        return PATTERN_A3000_DEVICE_PLUGIN.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isA3000DevicePluginYaml(String fileName) {
        return fileName.startsWith("device-plugin") && fileName.endsWith(".yaml");
    }

    public static boolean isA3000ExporterYaml(String fileName) {
        return fileName.startsWith("npu-export") && fileName.endsWith(".yaml");
    }

    public static boolean isA3000DockerRuntimePackage(String fileName) {
        return PATTERN_A3000_DOCKER_RUNTIME.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isQcow2File(String fileName) {
        return PATTERN_QCOW2_FILE.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isHiCloudConversionRequiredPackage(String fileName) {
        return ConsistencyPattern.isHiCloudQemuPackage(fileName) || ConsistencyPattern.isHiCloudVmImageFilePackage(fileName) || ConsistencyPattern.isHiCloudConversionScriptPackage(fileName);
    }

    public static String parseNpuDriverName(String fileName) {
        Matcher matcher = NPU_DRIVER_VERSION.matcher(fileName);
        if (matcher.find()) {
            return "Ascend" + matcher.group("type").toUpperCase(Locale.ENGLISH) + "-NPU-Driver";
        }
        log.warn("parse driver name failed for name :{}", (Object)fileName);
        return "";
    }

    public static String parseNpuDriverVersion(String fileName) {
        Matcher matcher = NPU_DRIVER_VERSION.matcher(fileName);
        if (matcher.matches()) {
            return matcher.group("version");
        }
        log.warn("parse driver version failed for name :{}", (Object)fileName);
        return "";
    }

    public static Map<String, String> getEcampusCorePattern() {
        HashMap<String, String> eCampusCore = new HashMap<String, String>();
        eCampusCore.put("^eCampusCore_.*?_PreInstallation_aarch64\\.zip$", "eCampusCore_XXX_PreInstallation_aarch64.zip");
        eCampusCore.put("^eCampusCore_.*?_PreInstallation_x86_64\\.zip$", "eCampusCore_XXX_PreInstallation_x86_64.zip");
        eCampusCore.put("^eCampusCore_.*?_IntegrationFramework_aarch64\\.zip$", "eCampusCore_XXX_IntegrationFramework_aarch64.zip");
        eCampusCore.put("^eCampusCore_.*?_IntegrationFramework_x86_64\\.zip$", "eCampusCore_XXX_IntegrationFramework_x86_64.zip");
        eCampusCore.put("^eCampusCore_.*?_BasicService_EulerOS_aarch64\\.tgz$", "eCampusCore_XXX_BasicService_EulerOS_aarch64.tgz");
        eCampusCore.put("^eCampusCore_.*?_BasicService_EulerOS_x86_64\\.tgz$", "eCampusCore_XXX_BasicService_EulerOS_x86_64.tgz");
        eCampusCore.put("^eCampusCore_.*?_Middleware_EulerOS_aarch64\\.tgz$", "eCampusCore_XXX_Middleware_EulerOS_aarch64.tgz");
        eCampusCore.put("^eCampusCore_.*?_Middleware_EulerOS_x86_64\\.tgz$", "eCampusCore_XXX_Middleware_EulerOS_x86_64.tgz");
        eCampusCore.put("^eCampusCore_.*?_OPS_EulerOS_aarch64\\.tgz$", "eCampusCore_XXX_OPS_EulerOS_aarch64.tgz");
        eCampusCore.put("^eCampusCore_.*?_OPS_EulerOS_x86_64\\.tgz$", "eCampusCore_XXX_OPS_EulerOS_x86_64.tgz");
        eCampusCore.put("^eCampusCore_.*?_Portal_EulerOS_aarch64\\.tgz$", "eCampusCore_XXX_Portal_EulerOS_aarch64.tgz");
        eCampusCore.put("^eCampusCore_.*?_Portal_EulerOS_x86_64\\.tgz$", "eCampusCore_XXX_Portal_EulerOS_x86_64.tgz");
        eCampusCore.put("^eCampusCore_.*?_PaaSeLink\\.zip$", "eCampusCore_XXX_PaaSeLink.zip");
        eCampusCore.put("^eCampusCore_.*?_PaaSServiceProvision_aarch64\\.tgz$", "eCampusCore_XXX_PaaSServiceProvision_aarch64.tgz");
        eCampusCore.put("^eCampusCore_.*?_PaaSServiceProvision_x86_64\\.tgz$", "eCampusCore_XXX_PaaSServiceProvision_x86_64.tgz");
        eCampusCore.put("^eCampusCore_.*?_LinkSoft_EulerOS_aarch64\\.tgz$", "eCampusCore_XXX_LinkSoft_EulerOS_aarch64.tgz");
        eCampusCore.put("^eCampusCore_.*?_LinkSoft_EulerOS_x86_64\\.tgz$", "eCampusCore_XXX_LinkSoft_EulerOS_x86_64.tgz");
        eCampusCore.put("^eCampusCore_.*?_LinkDevice_EulerOS_aarch64\\.tgz$", "eCampusCore_XXX_LinkDevice_EulerOS_aarch64.tgz");
        eCampusCore.put("^eCampusCore_.*?_LinkDevice_EulerOS_x86_64\\.tgz$", "eCampusCore_XXX_LinkDevice_EulerOS_x86_64.tgz");
        eCampusCore.put("^eCampusCore_.*?_APIGW_EulerOS_aarch64\\.tgz$", "eCampusCore_XXX_APIGW_EulerOS_aarch64.tgz");
        eCampusCore.put("^eCampusCore_.*?_APIGW_EulerOS_x86_64\\.tgz$", "eCampusCore_XXX_APIGW_EulerOS_x86_64.tgz");
        eCampusCore.put("^VMTemplate_(aarch64|x86_64)_CampusContainerImage\\.zip$", "VMTemplate_XXX_CampusContainerImage.zip");
        eCampusCore.put("^(?!.*Installer).*VMTemplate_(aarch64|x86_64)_Euler.*?\\.zip$", "VMTemplate_XXX_EulerXXX.zip");
        eCampusCore.put("^VMTemplate_(aarch64|x86_64)_Euler.*?_Installer\\.zip$", "VMTemplate_XXX_EulerXXX_Installer.zip");
        eCampusCore.put("^rootCA\\.crt$", "rootCA.crt");
        eCampusCore.put("^server_chain\\.cer\\.pem$", "server_chain.cer.pem");
        eCampusCore.put("^eCampusCore_.*?_IO\\.tgz$", "eCampusCore_XXX_IO.tgz");
        eCampusCore.put("^eCampusCore_.*?_DeviceAsset_EulerOS_aarch64\\.tgz$", "eCampusCore_XXX_DeviceAsset_EulerOS_aarch64.tgz");
        eCampusCore.put("^eCampusCore_.*?_DeviceAsset_EulerOS_x86_64\\.tgz$", "eCampusCore_XXX_DeviceAsset_EulerOS_x86_64.tgz");
        eCampusCore.put("^eCampusCore_.*?_vdd\\.zip$", "eCampusCore_XXX_vdd.zip");
        return eCampusCore;
    }

    @Generated
    private ConsistencyPattern() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

