/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.consistency;

import com.huawei.yinglong.river.sitedeployment.dcs.consistency.ConsistencyVerifiable;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.CryptUtils;
import java.io.File;
import java.util.stream.Stream;
import lombok.Generated;

public enum ConsistencyType implements ConsistencyVerifiable
{
    NONE("", (pkgFile, verifyFile) -> true),
    SIGN(".sign", CryptUtils::verifyConsistencyFileBySign),
    CMS(".p7s", CryptUtils::verifyConsistencyFileByCms),
    SHA256(".sha256", CryptUtils::verifyConsistencyFileBySha256);

    private final String suffix;
    private final ConsistencyVerifiable verifiable;

    String getConsistencyFileName(String fileName) {
        return fileName + this.suffix;
    }

    public static ConsistencyType of(String typeName) {
        return Stream.of(ConsistencyType.values()).filter(consistencyType -> consistencyType.name().equalsIgnoreCase(typeName)).findFirst().orElse(CMS);
    }

    @Override
    public boolean verify(File srcFile, File signFile) {
        return this.verifiable != null && this.verifiable.verify(srcFile, signFile);
    }

    @Generated
    private ConsistencyType(String suffix, ConsistencyVerifiable verifiable) {
        this.suffix = suffix;
        this.verifiable = verifiable;
    }
}

