/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.consistency.fusioncube;

import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.util.regex.Pattern;

public class FusionCubeConsistencyValidate {
    public static final Pattern FUSION_CUBE_EBACKUP_A_VHD = Pattern.compile("^eBackup-A-template-vda.vhd$");
    public static final Pattern FUSION_CUBE_EBACKUP_B_VHD = Pattern.compile("^eBackup-B-template-vda.vhd$");
    public static final Pattern FUSION_CUBE_EBACKUP_A_OVF = Pattern.compile("^eBackup-A-template.ovf$");
    public static final Pattern FUSION_CUBE_EBACKUP_B_OVF = Pattern.compile("^eBackup-B-template.ovf$");
    public static final Pattern FUSION_CUBE_NFS_VHD = Pattern.compile("^nfs-template-vda.vhd$");
    public static final Pattern FUSION_CUBE_NFS_OVF = Pattern.compile("^nfs-template.ovf$");
    public static final Pattern FUSION_CUBE_MIGRATION_TEMPLATE = Pattern.compile("^FusionCube_.*?_MigrationTemplate\\.zip$");

    public static boolean isFusionCubeMigrationTemplate(String fileName) {
        return FUSION_CUBE_MIGRATION_TEMPLATE.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isEbackupAvhd(String fileName) {
        return FUSION_CUBE_EBACKUP_A_VHD.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isEbackupBvhd(String fileName) {
        return FUSION_CUBE_EBACKUP_B_VHD.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isEbackupAovf(String fileName) {
        return FUSION_CUBE_EBACKUP_A_OVF.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isEbackupBovf(String fileName) {
        return FUSION_CUBE_EBACKUP_B_OVF.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isNfsVhd(String fileName) {
        return FUSION_CUBE_NFS_VHD.matcher(StringUtils.defaultString(fileName)).find();
    }

    public static boolean isNfsOvf(String fileName) {
        return FUSION_CUBE_NFS_OVF.matcher(StringUtils.defaultString(fileName)).find();
    }
}

