/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.constant;

import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.WeakPasswordValidUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;
import lombok.Generated;

public enum PasswordValidTypeEnum {
    OTHER,
    CLOUD_SOP,
    SFS,
    CAMPUS,
    HICLOUD;

    private static final Pattern SFS_GENERAL;
    private static final Pattern CAMPUS_GENERAL;
    private static final List<String> CAMPUS_INVALID_USERNAME_IN_PWD;
    private static final Pattern GENERAL;
    private static final Pattern PATTERN_PHONE;
    private static final Pattern PATTERN_EMAIL;
    private static final Pattern PATTERN_REPEATED_TWO_TIMES;

    public static boolean needValid(PasswordValidTypeEnum validTypeEnum) {
        return validTypeEnum != OTHER;
    }

    public static boolean validPassword(PasswordValidTypeEnum type, String value) {
        switch (type) {
            case CLOUD_SOP: {
                return PasswordValidTypeEnum.validCloudSopPassword(value);
            }
            case SFS: {
                return PasswordValidTypeEnum.validSfsPassword(value);
            }
            case CAMPUS: {
                return PasswordValidTypeEnum.validCampusPassword(value);
            }
            case HICLOUD: {
                return PasswordValidTypeEnum.validHiCloudPassword(value);
            }
        }
        return true;
    }

    private static boolean validHiCloudPassword(String value) {
        return PasswordValidTypeEnum.validCloudSopPassword(value) && !PasswordValidTypeEnum.isContinuousChar(value);
    }

    private static boolean validCampusPassword(String value) {
        return !PasswordValidTypeEnum.checkCampusPwdContainUsername(value) && !PasswordValidTypeEnum.checkPwdContainAdmin(value) && !PasswordValidTypeEnum.checkPwdPalindrome(value) && !PasswordValidTypeEnum.checkPwdDuplicate3Times(value) && !PasswordValidTypeEnum.checkPwdRepeated2Times(value) && !PasswordValidTypeEnum.checkPwdContainPhoneOrEmail(value) && PasswordValidTypeEnum.checkPwdCampusGeneralRule(value) && WeakPasswordValidUtils.validWeakPassword(value);
    }

    private static boolean validSfsPassword(String value) {
        return !PasswordValidTypeEnum.checkPwdContainAdmin(value) && !PasswordValidTypeEnum.checkPwdPalindrome(value) && !PasswordValidTypeEnum.checkPwdDuplicate3Times(value) && !PasswordValidTypeEnum.checkPwdRepeated2Times(value) && !PasswordValidTypeEnum.checkPwdContainPhoneOrEmail(value) && PasswordValidTypeEnum.checkPwdSfsGeneralRule(value) && WeakPasswordValidUtils.validWeakPassword(value);
    }

    private static boolean checkPwdSfsGeneralRule(String value) {
        return SFS_GENERAL.matcher(value).find();
    }

    private static boolean checkPwdCampusGeneralRule(String value) {
        return CAMPUS_GENERAL.matcher(value).find();
    }

    private static boolean validCloudSopPassword(String value) {
        return !PasswordValidTypeEnum.checkPwdContainAdmin(value) && !PasswordValidTypeEnum.checkPwdPalindrome(value) && !PasswordValidTypeEnum.checkPwdDuplicate3Times(value) && !PasswordValidTypeEnum.checkPwdRepeated2Times(value) && !PasswordValidTypeEnum.checkPwdContainPhoneOrEmail(value) && PasswordValidTypeEnum.checkPwdGeneralRule(value) && WeakPasswordValidUtils.validWeakPassword(value);
    }

    private static boolean checkPwdGeneralRule(String value) {
        return GENERAL.matcher(value).find();
    }

    public static boolean isContinuousChar(String value) {
        char[] valueChars = value.toCharArray();
        for (int i = 0; i < valueChars.length - 2; ++i) {
            if (!Character.isLetterOrDigit(valueChars[i])) continue;
            char firstChar = valueChars[i];
            char secondChar = valueChars[i + 1];
            char thirdChar = valueChars[i + 2];
            if ((firstChar + '\u0001' != secondChar || firstChar + 2 != thirdChar) && (firstChar - '\u0001' != secondChar || firstChar - 2 != thirdChar)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkPwdRepeated2Times(String value) {
        if (StringUtils.isEmpty(value)) {
            return false;
        }
        return PATTERN_REPEATED_TWO_TIMES.matcher(value).find();
    }

    public static boolean checkPwdDuplicate3Times(String value) {
        if (StringUtils.isEmpty(value)) {
            return false;
        }
        int duplicateMaxTimes = 3;
        HashMap<Character, Integer> charCntMap = new HashMap<Character, Integer>();
        for (char ch : value.toCharArray()) {
            int duplicateCnt = charCntMap.getOrDefault(Character.valueOf(ch), 0) + 1;
            if (duplicateCnt > 3) {
                return true;
            }
            charCntMap.put(Character.valueOf(ch), duplicateCnt);
        }
        return false;
    }

    public static boolean checkCampusPwdContainUsername(String value) {
        if (StringUtils.isEmpty(value)) {
            return false;
        }
        return CAMPUS_INVALID_USERNAME_IN_PWD.stream().anyMatch(value.toLowerCase(Locale.ROOT)::contains);
    }

    public static boolean checkPwdContainAdmin(String value) {
        if (StringUtils.isEmpty(value)) {
            return false;
        }
        return value.contains("admin") || value.contains("nimda");
    }

    public static boolean checkPwdContainPhoneOrEmail(String value) {
        if (StringUtils.isEmpty(value)) {
            return false;
        }
        return PATTERN_PHONE.matcher(value).find() || PATTERN_EMAIL.matcher(value).find();
    }

    public static boolean checkPwdPalindrome(String value) {
        if (StringUtils.isEmpty(value)) {
            return false;
        }
        String lowerValues = value.toLowerCase(Locale.ROOT);
        return Objects.equals(lowerValues, new StringBuilder(lowerValues).reverse().toString());
    }

    @Generated
    private PasswordValidTypeEnum() {
    }

    static {
        SFS_GENERAL = Pattern.compile("^(?=.*?[A-Z])(?=.*?[a-z])(?=.*?[0-9])(?=.*?[.,?`~!@#$^&_])[A-Za-z0-9.,?`~!@#$^&_]{10,32}$");
        CAMPUS_GENERAL = Pattern.compile("^(?=.*[a-z])(?=.*[A-Z])(?=.*\\d)(?=.*@)[a-zA-Z\\d@]{10,32}$");
        CAMPUS_INVALID_USERNAME_IN_PWD = Collections.unmodifiableList(Arrays.asList("admin", "campussnmp", "root", "huawei", "sysomc", "hicampus", "gandalf"));
        GENERAL = Pattern.compile("^(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9])(?=.*[~@#^*()\\-_\\[{}\\]+:./?])[A-Za-z0-9~@#^*()\\-_=\\[{}\\]+:./?]{10,32}$");
        PATTERN_PHONE = Pattern.compile("((13[0-9])|(14[5,7])|(15[0-3,5-9])|(17[0,3,5-8])|(18[0-9])|166|198|199|147)\\d{8}");
        PATTERN_EMAIL = Pattern.compile("@[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)");
        PATTERN_REPEATED_TWO_TIMES = Pattern.compile("^.*(.)\\1\\1.*$");
    }
}

