/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.http;

import com.huawei.ism.tool.file.SecurityUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.http.HttpRetryInterceptor;
import com.huawei.yinglong.river.sitedeployment.dcs.http.LoggerInterceptor;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Objects;
import java.util.stream.Stream;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import lombok.Generated;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class HttpRequestApiFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpRequestApiFactory.class);
    private static final X509TrustManager X509_TRUST_MANAGER = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    };

    public static <T> T createRequestApi(String baseUrl, Class<T> apiClass) {
        return HttpRequestApiFactory.createRequestApi(baseUrl, apiClass, HttpRetryInterceptor.builder().build());
    }

    public static <T> T createRequestApi(String baseUrl, Class<T> apiClass, Interceptor ... interceptors) {
        return HttpRequestApiFactory.createRequestApi(baseUrl, apiClass, Duration.ofSeconds(30L), interceptors);
    }

    public static <T> T createRequestApi(String baseUrl, Class<T> apiClass, Duration duration, Interceptor ... interceptors) {
        return (T)new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(HttpRequestApiFactory.getUnsafeOkHttpClient(duration, interceptors)).build().create(apiClass);
    }

    private static OkHttpClient getUnsafeOkHttpClient(Duration duration, Interceptor ... interceptors) {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, new TrustManager[]{X509_TRUST_MANAGER}, (SecureRandom)SecurityUtils.createSecureRandom().orElseThrow(() -> new NoSuchAlgorithmException("No such algorithm found.")));
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            OkHttpClient.Builder builder = new OkHttpClient.Builder().sslSocketFactory(sslSocketFactory, X509_TRUST_MANAGER).hostnameVerifier((hostname, session) -> true).connectTimeout(duration).writeTimeout(duration).readTimeout(duration).callTimeout(duration);
            builder.addInterceptor((Interceptor)new LoggerInterceptor());
            if (interceptors != null) {
                Stream.of(interceptors).filter(Objects::nonNull).forEach(arg_0 -> ((OkHttpClient.Builder)builder).addInterceptor(arg_0));
            }
            return builder.build();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            log.error("getUnsafeOkHttpClient failed.", (Throwable)e);
            return new OkHttpClient().newBuilder().build();
        }
    }

    @Generated
    private HttpRequestApiFactory() {
    }
}

