/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.http;

import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRetryInterceptor
implements Interceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpRetryInterceptor.class);
    private int maxRetryCount;
    private int retryInterval;
    private TimeUnit timeUnit;

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Optional<Response> response = this.doRequest(chain, request);
        for (int currentRetryCount = 1; !(response.isPresent() && response.get().isSuccessful() || currentRetryCount > this.maxRetryCount); ++currentRetryCount) {
            response.ifPresent(Response::close);
            log.error("current request {} {} failed, status : {}.", new Object[]{request.method(), request.url(), response.map(Response::code).orElse(0)});
            ThreadUtils.threadSafeSleep(this.retryInterval, this.timeUnit);
            response = this.doRequest(chain, request);
        }
        return response.orElseThrow(() -> new IOException("request http error"));
    }

    private Optional<Response> doRequest(Interceptor.Chain chain, Request request) {
        try {
            return Optional.of(chain.proceed(request));
        }
        catch (Exception exception) {
            log.error("do http request {} error", (Object)request.url(), (Object)exception);
            return Optional.empty();
        }
    }

    @Generated
    private static int $default$maxRetryCount() {
        return 3;
    }

    @Generated
    private static int $default$retryInterval() {
        return 5;
    }

    @Generated
    private static TimeUnit $default$timeUnit() {
        return TimeUnit.SECONDS;
    }

    @Generated
    HttpRetryInterceptor(int maxRetryCount, int retryInterval, TimeUnit timeUnit) {
        this.maxRetryCount = maxRetryCount;
        this.retryInterval = retryInterval;
        this.timeUnit = timeUnit;
    }

    @Generated
    public static HttpRetryInterceptorBuilder builder() {
        return new HttpRetryInterceptorBuilder();
    }

    @Generated
    public static class HttpRetryInterceptorBuilder {
        @Generated
        private boolean maxRetryCount$set;
        @Generated
        private int maxRetryCount$value;
        @Generated
        private boolean retryInterval$set;
        @Generated
        private int retryInterval$value;
        @Generated
        private boolean timeUnit$set;
        @Generated
        private TimeUnit timeUnit$value;

        @Generated
        HttpRetryInterceptorBuilder() {
        }

        @Generated
        public HttpRetryInterceptorBuilder maxRetryCount(int maxRetryCount) {
            this.maxRetryCount$value = maxRetryCount;
            this.maxRetryCount$set = true;
            return this;
        }

        @Generated
        public HttpRetryInterceptorBuilder retryInterval(int retryInterval) {
            this.retryInterval$value = retryInterval;
            this.retryInterval$set = true;
            return this;
        }

        @Generated
        public HttpRetryInterceptorBuilder timeUnit(TimeUnit timeUnit) {
            this.timeUnit$value = timeUnit;
            this.timeUnit$set = true;
            return this;
        }

        @Generated
        public HttpRetryInterceptor build() {
            int maxRetryCount$value = this.maxRetryCount$value;
            if (!this.maxRetryCount$set) {
                maxRetryCount$value = HttpRetryInterceptor.$default$maxRetryCount();
            }
            int retryInterval$value = this.retryInterval$value;
            if (!this.retryInterval$set) {
                retryInterval$value = HttpRetryInterceptor.$default$retryInterval();
            }
            TimeUnit timeUnit$value = this.timeUnit$value;
            if (!this.timeUnit$set) {
                timeUnit$value = HttpRetryInterceptor.$default$timeUnit();
            }
            return new HttpRetryInterceptor(maxRetryCount$value, retryInterval$value, timeUnit$value);
        }

        @Generated
        public String toString() {
            return "HttpRetryInterceptor.HttpRetryInterceptorBuilder(maxRetryCount$value=" + this.maxRetryCount$value + ", retryInterval$value=" + this.retryInterval$value + ", timeUnit$value=" + (Object)((Object)this.timeUnit$value) + ")";
        }
    }
}

