/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.http;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.google.common.collect.ArrayListMultimap;
import com.huawei.ism.tool.sdk.unified.log.filter.LogFilterMark;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpHeaders;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerInterceptor
implements Interceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoggerInterceptor.class);
    private static final ArrayListMultimap<String, String> TEXT_MEDIA_TYPE = ArrayListMultimap.create();
    private final Set<String> sensitiveHeaders = new HashSet<String>(Arrays.asList("authorization", "cookie", "proxy-authorization", "set-cookie", "x-auth-token", "x-auth-key", "ibasetoken", "x-subject-token", "csrftoken"));
    private final Set<String> sensitiveBodyKeys = new HashSet<String>(Arrays.asList("password", "newpassword", "orignalpassword", "authpassword", "encryptpassword", "authkey", "ibasetoken", "token", "confirmpassword", "oldpassword"));

    public LoggerInterceptor addSensitiveHeader(String ... sensitiveKeys) {
        this.sensitiveHeaders.addAll(Arrays.stream(sensitiveKeys).map(String::toLowerCase).collect(Collectors.toSet()));
        return this;
    }

    public LoggerInterceptor addBodySensitiveKeys(String ... sensitiveKeys) {
        this.sensitiveBodyKeys.addAll(Arrays.stream(sensitiveKeys).map(String::toLowerCase).collect(Collectors.toSet()));
        return this;
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        RequestBody requestBody = request.body();
        String body = this.parseRequestBody(requestBody);
        log.info("Request {} {}, Headers: {}, Body: {}{}.", new Object[]{request.method(), request.url(), this.removeSensitiveHeaders(request.headers()), this.removeSensitiveInBody(body), LogFilterMark.INSENSITIVE});
        long startNs = System.nanoTime();
        Response response = chain.proceed(request);
        long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
        String rBody = this.parseResponseBody(response);
        log.info("Response code:{}, message:{}, cost:{}, Headers:{}, Body:{}{}.", new Object[]{response.code(), response.message(), tookMs, this.removeSensitiveHeaders(response.headers()), this.removeSensitiveInBody(rBody), LogFilterMark.INSENSITIVE});
        return response;
    }

    private String parseRequestBody(RequestBody requestBody) {
        try {
            if (Objects.isNull(requestBody) || !this.checkContentTypeIsText(requestBody.contentType())) {
                log.info("request content type is {}.", (Object)(Objects.isNull(requestBody) ? "none" : requestBody.contentType()));
                return "";
            }
            Buffer buffer = new Buffer();
            requestBody.writeTo((BufferedSink)buffer);
            return buffer.readString(this.parseCharsetInContentType(requestBody.contentType()));
        }
        catch (Exception e) {
            log.warn("record request body log failed.", (Throwable)e);
            return "";
        }
    }

    private boolean checkContentTypeIsText(MediaType mediaType) {
        String type = Optional.ofNullable(mediaType).map(MediaType::type).orElse("");
        String subtype = Optional.ofNullable(mediaType).map(MediaType::subtype).orElse("");
        return CollectionUtils.emptyIfNull((Collection)TEXT_MEDIA_TYPE.get((Object)type)).contains(subtype);
    }

    private String parseResponseBody(Response response) {
        try {
            ResponseBody responseBody = response.body();
            if (!HttpHeaders.hasBody((Response)response) || Objects.isNull(responseBody) || !this.checkContentTypeIsText(responseBody.contentType())) {
                log.info("Response content type is {}.", (Object)(Objects.isNull(responseBody) ? "none" : responseBody.contentType()));
                return "";
            }
            BufferedSource source = responseBody.source();
            source.request(Long.MAX_VALUE);
            Buffer buffer = source.getBuffer();
            return buffer.clone().readString(this.parseCharsetInContentType(responseBody.contentType()));
        }
        catch (Exception e) {
            log.warn("record response body log failed.", (Throwable)e);
            return "";
        }
    }

    @NotNull
    private Charset parseCharsetInContentType(MediaType mediaType) {
        return Optional.ofNullable(mediaType).map(contentType -> contentType.charset(StandardCharsets.UTF_8)).orElse(StandardCharsets.UTF_8);
    }

    private String removeSensitiveInBody(String body) {
        try {
            if (StringUtils.isEmpty(body)) {
                return body;
            }
            if (body.startsWith("{")) {
                return Optional.of(JSON.parseObject((String)body)).map(json -> Optional.of(this.handleJsonSensitiveValues((JSONObject)json))).map(x$0 -> JSONObject.toJSONString((Object)x$0, (JSONWriter.Feature[])new JSONWriter.Feature[0])).orElse(body);
            }
            if (body.startsWith("[")) {
                return Optional.of(this.handleArraySensitiveValues(JSON.parseArray((String)body))).map(array -> array.toJSONString(new JSONWriter.Feature[0])).orElse(body);
            }
        }
        catch (Exception e) {
            log.warn("record remove sensitive log failed.", (Throwable)e);
        }
        return body;
    }

    private JSONObject handleJsonSensitiveValues(JSONObject jsonObject) {
        jsonObject.entrySet().forEach(json -> {
            if (this.sensitiveBodyKeys.contains(((String)json.getKey()).toLowerCase(Locale.ROOT))) {
                json.setValue("********");
            } else if (json.getValue() instanceof JSONObject) {
                this.handleJsonSensitiveValues((JSONObject)json.getValue());
            } else if (json.getValue() instanceof JSONArray) {
                this.handleArraySensitiveValues((JSONArray)json.getValue());
            }
        });
        return jsonObject;
    }

    private JSONArray handleArraySensitiveValues(JSONArray jsonArray) {
        for (int i = 0; i < jsonArray.size(); ++i) {
            if (!(jsonArray.get(i) instanceof JSONObject)) continue;
            this.handleJsonSensitiveValues(jsonArray.getJSONObject(i));
        }
        return jsonArray;
    }

    private Map<String, List<String>> removeSensitiveHeaders(Headers headers) {
        HashMap<String, List<String>> multimap = new HashMap<String, List<String>>();
        headers.toMultimap().forEach((key, value) -> {
            if (this.sensitiveHeaders.contains(key.toLowerCase(Locale.ROOT))) {
                multimap.put((String)key, Collections.singletonList("********"));
            } else {
                multimap.put((String)key, (List<String>)value);
            }
        });
        return multimap;
    }

    @Generated
    public Set<String> getSensitiveHeaders() {
        return this.sensitiveHeaders;
    }

    @Generated
    public Set<String> getSensitiveBodyKeys() {
        return this.sensitiveBodyKeys;
    }

    @Generated
    public LoggerInterceptor() {
    }

    static {
        TEXT_MEDIA_TYPE.put((Object)"text", (Object)"html");
        TEXT_MEDIA_TYPE.put((Object)"text", (Object)"plain");
        TEXT_MEDIA_TYPE.put((Object)"text", (Object)"xml");
        TEXT_MEDIA_TYPE.put((Object)"application", (Object)"html");
        TEXT_MEDIA_TYPE.put((Object)"application", (Object)"json");
        TEXT_MEDIA_TYPE.put((Object)"application", (Object)"xhtml+xml");
    }
}

