/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.http.fc;

import com.huawei.yinglong.river.sitedeployment.dcs.http.HttpRequestApiFactory;
import com.huawei.yinglong.river.sitedeployment.dcs.http.fc.FcRequestApi;
import com.huawei.yinglong.river.sitedeployment.dcs.http.fc.entry.LoginUser;
import com.huawei.yinglong.river.sitedeployment.dcs.http.fc.entry.VerifySwitch;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

public class FcRequestClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FcRequestClient.class);
    private String token = null;
    private String setCookie = null;
    private final LoginUser loginUser = new LoginUser();
    private final FcRequestApi requestApi;

    public FcRequestClient(String ip, String userName, String userPwd) {
        this.loginUser.setAuthUser(userName);
        this.loginUser.setAuthKey(userPwd);
        String url = StringUtils.formatTxt("https://%s:8443", ip);
        this.requestApi = HttpRequestApiFactory.createRequestApi(url, FcRequestApi.class, null);
    }

    public boolean checkPortalStatus() {
        try {
            Response response = this.requestApi.checkPortalStatus().execute();
            return response.isSuccessful();
        }
        catch (IOException e) {
            log.error("request portal failed.", (Throwable)e);
            return false;
        }
    }

    public boolean login() {
        try {
            Response response = this.requestApi.login(this.createBasicHeaders(), this.loginUser).execute();
            if (response.isSuccessful() && response.body() != null) {
                this.token = response.headers().get("csrftoken");
                this.setCookie = response.headers().get("set-cookie");
                return StringUtils.isNotEmpty(this.token) && StringUtils.isNotEmpty(this.setCookie);
            }
        }
        catch (IOException e) {
            log.error("login fusion compute failed.", (Throwable)e);
        }
        return false;
    }

    public boolean checkLoginStatus() {
        if (StringUtils.isEmpty(this.token) || StringUtils.isEmpty(this.setCookie)) {
            log.error("check login status but token or sessionId is empty.");
            return false;
        }
        try {
            Response response = this.requestApi.checkLogin(this.createRequestHeaders()).execute();
            if (response.isSuccessful() && response.body() != null) {
                return !((Map)response.body()).containsKey("errorCode");
            }
        }
        catch (IOException e) {
            log.error("check login status failed.", (Throwable)e);
        }
        return false;
    }

    public boolean setAccountIsolationSwitch(boolean switchStatus) {
        try {
            if (!this.checkLoginStatus() && !this.login()) {
                log.error("set switch and check not login, try to re login failed.");
                return false;
            }
            VerifySwitch verifySwitch = new VerifySwitch();
            verifySwitch.setVerifySwitch(switchStatus);
            Response response = this.requestApi.changeSwitch(this.createRequestHeaders(), verifySwitch).execute();
            return response.isSuccessful();
        }
        catch (IOException e) {
            log.error("set verify switch failed.", (Throwable)e);
            return false;
        }
    }

    public Optional<VerifySwitch> queryAccountIsolationSwitch() {
        try {
            if (!this.checkLoginStatus() && !this.login()) {
                log.error("query switch and check not login, try to re login failed.");
                return Optional.empty();
            }
            Response response = this.requestApi.querySwitch(this.createRequestHeaders()).execute();
            if (response.isSuccessful() && response.body() != null) {
                return Optional.of(response.body());
            }
        }
        catch (IOException e) {
            log.error("query verify switch failed.", (Throwable)e);
        }
        return Optional.empty();
    }

    private Map<String, String> createBasicHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json;version=8.1;charset=UTF-8");
        headers.put("Accept-Encoding", "gzip, deflate, br");
        headers.put("Content-Type", "application/json; charset=UTF-8");
        return headers;
    }

    private Map<String, String> createRequestHeaders() {
        Map<String, String> headers = this.createBasicHeaders();
        headers.put("CSRF-HW", StringUtils.defaultString(this.token));
        headers.put("Cookie", StringUtils.defaultString(this.setCookie));
        return headers;
    }
}

