/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.ssh;

import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshEndJudge;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSshEndJudge
implements SshEndJudge {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultSshEndJudge.class);
    private static final String FILE_NAME_SSH_END_JUDGE = "ssh_end_judge.txt";
    private static final Set<String> DEFAULT_END_WITHS = new HashSet<String>();

    protected boolean customHandleResult(String cmdRet, String userName) {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isFinish(String cmdRet, String userName) {
        if (StringUtils.isEmpty(cmdRet)) {
            return false;
        }
        String trimCmdRet = cmdRet.trim();
        ArrayList<String> endChars = new ArrayList<String>(DEFAULT_END_WITHS.size() + 1);
        endChars.addAll(DEFAULT_END_WITHS);
        endChars.add(userName + ">");
        if (this.customHandleResult(trimCmdRet, userName)) return true;
        if (!endChars.stream().anyMatch(trimCmdRet::endsWith)) return false;
        return true;
    }

    static {
        ClassLoader classLoader = DefaultSshEndJudge.class.getClassLoader();
        try (InputStream inputStream = classLoader.getResourceAsStream(FILE_NAME_SSH_END_JUDGE);){
            log.info("start to init end judge, is = {}.", (Object)inputStream);
            if (Objects.nonNull(inputStream)) {
                BufferedReader bfReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                DEFAULT_END_WITHS.addAll(bfReader.lines().filter(StringUtils::isNotEmpty).collect(Collectors.toSet()));
                bfReader.close();
                log.info("init default end ssh judge size = {}.", (Object)DEFAULT_END_WITHS.size());
            }
        }
        catch (IOException e) {
            log.error("read ssh end judge file failed.", (Throwable)e);
        }
    }
}

