/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.ssh;

import com.huawei.ism.tool.obase.connection.mina.SshUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshErrorCode;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.KeyboardModifyPwdInteractive;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.PriKeyInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshConnInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshErrParser;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.exception.ErrorKey;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import lombok.Generated;
import org.apache.sshd.client.ClientBuilder;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.auth.keyboard.UserAuthKeyboardInteractiveFactory;
import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.auth.password.UserAuthPasswordFactory;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.keyverifier.AcceptAllServerKeyVerifier;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.BuiltinFactory;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.cipher.BuiltinCiphers;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.future.CancelOption;
import org.apache.sshd.common.signature.BuiltinSignatures;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.core.CoreModuleProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SessionManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SessionManager.class);
    private static final SessionManager MANAGER = new SessionManager();
    private final ConcurrentMap<String, SessionWrapper> cacheSshSessionMaps = new ConcurrentHashMap<String, SessionWrapper>();

    static SessionManager getManager() {
        return MANAGER;
    }

    public ClientSession getSession(SshConnInfo connInfo) throws SshException {
        String key = this.getKey(connInfo);
        SessionWrapper wrapper = (SessionWrapper)this.cacheSshSessionMaps.get(key);
        log.info("get session from cache, key={}, session={}.", (Object)key, (Object)wrapper);
        if (wrapper == null || !wrapper.isConnected()) {
            wrapper = this.createSshSession(connInfo);
            log.info("create session by connect info. session={}.", (Object)wrapper);
            if (wrapper != null && wrapper.isConnected()) {
                this.cacheSshSessionMaps.put(key, wrapper);
            }
        }
        return wrapper.getSession();
    }

    private SessionWrapper createSshSession(SshConnInfo connInfo) throws SshException {
        SessionWrapper wrapper;
        try {
            log.info("try to build session use safe algorithms.");
            wrapper = this.buildSshSession(connInfo, false);
        }
        catch (IOException e) {
            if (!SshErrParser.isSecurityAlgorithmExpired(e.getMessage())) {
                log.error("create ssh session failed, password not correct.");
                throw new SshException((ErrorKey)SshErrorCode.SSH_PASSWORD_NOT_CORRECT, e);
            }
            try {
                log.info("try to build session use unsafe algorithms.");
                wrapper = this.buildSshSession(connInfo, true);
            }
            catch (IOException e1) {
                log.error("create ssh session failed, unsafe algorithms failed.");
                throw new SshException((ErrorKey)SshErrorCode.SSH_CONNECTION_FAILED, e1);
            }
        }
        log.info("create ssh session successfully,session connected={}.", (Object)wrapper.isConnected());
        return wrapper;
    }

    public boolean releaseSession(ClientSession session) {
        try {
            Optional<String> opSessionKey = this.cacheSshSessionMaps.entrySet().stream().filter(entry -> ((SessionWrapper)entry.getValue()).getSession() == session).map(Map.Entry::getKey).findFirst();
            if (opSessionKey.isPresent()) {
                ((SessionWrapper)this.cacheSshSessionMaps.remove(opSessionKey.get())).close();
                return true;
            }
        }
        catch (IOException e) {
            log.error("release session failed.", (Throwable)e);
        }
        return false;
    }

    public boolean releaseSession(SshConnInfo connInfo) {
        if (connInfo == null) {
            log.info("release session conn info is null.");
            return false;
        }
        try {
            SessionWrapper wrapper = (SessionWrapper)this.cacheSshSessionMaps.remove(this.getKey(connInfo));
            if (wrapper != null && wrapper.isConnected()) {
                log.info("try to close session.");
                wrapper.close();
            }
            return wrapper != null;
        }
        catch (IOException e) {
            log.error("release session failed.", (Throwable)e);
            return false;
        }
    }

    private SessionWrapper buildSshSession(SshConnInfo connInfo, boolean isUseUnsafeAlgorithms) throws IOException {
        try {
            PriKeyInfo priKey;
            SshClient sshClient = SshClient.setUpDefaultClient();
            this.removeNoSafeAlgorithm(sshClient);
            sshClient.setServerKeyVerifier((ServerKeyVerifier)AcceptAllServerKeyVerifier.INSTANCE);
            if (isUseUnsafeAlgorithms) {
                sshClient.setCipherFactories(BuiltinFactory.setUpFactories((boolean)true, (Collection)SshUtils.ALL_CIPHER_FACTORY_ALGORITHM));
                sshClient.setMacFactories(BuiltinFactory.setUpFactories((boolean)true, (Collection)SshUtils.ALL_MAC_FACTORY_ALGORITHM));
                sshClient.setSignatureFactories(BuiltinFactory.setUpFactories((boolean)true, (Collection)SshUtils.ALL_SIGNATURE_FACTORY_ALGORITHM));
                sshClient.setKeyExchangeFactories(NamedFactory.setUpTransformedFactories((boolean)true, (Collection)SshUtils.ALL_KEY_EXCHANGE_FACTORY_ALGORITHM, (Function)ClientBuilder.DH2KEX));
            }
            if ((priKey = connInfo.getPriKeyInfo()) == null) {
                ArrayList<Object> userAuthFactories = new ArrayList<Object>();
                userAuthFactories.add(UserAuthPasswordFactory.INSTANCE);
                userAuthFactories.add(UserAuthKeyboardInteractiveFactory.INSTANCE);
                sshClient.setUserAuthFactories(userAuthFactories);
                Optional.ofNullable(connInfo.getNewPwd()).filter(StringUtils::isNotEmpty).ifPresent(newPwd -> sshClient.setUserInteraction((UserInteraction)new KeyboardModifyPwdInteractive(connInfo)));
            }
            sshClient.start();
            ClientSession session = (ClientSession)((ConnectFuture)sshClient.connect(connInfo.getUserName(), connInfo.getHostName(), connInfo.getPort()).verify((long)connInfo.getSessionTimeoutMs(), new CancelOption[0])).getSession();
            if (priKey == null) {
                session.addPasswordIdentity(connInfo.getUserPwd());
                Optional.ofNullable(connInfo.getNewPwd()).filter(StringUtils::isNotEmpty).ifPresent(arg_0 -> ((ClientSession)session).addPasswordIdentity(arg_0));
            } else {
                Collection keyPairs = SecurityUtils.getKeyPairResourceParser().loadKeyPairs(null, Paths.get(priKey.getKeyPath(), new String[0]), FilePasswordProvider.of((String)priKey.getKeyPwd()), new OpenOption[0]);
                keyPairs.forEach(arg_0 -> ((ClientSession)session).addPublicKeyIdentity(arg_0));
            }
            CoreModuleProperties.PASSWORD_PROMPTS.set((PropertyResolver)session, (Object)4);
            session.auth().verify((long)connInfo.getSessionTimeoutMs(), new CancelOption[0]);
            log.info("prepare to connect session, timeoutMs={}.", (Object)connInfo.getSessionTimeoutMs());
            return new SessionWrapper(sshClient, session);
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }

    private void removeNoSafeAlgorithm(SshClient client) {
        client.getCipherFactories().remove(BuiltinCiphers.aes128cbc);
        client.getCipherFactories().remove(BuiltinCiphers.aes192cbc);
        client.getCipherFactories().remove(BuiltinCiphers.aes256cbc);
        client.getSignatureFactories().remove(BuiltinSignatures.rsa);
    }

    private String getKey(SshConnInfo connInfo) {
        return StringUtils.formatTxt("%s_%s_%d", connInfo.getHostName(), connInfo.getUserName(), connInfo.getPort());
    }

    @Generated
    private SessionManager() {
    }

    private static final class SessionWrapper {
        private SshClient sshClient;
        private ClientSession session;

        private boolean isConnected() {
            return this.session != null && this.session.isOpen();
        }

        private void close() throws IOException {
            if (this.session != null && this.session.isOpen()) {
                log.info("prepare to close session...");
                this.session.close();
            }
            if (this.sshClient != null && this.sshClient.isOpen()) {
                log.info("prepare to close ssh client...");
                this.sshClient.close();
            }
        }

        @Generated
        public SshClient getSshClient() {
            return this.sshClient;
        }

        @Generated
        public ClientSession getSession() {
            return this.session;
        }

        @Generated
        public String toString() {
            return "SessionManager.SessionWrapper(sshClient=" + this.getSshClient() + ", session=" + this.getSession() + ")";
        }

        @Generated
        public SessionWrapper(SshClient sshClient, ClientSession session) {
            this.sshClient = sshClient;
            this.session = session;
        }
    }
}

