/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.ssh;

import java.util.Arrays;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public final class SshErrParser {
    private static final String PWD_EXPIRED_CLI_RETURN = "The password has expired. Please change the password and log in to the system using the new password.";
    private static final String PWD_WILL_EXPIRE_CLI_RETURN = "The password is about to expire. Change the password immediately?(y/n)";
    private static final String INITPWD_NOT_CHANGE_CLI_RETURN = "For security purposes, please change the initial password and log in to the system using the new password.";
    private static final String SECURITY_ALGORITHM_ERR_RETURN = "Algorithm negotiation fail";
    private static final String PWD_UNSAFE_CLI_RETURN = "For account security, change the password and relog in to the system.";
    private static final String USER_REACHE_UPLIMIT = "The number of users has reached the upper limit.";
    private static final String USER_REACHE_IPLIMIT_KUNPENG = "The number of users that log in through the CLI has reached the upper limit";
    private static final String USER_REACHE_UPLIMIT_MEMEROY = "the number of users that log in through the CLI reaches";
    private static final String LOGINCLIS_OVERRUN_LOWER_CLI_RETURN = "Quit one or more logged-in CLIs, or release some memory space and try again later.";
    private static final String LOGINCLIS_OVERRUN_OUTSVP_CLI_RETURN_PRE = "There are more than ";
    private static final String LOGINCLIS_OVERRUN_OUTSVP_CLI_RETURN_POST = "processes of ismcli in system, do not run CLI. Please try again later.";
    private static final String[] INVALID_COMMAND_RESULTS = new String[]{"command not found", "not exist", "not supported", "command name is invalid", "No such file or directory", "cat: ", "invalid option", "cannot open", "is a directory", "not found", "usage:", "command-not-found", "permission denied", "\u5931\u8d25", "\u5f02\u5e38", "error", "extract file failed", "cannot find", "cannot stat"};

    public static boolean isInitPwdNotChanged(String text) {
        return text.contains(INITPWD_NOT_CHANGE_CLI_RETURN);
    }

    public static boolean isPwdWillExpire(String text) {
        return text.contains(PWD_WILL_EXPIRE_CLI_RETURN);
    }

    public static boolean isPwdExpired(String text) {
        return text.contains(PWD_EXPIRED_CLI_RETURN);
    }

    public static boolean isSecurityAlgorithmExpired(String errorMsg) {
        return errorMsg.contains(SECURITY_ALGORITHM_ERR_RETURN);
    }

    public static boolean isLoginCLIsOverrun(String result) {
        if (result.contains(LOGINCLIS_OVERRUN_OUTSVP_CLI_RETURN_PRE) && result.contains(LOGINCLIS_OVERRUN_OUTSVP_CLI_RETURN_POST)) {
            return true;
        }
        return result.contains(LOGINCLIS_OVERRUN_LOWER_CLI_RETURN) || result.contains(USER_REACHE_UPLIMIT) || result.contains(USER_REACHE_UPLIMIT_MEMEROY) || result.contains(USER_REACHE_IPLIMIT_KUNPENG);
    }

    public static boolean isPwdUnSafe(String result) {
        return StringUtils.isNotEmpty((CharSequence)result) && result.contains(PWD_UNSAFE_CLI_RETURN);
    }

    public static boolean isInvalidResult(String cmdResult) {
        return Arrays.stream(INVALID_COMMAND_RESULTS).anyMatch(cmdResult::contains);
    }

    @Generated
    private SshErrParser() {
    }
}

