/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.ssh;

import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshErrorCode;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SftpProgCallback;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshSftpService;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.exception.ErrorKey;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.SftpClientFactory;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshSftpServiceImpl
implements SshSftpService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SshSftpServiceImpl.class);
    private static final Collection<SftpClient.OpenMode> uploadOpenModes = EnumSet.of(SftpClient.OpenMode.Create, SftpClient.OpenMode.Write, SftpClient.OpenMode.Truncate);
    private final ClientSession session;
    private SftpClient channelSftp;

    private SshSftpServiceImpl(ClientSession session) {
        this.session = session;
    }

    static SshSftpService createSshSftpService(ClientSession session) {
        return new SshSftpServiceImpl(session);
    }

    @Override
    public void connect(int timeoutMs) throws SshException {
        try {
            if (this.isConnected()) {
                log.info("!!!SFTP has connected.");
                return;
            }
            this.channelSftp = SftpClientFactory.instance().createSftpClient(this.session);
            this.channelSftp.setNameDecodingCharset(StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new SshException((ErrorKey)SshErrorCode.SFTP_CONNECTION_FAILED, e);
        }
    }

    @Override
    public void connect() throws SshException {
        this.connect(60000);
    }

    @Override
    public boolean isConnected() {
        return this.channelSftp != null && this.channelSftp.isOpen();
    }

    @Override
    public List<String> ls(String path) throws SshException {
        LinkedList<String> list = new LinkedList<String>();
        try {
            if (this.isConnected()) {
                Iterable dirEntries = this.channelSftp.listDir((SftpClient.Handle)this.channelSftp.openDir(path));
                dirEntries.forEach(dirEntry -> list.add(dirEntry.getFilename()));
            }
        }
        catch (IOException e) {
            throw new SshException(SshErrorCode.SFTP_COMMAND_FAILED, e, Collections.singletonList("ls-path"));
        }
        return list;
    }

    @Override
    public void mkdir(String path) throws SshException {
        try {
            if (StringUtils.isNotEmpty(path) && this.isConnected()) {
                this.channelSftp.mkdir(path);
            }
        }
        catch (IOException e) {
            throw new SshException(SshErrorCode.SFTP_COMMAND_FAILED, e, Collections.singletonList("mkdir"));
        }
    }

    @Override
    public void rmdir(String path) throws SshException {
        try {
            if (StringUtils.isNotEmpty(path) && this.isConnected()) {
                this.channelSftp.rmdir(path);
            }
        }
        catch (IOException e) {
            throw new SshException(SshErrorCode.SFTP_COMMAND_FAILED, e, Collections.singletonList("rmdir"));
        }
    }

    @Override
    public void rm(String file) throws SshException {
        try {
            if (StringUtils.isNotEmpty(file) && this.isConnected()) {
                this.channelSftp.remove(file);
            }
        }
        catch (IOException e) {
            throw new SshException(SshErrorCode.SFTP_COMMAND_FAILED, e, Collections.singletonList("rm"));
        }
    }

    @Override
    public void chmod(int permission, String path) throws SshException {
        try {
            if (StringUtils.isNotEmpty(path) && this.isConnected()) {
                SftpClient.Attributes attributes = this.channelSftp.lstat(path);
                attributes.setPermissions(permission);
            }
        }
        catch (IOException e) {
            throw new SshException(SshErrorCode.SFTP_COMMAND_FAILED, e, Collections.singletonList("chmod"));
        }
    }

    @Override
    public void chown(String user, String path) throws SshException {
        try {
            if (StringUtils.isNotEmpty(path) && this.isConnected()) {
                SftpClient.Attributes attributes = this.channelSftp.lstat(path);
                attributes.setOwner(user);
            }
        }
        catch (IOException e) {
            throw new SshException(SshErrorCode.SFTP_COMMAND_FAILED, e, Collections.singletonList("chown"));
        }
    }

    @Override
    public void chgrp(String group, String path) throws SshException {
        try {
            if (StringUtils.isNotEmpty(path) && this.isConnected()) {
                SftpClient.Attributes attributes = this.channelSftp.lstat(path);
                attributes.setGroup(group);
            }
        }
        catch (IOException e) {
            throw new SshException(SshErrorCode.SFTP_COMMAND_FAILED, e, Collections.singletonList("chgrp"));
        }
    }

    private boolean checkFileIsDirectory(String dstFile) {
        try {
            return this.channelSftp.lstat(dstFile).isDirectory();
        }
        catch (IOException e) {
            log.warn("check directory failed, file not exist.");
            return false;
        }
    }

    @Override
    public boolean upload(String srcFile, String dstFile, SftpProgCallback monitor) throws SshException {
        if (StringUtils.isEmpty(srcFile) || StringUtils.isEmpty(dstFile)) {
            return false;
        }
        return this.upload(new File(srcFile), dstFile, monitor);
    }

    @Override
    public boolean upload(@NotNull File file, String dstFile, SftpProgCallback monitor) throws SshException {
        if (!file.exists() || !this.isConnected()) {
            return false;
        }
        try {
            String remoteFile = dstFile;
            if (this.checkFileIsDirectory(dstFile)) {
                remoteFile = FilePathValidatorUtils.createLinuxPaths(dstFile, file.getName());
            }
            OutputStream outputStream = this.channelSftp.write(remoteFile, uploadOpenModes);
            monitor.start();
            Files.copy(file.toPath(), outputStream);
            outputStream.close();
            monitor.finish();
            return true;
        }
        catch (IOException e) {
            throw new SshException(SshErrorCode.SFTP_COMMAND_FAILED, e, Collections.singletonList("upload"));
        }
    }

    @Override
    public boolean upload(InputStream is, String dstFile, SftpProgCallback monitor) throws SshException {
        block14: {
            try {
                if (is == null || !StringUtils.isNotEmpty(dstFile) || !this.isConnected()) break block14;
                try (OutputStream outputStream = this.channelSftp.write(dstFile, uploadOpenModes);){
                    monitor.start();
                    this.copyStreams(is, outputStream);
                    monitor.finish();
                }
                return true;
            }
            catch (IOException e) {
                throw new SshException(SshErrorCode.SFTP_COMMAND_FAILED, e, Collections.singletonList("pwd"));
            }
        }
        return false;
    }

    @Override
    public boolean download(String srcFile, String dstFile, SftpProgCallback monitor) throws SshException {
        block14: {
            try {
                if (!StringUtils.isNotEmpty(srcFile) || !StringUtils.isNotEmpty(dstFile) || !this.isConnected()) break block14;
                try (InputStream inputStream = this.channelSftp.read(srcFile);){
                    monitor.start();
                    Files.copy(inputStream, Paths.get(dstFile, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                    monitor.finish();
                }
                return true;
            }
            catch (IOException e) {
                throw new SshException(SshErrorCode.SFTP_COMMAND_FAILED, e, Collections.singletonList("download"));
            }
        }
        return false;
    }

    @Override
    public boolean download(String srcFile, OutputStream os, SftpProgCallback monitor) throws SshException {
        block14: {
            try {
                if (!StringUtils.isNotEmpty(srcFile) || os == null || !this.isConnected()) break block14;
                try (InputStream inputStream = this.channelSftp.read(srcFile);){
                    monitor.start();
                    this.copyStreams(inputStream, os);
                    monitor.finish();
                }
                return true;
            }
            catch (IOException e) {
                throw new SshException(SshErrorCode.SFTP_COMMAND_FAILED, e, Collections.singletonList("download"));
            }
        }
        return false;
    }

    private void copyStreams(InputStream is, OutputStream os) throws IOException {
        int len;
        byte[] buffer = new byte[4096];
        while ((len = is.read(buffer)) != -1) {
            os.write(buffer, 0, len);
        }
        os.flush();
    }

    @Override
    public void disconnect() {
        try {
            log.info("prepare to disconnect sftp.");
            if (this.isConnected()) {
                log.info("disconnect sftp finish.");
                this.channelSftp.close();
                this.channelSftp = null;
            }
        }
        catch (IOException e) {
            log.error("close channel sftp failed.", (Throwable)e);
        }
    }

    @Override
    public void close() throws Exception {
        log.info("prepare to close sftp.");
        this.disconnect();
    }
}

