/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.ssh;

import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshErrorCode;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.DefaultSshEndJudge;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshEndJudge;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshErrParser;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StreamUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.exception.ErrorKey;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.future.CancelOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshShellServiceImpl
implements SshShellService,
Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SshShellServiceImpl.class);
    private static final int DELAY_READ_BYTE_MS = 200;
    private static final int LINUX_PROCESS_KILL_CMD = 3;
    private static final int DEFAULT_SEND_COMMAND_TIMEOUT = 90;
    private static final int DEFAULT_RETRY_COUNT_TIMES = 3;
    private static final char CHAR_BACKUP = '\b';
    private static final Object LOCK = new Object();
    private final ByteArrayOutputStream stdBaos = new ByteArrayOutputStream();
    private final ByteArrayOutputStream errBaos = new ByteArrayOutputStream();
    private final DefaultSshEndJudge defaultEndJudge = new DefaultSshEndJudge();
    private final ClientSession session;
    private ChannelShell channelShell;
    private OutputStream outStream;
    private InputStream stdStream;
    private InputStream errStream;
    private boolean isActive;

    private SshShellServiceImpl(ClientSession session) {
        this.session = session;
    }

    static SshShellService createSshShellService(ClientSession session) {
        return new SshShellServiceImpl(session);
    }

    @Override
    public void connect(int timeoutMs) throws SshException {
        try {
            if (this.isConnected()) {
                log.info("!!!SSH has connected.");
                return;
            }
            log.info("prepare to connect ssh, timeout : {}.", (Object)timeoutMs);
            this.channelShell = this.session.createShellChannel();
            this.channelShell.setPtyType("bash");
            this.channelShell.setPtyLines(Integer.MAX_VALUE);
            this.channelShell.setPtyColumns(Integer.MAX_VALUE);
            this.channelShell.setUsePty(true);
            this.channelShell.open().verify((long)timeoutMs, new CancelOption[0]);
            this.outStream = this.channelShell.getInvertedIn();
            this.stdStream = this.channelShell.getInvertedOut();
            this.errStream = this.channelShell.getInvertedErr();
            this.isActive = true;
            log.info("connect ssh finish, timeout : {}.", (Object)timeoutMs);
            ThreadUtils.execute(this);
        }
        catch (IOException e) {
            throw new SshException((ErrorKey)SshErrorCode.SSH_CONNECTION_FAILED, e);
        }
    }

    @Override
    public void connect() throws SshException {
        this.connect(60000);
    }

    @Override
    public boolean isConnected() {
        return this.channelShell != null && this.channelShell.isOpen();
    }

    @Override
    public boolean changeRootPermission(String rootPwd) throws SshException {
        String result = this.execCommand("su");
        log.info("switch user to root result = {}.", (Object)result);
        if (result.contains("Password:")) {
            result = this.execCommand(rootPwd);
            log.info("input root text, result={}.", (Object)result.replace(rootPwd, "******"));
        }
        return result.trim().endsWith("#");
    }

    @Override
    public String execCommand(String command, SshEndJudge judge) throws SshException {
        return this.execCommandWithTimeout(command, 90, judge);
    }

    @Override
    public String execCommand(String command) throws SshException {
        return this.execCommand(command, this.defaultEndJudge);
    }

    @Override
    public boolean execCommandWithoutReturn(String command) throws SshException {
        try {
            if (!this.isConnected()) {
                log.warn("execute command without return disconnected.");
                return false;
            }
            this.doSendCommand(command);
            return true;
        }
        catch (IOException e) {
            throw new SshException((ErrorKey)SshErrorCode.SHELL_CONNECTION_FAILED, e);
        }
    }

    private String execCommandWithTimeoutRetryTimes(String command, int timeout, boolean isThrowException, SshEndJudge judge, boolean timeoutCtrlC) throws SshException {
        block4: {
            WaitForResultTask resultTask = null;
            try {
                this.doSendCommand(command);
                resultTask = new WaitForResultTask(judge, timeoutCtrlC);
                return resultTask.start(timeout);
            }
            catch (TimeoutException e) {
                resultTask.stop(isThrowException);
                log.warn("execute command get result timeout, isThrowException : {}.", (Object)isThrowException, (Object)e);
                if (isThrowException) {
                    throw new SshException((ErrorKey)SshErrorCode.SSH_NETWORK_TIMEOUT, e);
                }
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                Optional.ofNullable(resultTask).ifPresent(task -> ((WaitForResultTask)task).stop(isThrowException));
                log.warn("execute command get result exception, isThrowException : {}.", (Object)isThrowException, (Object)e);
                if (!isThrowException) break block4;
                throw new SshException((ErrorKey)SshErrorCode.SHELL_CONNECTION_FAILED, e);
            }
        }
        return "";
    }

    @Override
    public String execCommandWithTimeout(String command, int timeout, SshEndJudge judge) throws SshException {
        return this.execCommandWithTimeout(command, timeout, judge, true);
    }

    @Override
    public String execCommandWithTimeout(String command, int timeout, SshEndJudge judge, boolean timeoutCtrlC) throws SshException {
        if (!this.isConnected()) {
            log.warn("execute command with timeout disconnected.");
            return "";
        }
        int retryTimes = 1;
        do {
            String result;
            if (StringUtils.isNotEmpty(result = this.execCommandWithTimeoutRetryTimes(command, timeout, false, judge, timeoutCtrlC))) {
                return result;
            }
            log.warn("retry to send command, retryTimes = {}.", (Object)retryTimes);
        } while (++retryTimes < 3);
        return this.execCommandWithTimeoutRetryTimes(command, timeout, true, judge, timeoutCtrlC);
    }

    @Override
    public String execCommandWithTimeout(String command, int timeout) throws SshException {
        return this.execCommandWithTimeout(command, timeout, this.defaultEndJudge, true);
    }

    @Override
    public String execCommandWithTimeout(String command, int timeout, boolean timeoutCtrlC) throws SshException {
        return this.execCommandWithTimeout(command, timeout, this.defaultEndJudge, timeoutCtrlC);
    }

    @Override
    public String readCommandReturnText(boolean isReadError) {
        if (isReadError) {
            return this.getErrResult();
        }
        return this.getStdResult();
    }

    @Override
    public void disconnect() {
        try {
            log.info("prepare to disconnect SSH.");
            this.tryToStopCmd();
            StreamUtils.closeStream(this.outStream);
            StreamUtils.closeStream(this.stdStream);
            StreamUtils.closeStream(this.errStream);
            if (this.channelShell != null) {
                this.channelShell.close();
            }
            this.channelShell = null;
            this.isActive = false;
        }
        catch (IOException e) {
            log.error("disconnect failed.", (Throwable)e);
        }
    }

    private void tryToStopCmd() {
        try {
            this.execCommandWithoutReturn(CTRL_C);
            ThreadUtils.threadSafeSleep(100, TimeUnit.MILLISECONDS);
            log.info("try to stop cmd finish.");
        }
        catch (SshException e) {
            log.warn("try to stop command(CTRL+C).");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.isActive && this.channelShell != null) {
            try {
                if (this.channelShell.isClosed() || this.channelShell.isClosing()) {
                    this.isActive = false;
                    this.channelShell.close();
                    log.error("read command result but ssh closed..");
                    break;
                }
                byte[] stdBytes = this.readByteFromInputStream(this.stdStream);
                byte[] errBytes = this.readByteFromInputStream(this.errStream);
                if (stdBytes.length <= 0 && errBytes.length <= 0) {
                    ThreadUtils.threadSafeSleep(200, TimeUnit.MILLISECONDS);
                    continue;
                }
                Object object = LOCK;
                synchronized (object) {
                    this.stdBaos.write(stdBytes);
                    this.errBaos.write(errBytes);
                }
            }
            catch (IOException e) {
                log.error("ssh read stdout / stderr failed...", (Throwable)e);
            }
        }
    }

    @Override
    public void close() throws Exception {
        log.info("prepare to close ssh.");
        this.disconnect();
    }

    private void doSendCommand(String command) throws IOException {
        this.clearStdFlush();
        this.clearErrFlush();
        this.outStream.write(command.getBytes(StandardCharsets.UTF_8));
        this.outStream.write(10);
        this.outStream.flush();
    }

    private void doSendCommand(int command) throws IOException {
        this.clearStdFlush();
        this.clearErrFlush();
        this.outStream.write(command);
        this.outStream.flush();
    }

    private boolean checkCommandResultFinish(String result, SshEndJudge judge) {
        String clearResult = StringUtils.clearResultColorCode(result);
        if (this.isCommandFinished(clearResult, judge)) {
            this.clearStdFlush();
            return true;
        }
        return false;
    }

    private void handleLastTimeoutCheck(SshEndJudge judge) throws SshException {
        try {
            log.info("start to send process kill cmd(ctrl + c).");
            this.doSendCommand(3);
            for (int idx = 0; idx < 100; ++idx) {
                if (this.isCommandFinished(this.getStdResult(), judge)) {
                    this.clearStdFlush();
                    log.error("check ctrl + c has finish.");
                    break;
                }
                ThreadUtils.threadSafeSleep(200, TimeUnit.MILLISECONDS);
            }
        }
        catch (IOException e) {
            log.error("send cmd ctrl + c failed.", (Throwable)e);
            throw new SshException((ErrorKey)SshErrorCode.SHELL_CONNECTION_FAILED, e);
        }
    }

    private boolean isCommandFinished(String result, SshEndJudge judge) {
        return judge.isFinish(result, this.session.getUsername());
    }

    private void checkPasswordError(String result) throws SshException {
        if (SshErrParser.isLoginCLIsOverrun(result)) {
            this.disconnect();
            log.error("ssh shell login cli is over run!.");
            throw new SshException(SshErrorCode.SHELL_CLI_OVERLOAD);
        }
        if (SshErrParser.isInitPwdNotChanged(result)) {
            log.error("ssh shell init pwd not changed!");
            throw new SshException(SshErrorCode.SSH_PASSWORD_NOT_INIT);
        }
        if (SshErrParser.isPwdExpired(result)) {
            log.error("ssh shell pwd expired!.");
            throw new SshException(SshErrorCode.SSH_PASSWORD_HAS_EXPIRED);
        }
        if (SshErrParser.isPwdUnSafe(result)) {
            log.error("ssh shell pwd unsafe!.");
            throw new SshException(SshErrorCode.SSH_PASSWORD_IS_UNSAFE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStdResult() {
        Object object = LOCK;
        synchronized (object) {
            String result = "";
            try {
                result = this.stdBaos.toString(StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                log.error("Unsupported format", (Throwable)e);
            }
            result = this.clearBackChar(result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearStdFlush() {
        Object object = LOCK;
        synchronized (object) {
            this.stdBaos.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getErrResult() {
        Object object = LOCK;
        synchronized (object) {
            String result = this.errBaos.toString();
            result = this.clearBackChar(result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearErrFlush() {
        Object object = LOCK;
        synchronized (object) {
            this.errBaos.reset();
        }
    }

    private String clearBackChar(String result) {
        if (result.indexOf(8) < 0) {
            return result;
        }
        StringBuilder sBuilder = new StringBuilder(result);
        for (int i = 0; i < sBuilder.length(); ++i) {
            if (sBuilder.charAt(i) != '\b') continue;
            sBuilder.deleteCharAt(i--);
            if (i < 0) continue;
            sBuilder.deleteCharAt(i--);
        }
        return sBuilder.toString();
    }

    private byte[] readByteFromInputStream(InputStream is) throws IOException {
        int available;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((available = is.available()) > 0) {
            byte[] buffer = new byte[available];
            int len = is.read(buffer);
            baos.write(buffer, 0, len);
            ThreadUtils.threadSafeSleep(200, TimeUnit.MILLISECONDS);
        }
        return baos.toByteArray();
    }

    private class WaitForResultTask
    implements Callable<String> {
        private final SshEndJudge endJudge;
        private final boolean timeoutCtrlC;
        private volatile boolean isRun = true;
        private volatile boolean isLastRetry = false;
        private Future<String> future;

        private WaitForResultTask(SshEndJudge judge, boolean timeoutCtrlC) {
            this.endJudge = judge;
            this.timeoutCtrlC = timeoutCtrlC;
        }

        private String start(int timeout) throws ExecutionException, InterruptedException, TimeoutException {
            this.isRun = true;
            this.future = ThreadUtils.submit(this);
            return this.future.get(timeout, TimeUnit.SECONDS);
        }

        private void stop(boolean isLastRetry) {
            this.isLastRetry = isLastRetry;
            this.isRun = false;
            if (this.future != null) {
                this.future.cancel(true);
            }
        }

        @Override
        public String call() throws Exception {
            while (this.isRun) {
                if (!SshShellServiceImpl.this.isConnected()) {
                    log.error("WaitForResultTask disconnected.");
                    throw new SshException(SshErrorCode.SHELL_CONNECTION_DISCONNECT);
                }
                String result = SshShellServiceImpl.this.getStdResult();
                SshShellServiceImpl.this.checkPasswordError(result);
                if (SshShellServiceImpl.this.checkCommandResultFinish(result, this.endJudge)) {
                    return result;
                }
                ThreadUtils.threadSafeSleep(200, TimeUnit.MILLISECONDS);
            }
            log.error("timeout for read shell command result, isLastRetry:{}, timeoutCtrlC:{}, std:{}, err:{}.", new Object[]{this.isLastRetry, this.timeoutCtrlC, SshShellServiceImpl.this.getStdResult(), SshShellServiceImpl.this.getErrResult()});
            if (this.isLastRetry && this.timeoutCtrlC) {
                SshShellServiceImpl.this.handleLastTimeoutCheck(this.endJudge);
            }
            return "";
        }
    }
}

