/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.task;

import com.huawei.yinglong.river.sitedeployment.dcs.constant.TaskOperateEnum;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTaskResult;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskException;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskStatus;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTask
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseTask.class);
    private static final int MAX_DETAIL_TEXT_SIZE = 4000;
    @NotNull
    private final String taskId;
    private String globalTaskId;
    private int duration;
    private boolean isExecuteSubTasks;
    private boolean isRetryUpdateStartTime;
    private String taskName;
    private String taskDescription;
    private String eventType;
    private BaseTaskResult taskResult;
    private List<TaskOperateEnum> supportOperates;
    private String skipMsg;
    private List<BaseTask> subTasks;

    public void beforeExecute() {
    }

    public void afterExecute() {
    }

    public abstract void execute() throws TaskException;

    @Override
    public void run() {
        try {
            log.info("execute task [{}]", (Object)this.taskName);
            this.runTask();
        }
        catch (Exception exception) {
            log.error("execute task [{}] failed,error message [{}]", new Object[]{this.taskName, exception.getMessage(), exception});
        }
    }

    public boolean canStart() {
        return TaskStatus.canStartStatus(this.taskResult.getTaskStatus());
    }

    public boolean isRunning() {
        return this.taskResult.getTaskStatus() == TaskStatus.RUNNING;
    }

    public boolean isFinish() {
        return TaskStatus.isFinishStatus(this.taskResult.getTaskStatus());
    }

    public boolean isSuccess() {
        return TaskStatus.isSuccessStatus(this.taskResult.getTaskStatus());
    }

    public boolean isErrorOrPaused() {
        return TaskStatus.isErrorOrPaused(this.taskResult.getTaskStatus());
    }

    private void runTask() throws TaskException {
        if (this.taskResult.getTaskStatus() == TaskStatus.SKIP) {
            log.info("current task [{}] is skip", (Object)this.taskName);
            this.taskResult.setEndTime(LocalDateTime.now());
            return;
        }
        if (this.isFinish()) {
            log.info("task [{}] last run status is [{}] and no need execute when retry", (Object)this.taskName, (Object)this.taskResult.getTaskStatus().name());
            return;
        }
        this.taskResult.setTaskStatus(TaskStatus.RUNNING);
        if (Objects.isNull(this.taskResult.getStartTime()) || this.isRetryUpdateStartTime) {
            this.taskResult.setStartTime(LocalDateTime.now());
        }
        try {
            this.beforeExecute();
            if (!this.isExecuteSubTasks || CollectionUtils.isEmpty(this.subTasks)) {
                log.info("current task [{}] has no sub task", (Object)this.taskName);
                this.execute();
            } else {
                this.runSubTasks();
            }
            this.taskResult.setTaskStatus(TaskStatus.END);
        }
        catch (TaskException exception) {
            log.error("current task [{}] failed,error message:[{}]", new Object[]{this.taskName, exception.getErrorMessage(), exception});
            this.taskResult.setTaskStatus(exception.getTaskStatus());
            this.taskResult.setErrorMessage(exception.getErrorMessage());
            this.taskResult.setSuggestion(exception.getSuggestMessage());
            throw exception;
        }
        catch (Exception e) {
            log.error("current task [{}] runTask failed,error message:[{}]", new Object[]{this.taskName, e.getMessage(), e});
            this.taskResult.setTaskStatus(TaskStatus.ERROR);
            this.taskResult.setErrorMessage("Unknown system exception.");
            this.taskResult.setSuggestion("Contact R&D engineers.");
            throw e;
        }
        finally {
            this.taskResult.setEndTime(LocalDateTime.now());
            this.afterExecute();
        }
    }

    private void runSubTasks() {
        for (BaseTask task : this.subTasks) {
            if (task.getTaskResult().getTaskStatus() == TaskStatus.END) {
                log.info("current sub task [{}] is finished,continue next sub task", (Object)task.taskName);
                continue;
            }
            task.runTask();
        }
    }

    protected boolean setTaskSkip() {
        return this.setTaskRetryOrSkip(TaskOperateEnum.SKIP, TaskStatus.SKIP);
    }

    protected boolean setTaskRetry() {
        boolean isSuccess = this.setTaskRetryOrSkip(TaskOperateEnum.RETRY, TaskStatus.NOT_START);
        if (isSuccess) {
            this.taskResult.setEndTime(TaskStatus.END.equals((Object)this.taskResult.getTaskStatus()) || TaskStatus.SKIP.equals((Object)this.taskResult.getTaskStatus()) ? this.taskResult.getEndTime() : null);
            this.taskResult.setDetail(new StringBuilder());
            this.taskResult.setSuggestion("");
            this.taskResult.setErrorMessage("");
        }
        return isSuccess;
    }

    private boolean setTaskRetryOrSkip(TaskOperateEnum operateEnum, TaskStatus taskStatus) {
        if (TaskStatus.isTaskInRetryStatus(this.taskResult.getTaskStatus())) {
            log.info("set {} status to {}", (Object)operateEnum.name(), (Object)this.taskName);
            this.taskResult.setTaskStatus(taskStatus);
            return true;
        }
        log.info("{} taskStatus is {},do not need set status", (Object)this.taskName, (Object)this.taskResult.getTaskStatus().name());
        return true;
    }

    protected void setTaskStatus(TaskStatus taskStatus) {
        this.taskResult.setTaskStatus(taskStatus);
    }

    public void clearTaskResult() {
        this.taskResult = new BaseTaskResult();
    }

    protected void appendTaskDetail(String detail) {
        if (StringUtils.isEmpty(detail)) {
            return;
        }
        String addDetail = detail;
        if (detail.length() > 4000) {
            addDetail = detail.substring(0, 4000) + "...";
            log.warn("detail has overload max size.");
        }
        this.taskResult.getDetail().append(addDetail).append(System.lineSeparator());
    }

    public String getDetail() {
        String detail = this.getTaskResult().getDetail().toString();
        return StringUtils.isEmpty(this.taskDescription) ? detail : this.taskDescription.concat(System.lineSeparator()).concat(detail);
    }

    @Generated
    private static String $default$taskId() {
        return UUID.randomUUID().toString();
    }

    @Generated
    private static boolean $default$isExecuteSubTasks() {
        return true;
    }

    @Generated
    private static boolean $default$isRetryUpdateStartTime() {
        return true;
    }

    @Generated
    private static BaseTaskResult $default$taskResult() {
        return new BaseTaskResult();
    }

    @Generated
    protected BaseTask(BaseTaskBuilder<?, ?> b) {
        this.taskId = ((BaseTaskBuilder)b).taskId$set ? ((BaseTaskBuilder)b).taskId$value : BaseTask.$default$taskId();
        if (this.taskId == null) {
            throw new NullPointerException("taskId is marked non-null but is null");
        }
        this.globalTaskId = ((BaseTaskBuilder)b).globalTaskId;
        this.duration = ((BaseTaskBuilder)b).duration;
        this.isExecuteSubTasks = ((BaseTaskBuilder)b).isExecuteSubTasks$set ? ((BaseTaskBuilder)b).isExecuteSubTasks$value : BaseTask.$default$isExecuteSubTasks();
        this.isRetryUpdateStartTime = ((BaseTaskBuilder)b).isRetryUpdateStartTime$set ? ((BaseTaskBuilder)b).isRetryUpdateStartTime$value : BaseTask.$default$isRetryUpdateStartTime();
        this.taskName = ((BaseTaskBuilder)b).taskName;
        this.taskDescription = ((BaseTaskBuilder)b).taskDescription;
        this.eventType = ((BaseTaskBuilder)b).eventType;
        this.taskResult = ((BaseTaskBuilder)b).taskResult$set ? ((BaseTaskBuilder)b).taskResult$value : BaseTask.$default$taskResult();
        this.supportOperates = ((BaseTaskBuilder)b).supportOperates;
        this.skipMsg = ((BaseTaskBuilder)b).skipMsg;
        this.subTasks = ((BaseTaskBuilder)b).subTasks;
    }

    @NotNull
    @Generated
    public String getTaskId() {
        return this.taskId;
    }

    @Generated
    public String getGlobalTaskId() {
        return this.globalTaskId;
    }

    @Generated
    public int getDuration() {
        return this.duration;
    }

    @Generated
    public boolean isExecuteSubTasks() {
        return this.isExecuteSubTasks;
    }

    @Generated
    public boolean isRetryUpdateStartTime() {
        return this.isRetryUpdateStartTime;
    }

    @Generated
    public String getTaskName() {
        return this.taskName;
    }

    @Generated
    public String getTaskDescription() {
        return this.taskDescription;
    }

    @Generated
    public String getEventType() {
        return this.eventType;
    }

    @Generated
    public BaseTaskResult getTaskResult() {
        return this.taskResult;
    }

    @Generated
    public List<TaskOperateEnum> getSupportOperates() {
        return this.supportOperates;
    }

    @Generated
    public String getSkipMsg() {
        return this.skipMsg;
    }

    @Generated
    public List<BaseTask> getSubTasks() {
        return this.subTasks;
    }

    @Generated
    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    @Generated
    public void setTaskResult(BaseTaskResult taskResult) {
        this.taskResult = taskResult;
    }

    @Generated
    public void setSupportOperates(List<TaskOperateEnum> supportOperates) {
        this.supportOperates = supportOperates;
    }

    @Generated
    public void setSubTasks(List<BaseTask> subTasks) {
        this.subTasks = subTasks;
    }

    @Generated
    public static abstract class BaseTaskBuilder<C extends BaseTask, B extends BaseTaskBuilder<C, B>> {
        @Generated
        private boolean taskId$set;
        @Generated
        private String taskId$value;
        @Generated
        private String globalTaskId;
        @Generated
        private int duration;
        @Generated
        private boolean isExecuteSubTasks$set;
        @Generated
        private boolean isExecuteSubTasks$value;
        @Generated
        private boolean isRetryUpdateStartTime$set;
        @Generated
        private boolean isRetryUpdateStartTime$value;
        @Generated
        private String taskName;
        @Generated
        private String taskDescription;
        @Generated
        private String eventType;
        @Generated
        private boolean taskResult$set;
        @Generated
        private BaseTaskResult taskResult$value;
        @Generated
        private List<TaskOperateEnum> supportOperates;
        @Generated
        private String skipMsg;
        @Generated
        private List<BaseTask> subTasks;

        @Generated
        public B taskId(@NotNull String taskId) {
            this.taskId$value = taskId;
            this.taskId$set = true;
            return this.self();
        }

        @Generated
        public B globalTaskId(String globalTaskId) {
            this.globalTaskId = globalTaskId;
            return this.self();
        }

        @Generated
        public B duration(int duration) {
            this.duration = duration;
            return this.self();
        }

        @Generated
        public B isExecuteSubTasks(boolean isExecuteSubTasks) {
            this.isExecuteSubTasks$value = isExecuteSubTasks;
            this.isExecuteSubTasks$set = true;
            return this.self();
        }

        @Generated
        public B isRetryUpdateStartTime(boolean isRetryUpdateStartTime) {
            this.isRetryUpdateStartTime$value = isRetryUpdateStartTime;
            this.isRetryUpdateStartTime$set = true;
            return this.self();
        }

        @Generated
        public B taskName(String taskName) {
            this.taskName = taskName;
            return this.self();
        }

        @Generated
        public B taskDescription(String taskDescription) {
            this.taskDescription = taskDescription;
            return this.self();
        }

        @Generated
        public B eventType(String eventType) {
            this.eventType = eventType;
            return this.self();
        }

        @Generated
        public B taskResult(BaseTaskResult taskResult) {
            this.taskResult$value = taskResult;
            this.taskResult$set = true;
            return this.self();
        }

        @Generated
        public B supportOperates(List<TaskOperateEnum> supportOperates) {
            this.supportOperates = supportOperates;
            return this.self();
        }

        @Generated
        public B skipMsg(String skipMsg) {
            this.skipMsg = skipMsg;
            return this.self();
        }

        @Generated
        public B subTasks(List<BaseTask> subTasks) {
            this.subTasks = subTasks;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "BaseTask.BaseTaskBuilder(taskId$value=" + this.taskId$value + ", globalTaskId=" + this.globalTaskId + ", duration=" + this.duration + ", isExecuteSubTasks$value=" + this.isExecuteSubTasks$value + ", isRetryUpdateStartTime$value=" + this.isRetryUpdateStartTime$value + ", taskName=" + this.taskName + ", taskDescription=" + this.taskDescription + ", eventType=" + this.eventType + ", taskResult$value=" + this.taskResult$value + ", supportOperates=" + this.supportOperates + ", skipMsg=" + this.skipMsg + ", subTasks=" + this.subTasks + ")";
        }
    }
}

