/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.task;

import com.huawei.yinglong.river.deploy.virtualization.common.entity.DeployTaskDetailVo;
import com.huawei.yinglong.river.deploy.virtualization.common.entity.DeployTaskInfoVo;
import com.huawei.yinglong.river.sitedeployment.dcs.task.BaseTask;
import com.huawei.yinglong.river.sitedeployment.dcs.task.TaskStatus;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.NumberUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.TimeUtils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommonTaskManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommonTaskManager.class);
    private final Map<String, BaseTask> taskIdToTaskMap = new HashMap<String, BaseTask>();

    public static CommonTaskManager getInstance() {
        return TaskManagerHolder.INSTANCE;
    }

    public boolean addTask(@NotNull BaseTask task) {
        if (StringUtils.isEmpty(task.getTaskId())) {
            log.warn("task id is null,can not add");
            return false;
        }
        this.taskIdToTaskMap.put(task.getTaskId(), task);
        return true;
    }

    public boolean isTaskExecuted(String taskId) {
        return this.taskIdToTaskMap.containsKey(taskId);
    }

    public boolean startTaskById(@NotNull String taskId) {
        if (!this.taskIdToTaskMap.containsKey(taskId)) {
            log.warn("start task id [{}] not exists", (Object)taskId);
            return false;
        }
        BaseTask task = this.taskIdToTaskMap.get(taskId);
        if (!task.canStart()) {
            log.warn("task [{}] status is [{}],can not start", (Object)task.getTaskName(), (Object)task.getTaskResult().getTaskStatus());
            return false;
        }
        ThreadUtils.submit(task);
        return true;
    }

    public boolean startTaskById(@NotNull String taskId, ExecutorService executorService) {
        if (!this.taskIdToTaskMap.containsKey(taskId)) {
            log.warn("start task id [{}] not exists", (Object)taskId);
            return false;
        }
        BaseTask task = this.taskIdToTaskMap.get(taskId);
        if (!task.canStart()) {
            log.warn("task [{}] status is [{}],can not start", (Object)task.getTaskName(), (Object)task.getTaskResult().getTaskStatus());
            return false;
        }
        executorService.submit(task);
        return true;
    }

    public void setTaskStatus(String taskId, TaskStatus taskStatus) {
        this.queryTaskById(taskId).ifPresent(task -> task.setTaskStatus(taskStatus));
    }

    public void setFirstSubTaskStatus(String taskId, TaskStatus taskStatus) {
        this.queryTaskById(taskId).ifPresent(task -> task.getSubTasks().forEach(subTask -> subTask.setTaskStatus(taskStatus)));
    }

    public boolean skipSubTaskById(@NotNull String subTaskId) {
        return this.setSubTaskStatusBySubTaskId(subTaskId, BaseTask::setTaskSkip);
    }

    public boolean retrySubTaskById(@NotNull String subTaskId) {
        return this.setSubTaskStatusBySubTaskId(subTaskId, BaseTask::setTaskRetry);
    }

    private boolean setSubTaskStatusBySubTaskId(String subTaskId, Predicate<BaseTask> statusPredicate) {
        for (BaseTask task : this.taskIdToTaskMap.values()) {
            LinkedList<BaseTask> parentTasks;
            Optional<BaseTask> baseTask = this.searchTargetFromAllSubTasksByTaskId(subTaskId, task, parentTasks = new LinkedList<BaseTask>());
            if (!baseTask.isPresent()) {
                log.error("can not get target sub task");
                continue;
            }
            if (!statusPredicate.test(baseTask.get())) {
                log.error("can not set task [{}] status", (Object)baseTask.get().getTaskName());
                return false;
            }
            this.setTaskRetryForAllTask(baseTask.get(), statusPredicate);
            parentTasks.forEach(BaseTask::setTaskRetry);
            ThreadUtils.submit(task);
            return true;
        }
        return false;
    }

    private void setTaskRetryForAllTask(BaseTask baseTask, Predicate<BaseTask> statusPredicate) {
        statusPredicate.test(baseTask);
        if (CollectionUtils.isEmpty(baseTask.getSubTasks())) {
            return;
        }
        baseTask.getSubTasks().forEach(task -> this.setTaskRetryForAllTask((BaseTask)task, statusPredicate));
    }

    public boolean retryAllTaskById(@NotNull String taskId) {
        Optional<BaseTask> baseTask = this.taskIdToTaskMap.values().stream().filter(task -> task.getTaskId().equals(taskId)).findFirst();
        if (!baseTask.isPresent()) {
            log.error("can not find target task");
            return false;
        }
        BaseTask task2 = baseTask.get();
        if (!task2.isFinish()) {
            log.error("current task status is [{}],can not retry", (Object)task2.getTaskResult().getTaskStatus());
            return false;
        }
        this.clearTaskResult(task2);
        ThreadUtils.submit(task2);
        return true;
    }

    public void clearTaskResult(BaseTask task) {
        LinkedList<BaseTask> allSubTasks = new LinkedList<BaseTask>();
        this.getAllSubTasks(task, allSubTasks);
        allSubTasks.forEach(BaseTask::clearTaskResult);
    }

    public Optional<DeployTaskInfoVo> queryTaskDetailById(@NotNull String taskId) {
        return this.isIdExist(taskId) ? Optional.of(this.transferTaskInfoVo(this.taskIdToTaskMap.get(taskId))) : Optional.empty();
    }

    public Optional<BaseTask> queryTaskById(@NotNull String taskId) {
        return this.isIdExist(taskId) ? Optional.of(this.taskIdToTaskMap.get(taskId)) : Optional.empty();
    }

    Map<String, BaseTask> getTaskIdToTaskMap() {
        return this.taskIdToTaskMap;
    }

    private boolean isIdExist(String taskId) {
        if (!this.taskIdToTaskMap.containsKey(taskId)) {
            log.warn("query task id [{}] not exists", (Object)taskId);
            return false;
        }
        return true;
    }

    private DeployTaskInfoVo transferTaskInfoVo(BaseTask task) {
        return DeployTaskInfoVo.builder().beginTime(TimeUtils.transferLocalDataTimeToLong(task.getTaskResult().getStartTime())).finishTime(TimeUtils.transferLocalDataTimeToLong(task.getTaskResult().getEndTime())).state(task.getTaskResult().getTaskStatus().name()).children(this.buildChildrenTaskDetail(task)).build();
    }

    private DeployTaskDetailVo transferTaskDetails(BaseTask task) {
        return DeployTaskDetailVo.builder().id(task.getTaskId()).taskName(task.getTaskName()).durationTime(NumberUtils.parseDurationTime(task.getDuration())).state(task.getTaskResult().getTaskStatus().name()).beginTime(TimeUtils.transferLocalDataTimeToLong(task.getTaskResult().getStartTime())).finishTime(TimeUtils.transferLocalDataTimeToLong(task.getTaskResult().getEndTime())).suggestion(task.getTaskResult().getSuggestion()).errorMsg(task.getTaskResult().getErrorMessage()).detail(task.getDetail()).eventType(task.getEventType()).skipMsg(task.getSkipMsg()).taskId(StringUtils.defaultString(task.getGlobalTaskId(), task.getTaskId())).actions(ListUtils.emptyIfNull(task.getSupportOperates()).stream().map(Enum::name).collect(Collectors.toList())).children(this.buildChildrenTaskDetail(task)).build();
    }

    private List<DeployTaskDetailVo> buildChildrenTaskDetail(BaseTask task) {
        return ListUtils.emptyIfNull(task.getSubTasks()).stream().map(this::transferTaskDetails).collect(Collectors.toList());
    }

    private Optional<BaseTask> searchTargetFromAllSubTasksByTaskId(@NotNull String taskId, BaseTask task, List<BaseTask> parentTasks) {
        if (Objects.isNull(task)) {
            return Optional.empty();
        }
        if (taskId.equals(task.getTaskId())) {
            return Optional.of(task);
        }
        for (BaseTask subTask : ListUtils.emptyIfNull(task.getSubTasks())) {
            Optional<BaseTask> searchSubTask = this.searchTargetFromAllSubTasksByTaskId(taskId, subTask, parentTasks);
            if (!searchSubTask.isPresent()) continue;
            parentTasks.add(task);
            return searchSubTask;
        }
        return Optional.empty();
    }

    private void getAllSubTasks(BaseTask baseTask, List<BaseTask> allSubTasks) {
        if (Objects.isNull(baseTask)) {
            return;
        }
        allSubTasks.add(baseTask);
        ListUtils.emptyIfNull(baseTask.getSubTasks()).forEach(subTask -> this.getAllSubTasks((BaseTask)subTask, allSubTasks));
    }

    public <T> List<T> queryTaskByType(Class<T> taskType) {
        return this.taskIdToTaskMap.values().stream().filter(task -> taskType.isInstance(taskType)).map(taskType::cast).collect(Collectors.toList());
    }

    @Generated
    private CommonTaskManager() {
    }

    private static class TaskManagerHolder {
        static final CommonTaskManager INSTANCE = new CommonTaskManager();

        private TaskManagerHolder() {
        }
    }
}

